/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.list.impl;

import io.atomix.core.cache.CacheConfig;
import io.atomix.core.collection.impl.CachingAsyncDistributedCollection;
import io.atomix.core.list.AsyncDistributedList;
import io.atomix.core.list.DistributedList;
import io.atomix.core.list.impl.BlockingDistributedList;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

public class CachingAsyncDistributedList<E>
extends CachingAsyncDistributedCollection<E>
implements AsyncDistributedList<E> {
    private final AsyncDistributedList<E> backingList;

    public CachingAsyncDistributedList(AsyncDistributedList<E> backingCollection, CacheConfig cacheConfig) {
        super(backingCollection, cacheConfig);
        this.backingList = backingCollection;
    }

    @Override
    public CompletableFuture<Boolean> addAll(int index, Collection<? extends E> c) {
        return this.backingList.addAll(index, c).thenApply(result -> {
            this.cache.invalidateAll();
            return result;
        });
    }

    @Override
    public CompletableFuture<E> get(int index) {
        return this.backingList.get(index);
    }

    @Override
    public CompletableFuture<E> set(int index, E element) {
        return this.backingList.set(index, element).thenApply(result -> {
            this.cache.invalidate(element);
            return result;
        });
    }

    @Override
    public CompletableFuture<Void> add(int index, E element) {
        return this.backingList.add(index, element).thenApply(result -> {
            this.cache.invalidate(element);
            return result;
        });
    }

    @Override
    public CompletableFuture<E> remove(int index) {
        return this.backingList.remove(index).thenApply(result -> {
            this.cache.invalidate(result);
            return result;
        });
    }

    @Override
    public CompletableFuture<Integer> indexOf(Object o) {
        return this.backingList.indexOf(o);
    }

    @Override
    public CompletableFuture<Integer> lastIndexOf(Object o) {
        return this.backingList.lastIndexOf(o);
    }

    @Override
    public DistributedList<E> sync(Duration operationTimeout) {
        return new BlockingDistributedList(this, operationTimeout.toMillis());
    }
}

