/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.cluster.ClusterCallback;
import org.apache.zeppelin.cluster.ClusterManagerServer;
import org.apache.zeppelin.cluster.event.ClusterEvent;
import org.apache.zeppelin.cluster.event.ClusterEventListener;
import org.apache.zeppelin.cluster.meta.ClusterMeta;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.InterpreterOption;
import org.apache.zeppelin.interpreter.InterpreterRunner;
import org.apache.zeppelin.interpreter.launcher.ClusterInterpreterCheckThread;
import org.apache.zeppelin.interpreter.launcher.ClusterInterpreterProcess;
import org.apache.zeppelin.interpreter.launcher.DockerInterpreterLauncher;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.StandardInterpreterLauncher;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterRunningProcess;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterInterpreterLauncher
extends StandardInterpreterLauncher
implements ClusterEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterInterpreterLauncher.class);
    private InterpreterLaunchContext context;
    private ClusterManagerServer clusterServer;

    public ClusterInterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) throws IOException {
        super(zConf, recoveryStorage);
        this.clusterServer = ClusterManagerServer.getInstance((ZeppelinConfiguration)zConf);
        this.clusterServer.addClusterEventListeners(ClusterManagerServer.CLUSTER_INTP_EVENT_TOPIC, (ClusterEventListener)this);
    }

    public InterpreterClient launchDirectly(final InterpreterLaunchContext context) throws IOException {
        LOGGER.info("Launching Interpreter: " + context.getInterpreterSettingGroup());
        this.context = context;
        this.properties = context.getProperties();
        final int connectTimeout = this.getConnectTimeout();
        final String intpGroupId = context.getInterpreterGroupId();
        InterpreterClient intpClient = this.clusterServer.getIntpProcessStatus(intpGroupId, 3000, (ClusterCallback)new ClusterCallback<HashMap<String, Object>>(){

            public InterpreterClient online(HashMap<String, Object> result) {
                String intpTserverHost = (String)result.get(ClusterMeta.INTP_TSERVER_HOST);
                int intpTserverPort = (Integer)result.get(ClusterMeta.INTP_TSERVER_PORT);
                return new RemoteInterpreterRunningProcess(context.getInterpreterSettingName(), context.getInterpreterGroupId(), connectTimeout, ClusterInterpreterLauncher.this.getConnectPoolSize(), context.getIntpEventServerHost(), context.getIntpEventServerPort(), intpTserverHost, intpTserverPort, false);
            }

            public void offline() {
                LOGGER.info("interpreter {} is not exist!", (Object)intpGroupId);
            }
        });
        if (null != intpClient) {
            return intpClient;
        }
        String srvHost = null;
        int srvPort = 0;
        HashMap meta = this.clusterServer.getIdleNodeMeta();
        if (null == meta) {
            LOGGER.error("Don't get idle node meta, launch interpreter on local.");
            InterpreterClient clusterIntpProcess = this.createInterpreterProcess(context);
            try {
                clusterIntpProcess.start(context.getUserName());
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                return clusterIntpProcess;
            }
        } else {
            srvHost = (String)meta.get(ClusterMeta.SERVER_HOST);
            String localhost = RemoteInterpreterUtils.findAvailableHostAddress();
            if (localhost.equalsIgnoreCase(srvHost)) {
                LOGGER.info("launch interpreter on local");
                InterpreterClient clusterIntpProcess = this.createInterpreterProcess(context);
                try {
                    clusterIntpProcess.start(context.getUserName());
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return clusterIntpProcess;
                }
            } else {
                srvPort = (Integer)meta.get(ClusterMeta.SERVER_PORT);
                Gson gson = new Gson();
                String sContext = gson.toJson((Object)context);
                HashMap<String, Object> mapEvent = new HashMap<String, Object>();
                mapEvent.put("CLUSTER_EVENT", ClusterEvent.CREATE_INTP_PROCESS);
                mapEvent.put("CLUSTER_EVENT_MSG", sContext);
                String strEvent = gson.toJson(mapEvent);
                this.clusterServer.unicastClusterEvent(srvHost, srvPort, ClusterManagerServer.CLUSTER_INTP_EVENT_TOPIC, strEvent);
            }
        }
        final String finalSrvHost = srvHost;
        final int finalSrvPort = srvPort;
        intpClient = this.clusterServer.getIntpProcessStatus(intpGroupId, connectTimeout, (ClusterCallback)new ClusterCallback<HashMap<String, Object>>(){

            public InterpreterClient online(HashMap<String, Object> result) {
                String intpTserverHost = (String)result.get(ClusterMeta.INTP_TSERVER_HOST);
                int intpTserverPort = (Integer)result.get(ClusterMeta.INTP_TSERVER_PORT);
                return new RemoteInterpreterRunningProcess(context.getInterpreterSettingName(), context.getInterpreterGroupId(), connectTimeout, ClusterInterpreterLauncher.this.getConnectPoolSize(), context.getIntpEventServerHost(), context.getIntpEventServerPort(), intpTserverHost, intpTserverPort, false);
            }

            public void offline() {
                String errorInfo = String.format("Creating process %s failed on remote server %s:%d", intpGroupId, finalSrvHost, finalSrvPort);
                LOGGER.error(errorInfo);
            }
        });
        if (null == intpClient) {
            String errorInfo = String.format("Creating process %s failed on remote server %s:%d", intpGroupId, srvHost, srvPort);
            throw new IOException(errorInfo);
        }
        return intpClient;
    }

    public void onClusterEvent(String msg) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(msg);
        }
        try {
            Gson gson = new Gson();
            Map mapEvent = (Map)gson.fromJson(msg, new TypeToken<Map<String, Object>>(){}.getType());
            String sEvent = (String)mapEvent.get("CLUSTER_EVENT");
            ClusterEvent clusterEvent = ClusterEvent.valueOf((String)sEvent);
            switch (clusterEvent) {
                case CREATE_INTP_PROCESS: {
                    String eventMsg = (String)mapEvent.get("CLUSTER_EVENT_MSG");
                    InterpreterLaunchContext context = (InterpreterLaunchContext)gson.fromJson(eventMsg, new TypeToken<InterpreterLaunchContext>(){}.getType());
                    InterpreterClient intpProcess = this.createInterpreterProcess(context);
                    intpProcess.start(context.getUserName());
                    break;
                }
                default: {
                    LOGGER.error("Unknown clusterEvent:{}, msg:{} ", (Object)clusterEvent, (Object)msg);
                    break;
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private InterpreterClient createInterpreterProcess(InterpreterLaunchContext context) throws IOException {
        this.context = context;
        this.properties = context.getProperties();
        RemoteInterpreterProcess intpProcess = null;
        if (this.isRunningOnDocker(this.zConf)) {
            DockerInterpreterLauncher dockerIntpLauncher = new DockerInterpreterLauncher(this.zConf, null);
            dockerIntpLauncher.setProperties(context.getProperties());
            intpProcess = dockerIntpLauncher.launch(context);
        } else {
            intpProcess = this.createClusterIntpProcess();
        }
        ClusterInterpreterCheckThread intpCheckThread = new ClusterInterpreterCheckThread((InterpreterClient)intpProcess, context.getInterpreterGroupId(), this.getConnectTimeout());
        intpCheckThread.start();
        return intpProcess;
    }

    private RemoteInterpreterProcess createClusterIntpProcess() {
        ClusterInterpreterProcess clusterIntpProcess = null;
        try {
            InterpreterOption option = this.context.getOption();
            InterpreterRunner runner = this.context.getRunner();
            String intpSetGroupName = this.context.getInterpreterSettingGroup();
            String intpSetName = this.context.getInterpreterSettingName();
            int connectTimeout = this.getConnectTimeout();
            int connectionPoolSize = this.getConnectPoolSize();
            String localRepoPath = this.zConf.getInterpreterLocalRepoPath() + "/" + this.context.getInterpreterSettingId();
            clusterIntpProcess = new ClusterInterpreterProcess(runner != null ? runner.getPath() : this.zConf.getInterpreterRemoteRunnerPath(), this.context.getIntpEventServerPort(), this.context.getIntpEventServerHost(), this.zConf.getInterpreterPortRange(), this.zConf.getInterpreterDir() + "/" + intpSetGroupName, localRepoPath, this.buildEnvFromProperties(this.context), connectTimeout, connectionPoolSize, intpSetName, this.context.getInterpreterGroupId(), option.isUserImpersonate());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return clusterIntpProcess;
    }

    private boolean isRunningOnDocker(ZeppelinConfiguration zconf) {
        return zconf.getRunMode() == ZeppelinConfiguration.RUN_MODE.DOCKER;
    }
}

