/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.testing;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;

public class RemoteStorageHelper {
    private static final Logger log = Logger.getLogger(RemoteStorageHelper.class.getName());
    private static final String BUCKET_NAME_PREFIX = "gcloud-test-bucket-temp-";
    private final StorageOptions options;

    private RemoteStorageHelper(StorageOptions options) {
        this.options = options;
    }

    public StorageOptions getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean forceDelete(Storage storage, String bucket, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> future = executor.submit(new DeleteBucketTask(storage, bucket));
        try {
            Boolean bl = future.get(timeout, unit);
            return bl;
        }
        catch (TimeoutException ex) {
            Boolean bl = false;
            return bl;
        }
        finally {
            executor.shutdown();
        }
    }

    public static void forceDelete(Storage storage, String bucket) {
        new DeleteBucketTask(storage, bucket).call();
    }

    public static String generateBucketName() {
        return BUCKET_NAME_PREFIX + UUID.randomUUID().toString();
    }

    public static RemoteStorageHelper create(String projectId, InputStream keyStream) throws StorageHelperException {
        try {
            HttpTransportOptions transportOptions = StorageOptions.getDefaultHttpTransportOptions();
            transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
            StorageOptions storageOptions = ((StorageOptions.Builder)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)GoogleCredentials.fromStream((InputStream)keyStream))).setProjectId(projectId)).setRetrySettings(RemoteStorageHelper.retrySettings())).setTransportOptions((TransportOptions)transportOptions).build();
            return new RemoteStorageHelper(storageOptions);
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, ex.getMessage());
            }
            throw StorageHelperException.translate(ex);
        }
    }

    public static RemoteStorageHelper create() throws StorageHelperException {
        HttpTransportOptions transportOptions = StorageOptions.getDefaultHttpTransportOptions();
        transportOptions = transportOptions.toBuilder().setConnectTimeout(60000).setReadTimeout(60000).build();
        StorageOptions storageOptions = ((StorageOptions.Builder)StorageOptions.newBuilder().setRetrySettings(RemoteStorageHelper.retrySettings())).setTransportOptions((TransportOptions)transportOptions).build();
        return new RemoteStorageHelper(storageOptions);
    }

    private static RetrySettings retrySettings() {
        return RetrySettings.newBuilder().setMaxAttempts(10).setMaxRetryDelay(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.0).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).build();
    }

    public static class StorageHelperException
    extends RuntimeException {
        private static final long serialVersionUID = -7756074894502258736L;

        public StorageHelperException(String message) {
            super(message);
        }

        public StorageHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public static StorageHelperException translate(Exception ex) {
            return new StorageHelperException(ex.getMessage(), ex);
        }
    }

    private static class DeleteBucketTask
    implements Callable<Boolean> {
        private Storage storage;
        private String bucket;

        public DeleteBucketTask(Storage storage, String bucket) {
            this.storage = storage;
            this.bucket = bucket;
        }

        @Override
        public Boolean call() {
            while (true) {
                for (BlobInfo info : this.storage.list(this.bucket, Storage.BlobListOption.versions(true)).getValues()) {
                    this.storage.delete(info.getBlobId());
                }
                try {
                    this.storage.delete(this.bucket, new Storage.BucketSourceOption[0]);
                    return true;
                }
                catch (StorageException e) {
                    if (e.getCode() == 409) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            throw e;
                        }
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
    }
}

