/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.method.MethodConstraintViolationException;
import org.hibernate.validator.method.MethodValidator;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.annotation.Validated;

public class MethodValidationInterceptor
implements MethodInterceptor {
    private static Method forExecutablesMethod;
    private static Method validateParametersMethod;
    private static Method validateReturnValueMethod;
    private volatile Validator validator;

    public MethodValidationInterceptor() {
        this(forExecutablesMethod != null ? Validation.buildDefaultValidatorFactory() : HibernateValidatorDelegate.buildValidatorFactory());
    }

    public MethodValidationInterceptor(ValidatorFactory validatorFactory) {
        this(validatorFactory.getValidator());
    }

    public MethodValidationInterceptor(Validator validator) {
        this.validator = validator;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?>[] groups = this.determineValidationGroups(invocation);
        if (forExecutablesMethod != null) {
            Set result2;
            Object execVal;
            try {
                execVal = ReflectionUtils.invokeMethod(forExecutablesMethod, this.validator);
            }
            catch (AbstractMethodError err2) {
                Validator nativeValidator = (Validator)this.validator.unwrap(Validator.class);
                execVal = ReflectionUtils.invokeMethod(forExecutablesMethod, nativeValidator);
                this.validator = nativeValidator;
            }
            Method methodToValidate = invocation.getMethod();
            try {
                result2 = (Set)ReflectionUtils.invokeMethod(validateParametersMethod, execVal, invocation.getThis(), methodToValidate, invocation.getArguments(), groups);
            }
            catch (IllegalArgumentException ex) {
                methodToValidate = BridgeMethodResolver.findBridgedMethod(ClassUtils.getMostSpecificMethod(invocation.getMethod(), invocation.getThis().getClass()));
                result2 = (Set)ReflectionUtils.invokeMethod(validateParametersMethod, execVal, invocation.getThis(), methodToValidate, invocation.getArguments(), groups);
            }
            if (!result2.isEmpty()) {
                throw new ConstraintViolationException(result2);
            }
            Object returnValue = invocation.proceed();
            result2 = (Set)ReflectionUtils.invokeMethod(validateReturnValueMethod, execVal, invocation.getThis(), methodToValidate, returnValue, groups);
            if (!result2.isEmpty()) {
                throw new ConstraintViolationException(result2);
            }
            return returnValue;
        }
        return HibernateValidatorDelegate.invokeWithinValidation(invocation, this.validator, groups);
    }

    protected Class<?>[] determineValidationGroups(MethodInvocation invocation) {
        Validated validatedAnn = AnnotationUtils.findAnnotation(invocation.getMethod(), Validated.class);
        if (validatedAnn == null) {
            validatedAnn = AnnotationUtils.findAnnotation(invocation.getThis().getClass(), Validated.class);
        }
        return validatedAnn != null ? validatedAnn.value() : new Class[]{};
    }

    static {
        try {
            forExecutablesMethod = Validator.class.getMethod("forExecutables", new Class[0]);
            Class<?> executableValidatorClass = forExecutablesMethod.getReturnType();
            validateParametersMethod = executableValidatorClass.getMethod("validateParameters", Object.class, Method.class, Object[].class, Class[].class);
            validateReturnValueMethod = executableValidatorClass.getMethod("validateReturnValue", Object.class, Method.class, Object.class, Class[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class HibernateValidatorDelegate {
        private HibernateValidatorDelegate() {
        }

        public static ValidatorFactory buildValidatorFactory() {
            return ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).buildValidatorFactory();
        }

        public static Object invokeWithinValidation(MethodInvocation invocation, Validator validator, Class<?>[] groups) throws Throwable {
            MethodValidator methodValidator = (MethodValidator)validator.unwrap(MethodValidator.class);
            Set result2 = methodValidator.validateAllParameters(invocation.getThis(), invocation.getMethod(), invocation.getArguments(), (Class[])groups);
            if (!result2.isEmpty()) {
                throw new MethodConstraintViolationException(result2);
            }
            Object returnValue = invocation.proceed();
            result2 = methodValidator.validateReturnValue(invocation.getThis(), invocation.getMethod(), returnValue, (Class[])groups);
            if (!result2.isEmpty()) {
                throw new MethodConstraintViolationException(result2);
            }
            return returnValue;
        }
    }
}

