/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class ReflectionUtils {
    private static final String CGLIB_RENAMED_METHOD_PREFIX = "CGLIB$";
    private static final Method[] NO_METHODS = new Method[0];
    private static final Field[] NO_FIELDS = new Field[0];
    private static final Map<Class<?>, Method[]> declaredMethodsCache = new ConcurrentReferenceHashMap(256);
    private static final Map<Class<?>, Field[]> declaredFieldsCache = new ConcurrentReferenceHashMap(256);
    public static final FieldFilter COPYABLE_FIELDS = new FieldFilter(){

        @Override
        public boolean matches(Field field2) {
            return !Modifier.isStatic(field2.getModifiers()) && !Modifier.isFinal(field2.getModifiers());
        }
    };
    public static final MethodFilter NON_BRIDGED_METHODS = new MethodFilter(){

        @Override
        public boolean matches(Method method) {
            return !method.isBridge();
        }
    };
    public static final MethodFilter USER_DECLARED_METHODS = new MethodFilter(){

        @Override
        public boolean matches(Method method) {
            return !method.isBridge() && method.getDeclaringClass() != Object.class;
        }
    };

    public static Field findField(Class<?> clazz2, String name) {
        return ReflectionUtils.findField(clazz2, name, null);
    }

    public static Field findField(Class<?> clazz2, String name, Class<?> type) {
        Assert.notNull(clazz2, "Class must not be null");
        Assert.isTrue(name != null || type != null, "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz2; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field2 : fields = ReflectionUtils.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field2.getName()) || type != null && !type.equals(field2.getType())) continue;
                return field2;
            }
        }
        return null;
    }

    public static void setField(Field field2, Object target, Object value2) {
        try {
            field2.set(target, value2);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Object getField(Field field2, Object target) {
        try {
            return field2.get(target);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    public static Method findMethod(Class<?> clazz2, String name) {
        return ReflectionUtils.findMethod(clazz2, name, new Class[0]);
    }

    public static Method findMethod(Class<?> clazz2, String name, Class<?> ... paramTypes2) {
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(name, "Method name must not be null");
        for (Class<?> searchType = clazz2; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods2;
            for (Method method : methods2 = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || paramTypes2 != null && !Arrays.equals(paramTypes2, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target) {
        return ReflectionUtils.invokeMethod(method, target, new Object[0]);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args2) {
        try {
            return method.invoke(target, args2);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeJdbcMethod(Method method, Object target) throws SQLException {
        return ReflectionUtils.invokeJdbcMethod(method, target, new Object[0]);
    }

    public static Object invokeJdbcMethod(Method method, Object target, Object ... args2) throws SQLException {
        try {
            return method.invoke(target, args2);
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof SQLException) {
                throw (SQLException)ex.getTargetException();
            }
            ReflectionUtils.handleInvocationTargetException(ex);
        }
        throw new IllegalStateException("Should never get here");
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ReflectionUtils.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        Assert.notNull(method, "Method must not be null");
        for (Class<?> declaredException : declaredExceptions = method.getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublicStaticFinal(Field field2) {
        int modifiers = field2.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !method.getName().equals("equals")) {
            return false;
        }
        Class<?>[] paramTypes2 = method.getParameterTypes();
        return paramTypes2.length == 1 && paramTypes2[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getParameterTypes().length == 0;
    }

    public static boolean isObjectMethod(Method method) {
        if (method == null) {
            return false;
        }
        try {
            Object.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isCglibRenamedMethod(Method renamedMethod) {
        String name = renamedMethod.getName();
        if (name.startsWith(CGLIB_RENAMED_METHOD_PREFIX)) {
            int i;
            for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
            }
            return i > CGLIB_RENAMED_METHOD_PREFIX.length() && i < name.length() - 1 && name.charAt(i) == '$';
        }
        return false;
    }

    public static void makeAccessible(Field field2) {
        if (!(Modifier.isPublic(field2.getModifiers()) && Modifier.isPublic(field2.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field2.getModifiers()) || field2.isAccessible())) {
            field2.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static void doWithLocalMethods(Class<?> clazz2, MethodCallback mc) {
        Method[] methods2;
        for (Method method : methods2 = ReflectionUtils.getDeclaredMethods(clazz2)) {
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
    }

    public static void doWithMethods(Class<?> clazz2, MethodCallback mc) {
        ReflectionUtils.doWithMethods(clazz2, mc, null);
    }

    public static void doWithMethods(Class<?> clazz2, MethodCallback mc, MethodFilter mf) {
        Method[] methods2 = ReflectionUtils.getDeclaredMethods(clazz2);
        for (Method method : methods2) {
            if (mf != null && !mf.matches(method)) continue;
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
        if (clazz2.getSuperclass() != null) {
            ReflectionUtils.doWithMethods(clazz2.getSuperclass(), mc, mf);
        } else if (clazz2.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz2.getInterfaces()) {
                ReflectionUtils.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) {
        final ArrayList methods2 = new ArrayList(32);
        ReflectionUtils.doWithMethods(leafClass, new MethodCallback(){

            @Override
            public void doWith(Method method) {
                methods2.add(method);
            }
        });
        return methods2.toArray(new Method[methods2.size()]);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass) {
        final ArrayList methods2 = new ArrayList(32);
        ReflectionUtils.doWithMethods(leafClass, new MethodCallback(){

            @Override
            public void doWith(Method method) {
                boolean knownSignature = false;
                Method methodBeingOverriddenWithCovariantReturnType = null;
                for (Method existingMethod : methods2) {
                    if (!method.getName().equals(existingMethod.getName()) || !Arrays.equals(method.getParameterTypes(), existingMethod.getParameterTypes())) continue;
                    if (existingMethod.getReturnType() != method.getReturnType() && existingMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                        methodBeingOverriddenWithCovariantReturnType = existingMethod;
                        break;
                    }
                    knownSignature = true;
                    break;
                }
                if (methodBeingOverriddenWithCovariantReturnType != null) {
                    methods2.remove(methodBeingOverriddenWithCovariantReturnType);
                }
                if (!knownSignature && !ReflectionUtils.isCglibRenamedMethod(method)) {
                    methods2.add(method);
                }
            }
        });
        return methods2.toArray(new Method[methods2.size()]);
    }

    private static Method[] getDeclaredMethods(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        Method[] result2 = declaredMethodsCache.get(clazz2);
        if (result2 == null) {
            Method[] declaredMethods = clazz2.getDeclaredMethods();
            List<Method> defaultMethods = ReflectionUtils.findConcreteMethodsOnInterfaces(clazz2);
            if (defaultMethods != null) {
                result2 = new Method[declaredMethods.length + defaultMethods.size()];
                System.arraycopy(declaredMethods, 0, result2, 0, declaredMethods.length);
                int index2 = declaredMethods.length;
                Iterator<Method> iterator2 = defaultMethods.iterator();
                while (iterator2.hasNext()) {
                    Method defaultMethod;
                    result2[index2] = defaultMethod = iterator2.next();
                    ++index2;
                }
            } else {
                result2 = declaredMethods;
            }
            declaredMethodsCache.put(clazz2, result2.length == 0 ? NO_METHODS : result2);
        }
        return result2;
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz2) {
        LinkedList<Method> result2 = null;
        for (Class<?> ifc : clazz2.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result2 == null) {
                    result2 = new LinkedList<Method>();
                }
                result2.add(ifcMethod);
            }
        }
        return result2;
    }

    public static void doWithLocalFields(Class<?> clazz2, FieldCallback fc) {
        for (Field field2 : ReflectionUtils.getDeclaredFields(clazz2)) {
            try {
                fc.doWith(field2);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access field '" + field2.getName() + "': " + ex);
            }
        }
    }

    public static void doWithFields(Class<?> clazz2, FieldCallback fc) {
        ReflectionUtils.doWithFields(clazz2, fc, null);
    }

    public static void doWithFields(Class<?> clazz2, FieldCallback fc, FieldFilter ff) {
        Class<?> targetClass = clazz2;
        do {
            Field[] fields;
            for (Field field2 : fields = ReflectionUtils.getDeclaredFields(targetClass)) {
                if (ff != null && !ff.matches(field2)) continue;
                try {
                    fc.doWith(field2);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Not allowed to access field '" + field2.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private static Field[] getDeclaredFields(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        Field[] result2 = declaredFieldsCache.get(clazz2);
        if (result2 == null) {
            result2 = clazz2.getDeclaredFields();
            declaredFieldsCache.put(clazz2, result2.length == 0 ? NO_FIELDS : result2);
        }
        return result2;
    }

    public static void shallowCopyFieldState(final Object src, final Object dest) {
        Assert.notNull(src, "Source for field copy cannot be null");
        Assert.notNull(dest, "Destination for field copy cannot be null");
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ReflectionUtils.doWithFields(src.getClass(), new FieldCallback(){

            @Override
            public void doWith(Field field2) throws IllegalArgumentException, IllegalAccessException {
                ReflectionUtils.makeAccessible(field2);
                Object srcValue = field2.get(src);
                field2.set(dest, srcValue);
            }
        }, COPYABLE_FIELDS);
    }

    public static void clearCache() {
        declaredMethodsCache.clear();
        declaredFieldsCache.clear();
    }

    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

