/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class NumberUtils {
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final Set<Class<?>> STANDARD_NUMBER_TYPES;

    public static <T extends Number> T convertNumberToTargetClass(Number number2, Class<T> targetClass) throws IllegalArgumentException {
        Assert.notNull(number2, "Number must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        if (targetClass.isInstance(number2)) {
            return (T)number2;
        }
        if (Byte.class == targetClass) {
            long value2 = NumberUtils.checkedLongValue(number2, targetClass);
            if (value2 < -128L || value2 > 127L) {
                NumberUtils.raiseOverflowException(number2, targetClass);
            }
            return (T)Byte.valueOf(number2.byteValue());
        }
        if (Short.class == targetClass) {
            long value3 = NumberUtils.checkedLongValue(number2, targetClass);
            if (value3 < -32768L || value3 > 32767L) {
                NumberUtils.raiseOverflowException(number2, targetClass);
            }
            return (T)Short.valueOf(number2.shortValue());
        }
        if (Integer.class == targetClass) {
            long value4 = NumberUtils.checkedLongValue(number2, targetClass);
            if (value4 < Integer.MIN_VALUE || value4 > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number2, targetClass);
            }
            return (T)Integer.valueOf(number2.intValue());
        }
        if (Long.class == targetClass) {
            long value5 = NumberUtils.checkedLongValue(number2, targetClass);
            return (T)Long.valueOf(value5);
        }
        if (BigInteger.class == targetClass) {
            if (number2 instanceof BigDecimal) {
                return (T)((BigDecimal)number2).toBigInteger();
            }
            return (T)BigInteger.valueOf(number2.longValue());
        }
        if (Float.class == targetClass) {
            return (T)Float.valueOf(number2.floatValue());
        }
        if (Double.class == targetClass) {
            return (T)Double.valueOf(number2.doubleValue());
        }
        if (BigDecimal.class == targetClass) {
            return (T)new BigDecimal(number2.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number2 + "] of type [" + number2.getClass().getName() + "] to unsupported target class [" + targetClass.getName() + "]");
    }

    private static long checkedLongValue(Number number2, Class<? extends Number> targetClass) {
        BigInteger bigInt = null;
        if (number2 instanceof BigInteger) {
            bigInt = (BigInteger)number2;
        } else if (number2 instanceof BigDecimal) {
            bigInt = ((BigDecimal)number2).toBigInteger();
        }
        if (bigInt != null && (bigInt.compareTo(LONG_MIN) < 0 || bigInt.compareTo(LONG_MAX) > 0)) {
            NumberUtils.raiseOverflowException(number2, targetClass);
        }
        return number2.longValue();
    }

    private static void raiseOverflowException(Number number2, Class<?> targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number2 + "] of type [" + number2.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    public static <T extends Number> T parseNumber(String text2, Class<T> targetClass) {
        Assert.notNull(text2, "Text must not be null");
        Assert.notNull(targetClass, "Target class must not be null");
        String trimmed = StringUtils.trimAllWhitespace(text2);
        if (Byte.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Byte.decode(trimmed) : Byte.valueOf(trimmed));
        }
        if (Short.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Short.decode(trimmed) : Short.valueOf(trimmed));
        }
        if (Integer.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Integer.decode(trimmed) : Integer.valueOf(trimmed));
        }
        if (Long.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? Long.decode(trimmed) : Long.valueOf(trimmed));
        }
        if (BigInteger.class == targetClass) {
            return (T)(NumberUtils.isHexNumber(trimmed) ? NumberUtils.decodeBigInteger(trimmed) : new BigInteger(trimmed));
        }
        if (Float.class == targetClass) {
            return (T)Float.valueOf(trimmed);
        }
        if (Double.class == targetClass) {
            return (T)Double.valueOf(trimmed);
        }
        if (BigDecimal.class == targetClass || Number.class == targetClass) {
            return (T)new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text2 + "] to target class [" + targetClass.getName() + "]");
    }

    public static <T extends Number> T parseNumber(String text2, Class<T> targetClass, NumberFormat numberFormat) {
        if (numberFormat != null) {
            Assert.notNull(text2, "Text must not be null");
            Assert.notNull(targetClass, "Target class must not be null");
            DecimalFormat decimalFormat = null;
            boolean resetBigDecimal = false;
            if (numberFormat instanceof DecimalFormat) {
                decimalFormat = (DecimalFormat)numberFormat;
                if (BigDecimal.class == targetClass && !decimalFormat.isParseBigDecimal()) {
                    decimalFormat.setParseBigDecimal(true);
                    resetBigDecimal = true;
                }
            }
            try {
                Number number2 = numberFormat.parse(StringUtils.trimAllWhitespace(text2));
                T t = NumberUtils.convertNumberToTargetClass(number2, targetClass);
                return t;
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not parse number: " + ex.getMessage());
            }
            finally {
                if (resetBigDecimal) {
                    decimalFormat.setParseBigDecimal(false);
                }
            }
        }
        return NumberUtils.parseNumber(text2, targetClass);
    }

    private static boolean isHexNumber(String value2) {
        int index2 = value2.startsWith("-") ? 1 : 0;
        return value2.startsWith("0x", index2) || value2.startsWith("0X", index2) || value2.startsWith("#", index2);
    }

    private static BigInteger decodeBigInteger(String value2) {
        int radix = 10;
        int index2 = 0;
        boolean negative = false;
        if (value2.startsWith("-")) {
            negative = true;
            ++index2;
        }
        if (value2.startsWith("0x", index2) || value2.startsWith("0X", index2)) {
            index2 += 2;
            radix = 16;
        } else if (value2.startsWith("#", index2)) {
            ++index2;
            radix = 16;
        } else if (value2.startsWith("0", index2) && value2.length() > 1 + index2) {
            ++index2;
            radix = 8;
        }
        BigInteger result2 = new BigInteger(value2.substring(index2), radix);
        return negative ? result2.negate() : result2;
    }

    static {
        HashSet<Class> numberTypes = new HashSet<Class>(8);
        numberTypes.add(Byte.class);
        numberTypes.add(Short.class);
        numberTypes.add(Integer.class);
        numberTypes.add(Long.class);
        numberTypes.add(BigInteger.class);
        numberTypes.add(Float.class);
        numberTypes.add(Double.class);
        numberTypes.add(BigDecimal.class);
        STANDARD_NUMBER_TYPES = Collections.unmodifiableSet(numberTypes);
    }
}

