/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.beans.Introspector;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public abstract class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';
    private static final char INNER_CLASS_SEPARATOR = '$';
    public static final String CGLIB_CLASS_SEPARATOR = "$$";
    public static final String CLASS_FILE_SUFFIX = ".class";
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new IdentityHashMap(8);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new IdentityHashMap(8);
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);
    private static final Map<String, Class<?>> commonClassCache = new HashMap(32);

    private static void registerCommonClasses(Class<?> ... commonClasses) {
        for (Class<?> clazz2 : commonClasses) {
            commonClassCache.put(clazz2.getName(), clazz2);
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
        }
        return cl;
    }

    public static ClassLoader overrideThreadContextClassLoader(ClassLoader classLoaderToUse) {
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        if (classLoaderToUse != null && !classLoaderToUse.equals(threadContextClassLoader)) {
            currentThread.setContextClassLoader(classLoaderToUse);
            return threadContextClassLoader;
        }
        return null;
    }

    public static Class<?> forName(String name, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Assert.notNull(name, "Name must not be null");
        Class<?> clazz2 = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz2 == null) {
            clazz2 = commonClassCache.get(name);
        }
        if (clazz2 != null) {
            return clazz2;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
            String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
            String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
            Class<?> elementClass = ClassUtils.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader clToUse = classLoader;
        if (clToUse == null) {
            clToUse = ClassUtils.getDefaultClassLoader();
        }
        try {
            return clToUse != null ? clToUse.loadClass(name) : Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
                try {
                    return clToUse != null ? clToUse.loadClass(innerClassName) : Class.forName(innerClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static Class<?> resolveClassName(String className, ClassLoader classLoader) throws IllegalArgumentException {
        try {
            return ClassUtils.forName(className, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not find class [" + className + "]", ex);
        }
        catch (LinkageError err2) {
            throw new IllegalArgumentException("Unresolvable class definition for class [" + className + "]", err2);
        }
    }

    public static boolean isPresent(String className, ClassLoader classLoader) {
        try {
            ClassUtils.forName(className, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isVisible(Class<?> clazz2, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            return clazz2 == classLoader.loadClass(clazz2.getName());
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean isCacheSafe(Class<?> clazz2, ClassLoader classLoader) {
        Assert.notNull(clazz2, "Class must not be null");
        try {
            ClassLoader target = clazz2.getClassLoader();
            if (target == classLoader || target == null) {
                return true;
            }
            if (classLoader == null) {
                return false;
            }
            ClassLoader current = classLoader;
            while (current != null) {
                if ((current = current.getParent()) != target) continue;
                return true;
            }
            while (target != null) {
                if ((target = target.getParent()) != classLoader) continue;
                return false;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return classLoader != null && ClassUtils.isVisible(clazz2, classLoader);
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result2 = null;
        if (name != null && name.length() <= 8) {
            result2 = primitiveTypeNameMap.get(name);
        }
        return result2;
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return primitiveWrapperTypeMap.containsKey(clazz2);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return clazz2.isPrimitive() || ClassUtils.isPrimitiveWrapper(clazz2);
    }

    public static boolean isPrimitiveArray(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return clazz2.isArray() && clazz2.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return clazz2.isArray() && ClassUtils.isPrimitiveWrapper(clazz2.getComponentType());
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return clazz2.isPrimitive() && clazz2 != Void.TYPE ? primitiveTypeToWrapperMap.get(clazz2) : clazz2;
    }

    public static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        Class<?> resolvedWrapper;
        Class<?> resolvedPrimitive;
        Assert.notNull(lhsType, "Left-hand side type must not be null");
        Assert.notNull(rhsType, "Right-hand side type must not be null");
        if (lhsType.isAssignableFrom(rhsType)) {
            return true;
        }
        return lhsType.isPrimitive() ? lhsType == (resolvedPrimitive = primitiveWrapperTypeMap.get(rhsType)) : (resolvedWrapper = primitiveTypeToWrapperMap.get(rhsType)) != null && lhsType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isAssignableValue(Class<?> type, Object value2) {
        Assert.notNull(type, "Type must not be null");
        return value2 != null ? ClassUtils.isAssignable(type, value2.getClass()) : !type.isPrimitive();
    }

    public static String convertResourcePathToClassName(String resourcePath) {
        Assert.notNull(resourcePath, "Resource path must not be null");
        return resourcePath.replace('/', '.');
    }

    public static String convertClassNameToResourcePath(String className) {
        Assert.notNull(className, "Class name must not be null");
        return className.replace('.', '/');
    }

    public static String addResourcePathToPackagePath(Class<?> clazz2, String resourceName) {
        Assert.notNull(resourceName, "Resource name must not be null");
        if (!resourceName.startsWith("/")) {
            return ClassUtils.classPackageAsResourcePath(clazz2) + '/' + resourceName;
        }
        return ClassUtils.classPackageAsResourcePath(clazz2) + resourceName;
    }

    public static String classPackageAsResourcePath(Class<?> clazz2) {
        if (clazz2 == null) {
            return "";
        }
        String className = clazz2.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, packageEndIndex);
        return packageName.replace('.', '/');
    }

    public static String classNamesToString(Class<?> ... classes2) {
        return ClassUtils.classNamesToString(Arrays.asList(classes2));
    }

    public static String classNamesToString(Collection<Class<?>> classes2) {
        if (CollectionUtils.isEmpty(classes2)) {
            return ARRAY_SUFFIX;
        }
        StringBuilder sb = new StringBuilder(INTERNAL_ARRAY_PREFIX);
        Iterator<Class<?>> it = classes2.iterator();
        while (it.hasNext()) {
            Class<?> clazz2 = it.next();
            sb.append(clazz2.getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static Class<?>[] toClassArray(Collection<Class<?>> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new Class[collection.size()]);
    }

    public static Class<?>[] getAllInterfaces(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClass(instance.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz2) {
        return ClassUtils.getAllInterfacesForClass(clazz2, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz2, ClassLoader classLoader) {
        return ClassUtils.toClassArray(ClassUtils.getAllInterfacesForClassAsSet(clazz2, classLoader));
    }

    public static Set<Class<?>> getAllInterfacesAsSet(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getAllInterfacesForClassAsSet(instance.getClass());
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz2) {
        return ClassUtils.getAllInterfacesForClassAsSet(clazz2, null);
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz2, ClassLoader classLoader) {
        Assert.notNull(clazz2, "Class must not be null");
        if (clazz2.isInterface() && ClassUtils.isVisible(clazz2, classLoader)) {
            return Collections.singleton(clazz2);
        }
        LinkedHashSet interfaces2 = new LinkedHashSet();
        for (Class<?> current = clazz2; current != null; current = current.getSuperclass()) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = current.getInterfaces()) {
                interfaces2.addAll(ClassUtils.getAllInterfacesForClassAsSet(ifc, classLoader));
            }
        }
        return interfaces2;
    }

    public static Class<?> createCompositeInterface(Class<?>[] interfaces2, ClassLoader classLoader) {
        Assert.notEmpty(interfaces2, "Interfaces must not be empty");
        return Proxy.getProxyClass(classLoader, interfaces2);
    }

    public static Class<?> determineCommonAncestor(Class<?> clazz1, Class<?> clazz2) {
        if (clazz1 == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz1;
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return clazz1;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return clazz2;
        }
        Class<?> ancestor = clazz1;
        do {
            if ((ancestor = ancestor.getSuperclass()) != null && Object.class != ancestor) continue;
            return null;
        } while (!ancestor.isAssignableFrom(clazz2));
        return ancestor;
    }

    public static boolean isCglibProxy(Object object) {
        return ClassUtils.isCglibProxyClass(object.getClass());
    }

    public static boolean isCglibProxyClass(Class<?> clazz2) {
        return clazz2 != null && ClassUtils.isCglibProxyClassName(clazz2.getName());
    }

    public static boolean isCglibProxyClassName(String className) {
        return className != null && className.contains(CGLIB_CLASS_SEPARATOR);
    }

    public static Class<?> getUserClass(Object instance) {
        Assert.notNull(instance, "Instance must not be null");
        return ClassUtils.getUserClass(instance.getClass());
    }

    public static Class<?> getUserClass(Class<?> clazz2) {
        Class<?> superclass;
        if (clazz2 != null && clazz2.getName().contains(CGLIB_CLASS_SEPARATOR) && (superclass = clazz2.getSuperclass()) != null && Object.class != superclass) {
            return superclass;
        }
        return clazz2;
    }

    public static String getDescriptiveType(Object value2) {
        if (value2 == null) {
            return null;
        }
        Class<?> clazz2 = value2.getClass();
        if (Proxy.isProxyClass(clazz2)) {
            StringBuilder result2 = new StringBuilder(clazz2.getName());
            result2.append(" implementing ");
            Class<?>[] ifcs = clazz2.getInterfaces();
            for (int i = 0; i < ifcs.length; ++i) {
                result2.append(ifcs[i].getName());
                if (i >= ifcs.length - 1) continue;
                result2.append(',');
            }
            return result2.toString();
        }
        if (clazz2.isArray()) {
            return ClassUtils.getQualifiedNameForArray(clazz2);
        }
        return clazz2.getName();
    }

    public static boolean matchesTypeName(Class<?> clazz2, String typeName) {
        return typeName != null && (typeName.equals(clazz2.getName()) || typeName.equals(clazz2.getSimpleName()) || clazz2.isArray() && typeName.equals(ClassUtils.getQualifiedNameForArray(clazz2)));
    }

    public static String getShortName(String className) {
        Assert.hasLength(className, "Class name must not be empty");
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf(CGLIB_CLASS_SEPARATOR);
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    public static String getShortName(Class<?> clazz2) {
        return ClassUtils.getShortName(ClassUtils.getQualifiedName(clazz2));
    }

    public static String getShortNameAsProperty(Class<?> clazz2) {
        String shortName = ClassUtils.getShortName(clazz2);
        int dotIndex = shortName.lastIndexOf(46);
        shortName = dotIndex != -1 ? shortName.substring(dotIndex + 1) : shortName;
        return Introspector.decapitalize(shortName);
    }

    public static String getClassFileName(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        String className = clazz2.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return className.substring(lastDotIndex + 1) + CLASS_FILE_SUFFIX;
    }

    public static String getPackageName(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        return ClassUtils.getPackageName(clazz2.getName());
    }

    public static String getPackageName(String fqClassName) {
        Assert.notNull(fqClassName, "Class name must not be null");
        int lastDotIndex = fqClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }

    public static String getQualifiedName(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        if (clazz2.isArray()) {
            return ClassUtils.getQualifiedNameForArray(clazz2);
        }
        return clazz2.getName();
    }

    private static String getQualifiedNameForArray(Class<?> clazz2) {
        StringBuilder result2 = new StringBuilder();
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
            result2.append(ARRAY_SUFFIX);
        }
        result2.insert(0, clazz2.getName());
        return result2.toString();
    }

    public static String getQualifiedMethodName(Method method) {
        return ClassUtils.getQualifiedMethodName(method, null);
    }

    public static String getQualifiedMethodName(Method method, Class<?> clazz2) {
        Assert.notNull(method, "Method must not be null");
        return (clazz2 != null ? clazz2 : method.getDeclaringClass()).getName() + '.' + method.getName();
    }

    public static boolean hasConstructor(Class<?> clazz2, Class<?> ... paramTypes2) {
        return ClassUtils.getConstructorIfAvailable(clazz2, paramTypes2) != null;
    }

    public static <T> Constructor<T> getConstructorIfAvailable(Class<T> clazz2, Class<?> ... paramTypes2) {
        Assert.notNull(clazz2, "Class must not be null");
        try {
            return clazz2.getConstructor(paramTypes2);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static boolean hasMethod(Class<?> clazz2, String methodName, Class<?> ... paramTypes2) {
        return ClassUtils.getMethodIfAvailable(clazz2, methodName, paramTypes2) != null;
    }

    public static Method getMethod(Class<?> clazz2, String methodName, Class<?> ... paramTypes2) {
        Method[] methods2;
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        if (paramTypes2 != null) {
            try {
                return clazz2.getMethod(methodName, paramTypes2);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Expected method not found: " + ex);
            }
        }
        HashSet<Method> candidates2 = new HashSet<Method>(1);
        for (Method method : methods2 = clazz2.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            candidates2.add(method);
        }
        if (candidates2.size() == 1) {
            return (Method)candidates2.iterator().next();
        }
        if (candidates2.isEmpty()) {
            throw new IllegalStateException("Expected method not found: " + clazz2.getName() + '.' + methodName);
        }
        throw new IllegalStateException("No unique method found: " + clazz2.getName() + '.' + methodName);
    }

    public static Method getMethodIfAvailable(Class<?> clazz2, String methodName, Class<?> ... paramTypes2) {
        Method[] methods2;
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        if (paramTypes2 != null) {
            try {
                return clazz2.getMethod(methodName, paramTypes2);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
        HashSet<Method> candidates2 = new HashSet<Method>(1);
        for (Method method : methods2 = clazz2.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            candidates2.add(method);
        }
        if (candidates2.size() == 1) {
            return (Method)candidates2.iterator().next();
        }
        return null;
    }

    public static int getMethodCountForName(Class<?> clazz2, String methodName) {
        Class<?>[] ifcs;
        Method[] declaredMethods;
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        int count2 = 0;
        for (Method method : declaredMethods = clazz2.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            ++count2;
        }
        for (Class<?> ifc : ifcs = clazz2.getInterfaces()) {
            count2 += ClassUtils.getMethodCountForName(ifc, methodName);
        }
        if (clazz2.getSuperclass() != null) {
            count2 += ClassUtils.getMethodCountForName(clazz2.getSuperclass(), methodName);
        }
        return count2;
    }

    public static boolean hasAtLeastOneMethodWithName(Class<?> clazz2, String methodName) {
        Class<?>[] ifcs;
        Method[] declaredMethods;
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        for (Method method : declaredMethods = clazz2.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return true;
        }
        for (Class<?> ifc : ifcs = clazz2.getInterfaces()) {
            if (!ClassUtils.hasAtLeastOneMethodWithName(ifc, methodName)) continue;
            return true;
        }
        return clazz2.getSuperclass() != null && ClassUtils.hasAtLeastOneMethodWithName(clazz2.getSuperclass(), methodName);
    }

    public static Method getMostSpecificMethod(Method method, Class<?> targetClass) {
        if (method != null && ClassUtils.isOverridable(method, targetClass) && targetClass != null && targetClass != method.getDeclaringClass()) {
            try {
                if (Modifier.isPublic(method.getModifiers())) {
                    try {
                        return targetClass.getMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException ex) {
                        return method;
                    }
                }
                Method specificMethod = ReflectionUtils.findMethod(targetClass, method.getName(), method.getParameterTypes());
                return specificMethod != null ? specificMethod : method;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return method;
    }

    public static boolean isUserLevelMethod(Method method) {
        Assert.notNull(method, "Method must not be null");
        return method.isBridge() || !method.isSynthetic() && !ClassUtils.isGroovyObjectMethod(method);
    }

    private static boolean isGroovyObjectMethod(Method method) {
        return method.getDeclaringClass().getName().equals("groovy.lang.GroovyObject");
    }

    private static boolean isOverridable(Method method, Class<?> targetClass) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
            return true;
        }
        return ClassUtils.getPackageName(method.getDeclaringClass()).equals(ClassUtils.getPackageName(targetClass));
    }

    public static Method getStaticMethod(Class<?> clazz2, String methodName, Class<?> ... args2) {
        Assert.notNull(clazz2, "Class must not be null");
        Assert.notNull(methodName, "Method name must not be null");
        try {
            Method method = clazz2.getMethod(methodName, args2);
            return Modifier.isStatic(method.getModifiers()) ? method : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        for (Map.Entry<Class<?>, Class<?>> entry2 : primitiveWrapperTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(entry2.getValue(), entry2.getKey());
            ClassUtils.registerCommonClasses(entry2.getKey());
        }
        HashSet<Class<Void>> primitiveTypes = new HashSet<Class<Void>>(64);
        primitiveTypes.addAll(primitiveWrapperTypeMap.values());
        primitiveTypes.addAll(Arrays.asList(boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class));
        primitiveTypes.add(Void.TYPE);
        for (Class clazz2 : primitiveTypes) {
            primitiveTypeNameMap.put(clazz2.getName(), clazz2);
        }
        ClassUtils.registerCommonClasses(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        ClassUtils.registerCommonClasses(Number.class, Number[].class, String.class, String[].class, Class.class, Class[].class, Object.class, Object[].class);
        ClassUtils.registerCommonClasses(Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
        ClassUtils.registerCommonClasses(Enum.class, Iterable.class, Cloneable.class, Comparable.class);
    }
}

