/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.config.CronTask;
import org.springframework.scheduling.config.IntervalTask;
import org.springframework.scheduling.config.ScheduledTask;
import org.springframework.scheduling.config.Task;
import org.springframework.scheduling.config.TriggerTask;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ScheduledTaskRegistrar
implements InitializingBean,
DisposableBean {
    private TaskScheduler taskScheduler;
    private ScheduledExecutorService localExecutor;
    private List<TriggerTask> triggerTasks;
    private List<CronTask> cronTasks;
    private List<IntervalTask> fixedRateTasks;
    private List<IntervalTask> fixedDelayTasks;
    private final Map<Task, ScheduledTask> unresolvedTasks = new HashMap<Task, ScheduledTask>(16);
    private final Set<ScheduledTask> scheduledTasks = new LinkedHashSet<ScheduledTask>(16);

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        Assert.notNull(taskScheduler, "TaskScheduler must not be null");
        this.taskScheduler = taskScheduler;
    }

    public void setScheduler(Object scheduler) {
        Assert.notNull(scheduler, "Scheduler object must not be null");
        if (scheduler instanceof TaskScheduler) {
            this.taskScheduler = (TaskScheduler)scheduler;
        } else if (scheduler instanceof ScheduledExecutorService) {
            this.taskScheduler = new ConcurrentTaskScheduler((ScheduledExecutorService)scheduler);
        } else {
            throw new IllegalArgumentException("Unsupported scheduler type: " + scheduler.getClass());
        }
    }

    public TaskScheduler getScheduler() {
        return this.taskScheduler;
    }

    public void setTriggerTasks(Map<Runnable, Trigger> triggerTasks) {
        this.triggerTasks = new ArrayList<TriggerTask>();
        for (Map.Entry<Runnable, Trigger> task2 : triggerTasks.entrySet()) {
            this.addTriggerTask(new TriggerTask(task2.getKey(), task2.getValue()));
        }
    }

    public void setTriggerTasksList(List<TriggerTask> triggerTasks) {
        this.triggerTasks = triggerTasks;
    }

    public List<TriggerTask> getTriggerTaskList() {
        return this.triggerTasks != null ? Collections.unmodifiableList(this.triggerTasks) : Collections.emptyList();
    }

    public void setCronTasks(Map<Runnable, String> cronTasks) {
        this.cronTasks = new ArrayList<CronTask>();
        for (Map.Entry<Runnable, String> task2 : cronTasks.entrySet()) {
            this.addCronTask(task2.getKey(), task2.getValue());
        }
    }

    public void setCronTasksList(List<CronTask> cronTasks) {
        this.cronTasks = cronTasks;
    }

    public List<CronTask> getCronTaskList() {
        return this.cronTasks != null ? Collections.unmodifiableList(this.cronTasks) : Collections.emptyList();
    }

    public void setFixedRateTasks(Map<Runnable, Long> fixedRateTasks) {
        this.fixedRateTasks = new ArrayList<IntervalTask>();
        for (Map.Entry<Runnable, Long> task2 : fixedRateTasks.entrySet()) {
            this.addFixedRateTask(task2.getKey(), task2.getValue());
        }
    }

    public void setFixedRateTasksList(List<IntervalTask> fixedRateTasks) {
        this.fixedRateTasks = fixedRateTasks;
    }

    public List<IntervalTask> getFixedRateTaskList() {
        return this.fixedRateTasks != null ? Collections.unmodifiableList(this.fixedRateTasks) : Collections.emptyList();
    }

    public void setFixedDelayTasks(Map<Runnable, Long> fixedDelayTasks) {
        this.fixedDelayTasks = new ArrayList<IntervalTask>();
        for (Map.Entry<Runnable, Long> task2 : fixedDelayTasks.entrySet()) {
            this.addFixedDelayTask(task2.getKey(), task2.getValue());
        }
    }

    public void setFixedDelayTasksList(List<IntervalTask> fixedDelayTasks) {
        this.fixedDelayTasks = fixedDelayTasks;
    }

    public List<IntervalTask> getFixedDelayTaskList() {
        return this.fixedDelayTasks != null ? Collections.unmodifiableList(this.fixedDelayTasks) : Collections.emptyList();
    }

    public void addTriggerTask(Runnable task2, Trigger trigger) {
        this.addTriggerTask(new TriggerTask(task2, trigger));
    }

    public void addTriggerTask(TriggerTask task2) {
        if (this.triggerTasks == null) {
            this.triggerTasks = new ArrayList<TriggerTask>();
        }
        this.triggerTasks.add(task2);
    }

    public void addCronTask(Runnable task2, String expression) {
        this.addCronTask(new CronTask(task2, expression));
    }

    public void addCronTask(CronTask task2) {
        if (this.cronTasks == null) {
            this.cronTasks = new ArrayList<CronTask>();
        }
        this.cronTasks.add(task2);
    }

    public void addFixedRateTask(Runnable task2, long interval) {
        this.addFixedRateTask(new IntervalTask(task2, interval, 0L));
    }

    public void addFixedRateTask(IntervalTask task2) {
        if (this.fixedRateTasks == null) {
            this.fixedRateTasks = new ArrayList<IntervalTask>();
        }
        this.fixedRateTasks.add(task2);
    }

    public void addFixedDelayTask(Runnable task2, long delay) {
        this.addFixedDelayTask(new IntervalTask(task2, delay, 0L));
    }

    public void addFixedDelayTask(IntervalTask task2) {
        if (this.fixedDelayTasks == null) {
            this.fixedDelayTasks = new ArrayList<IntervalTask>();
        }
        this.fixedDelayTasks.add(task2);
    }

    public boolean hasTasks() {
        return !CollectionUtils.isEmpty(this.triggerTasks) || !CollectionUtils.isEmpty(this.cronTasks) || !CollectionUtils.isEmpty(this.fixedRateTasks) || !CollectionUtils.isEmpty(this.fixedDelayTasks);
    }

    @Override
    public void afterPropertiesSet() {
        this.scheduleTasks();
    }

    protected void scheduleTasks() {
        if (this.taskScheduler == null) {
            this.localExecutor = Executors.newSingleThreadScheduledExecutor();
            this.taskScheduler = new ConcurrentTaskScheduler(this.localExecutor);
        }
        if (this.triggerTasks != null) {
            for (TriggerTask triggerTask : this.triggerTasks) {
                this.addScheduledTask(this.scheduleTriggerTask(triggerTask));
            }
        }
        if (this.cronTasks != null) {
            for (CronTask cronTask : this.cronTasks) {
                this.addScheduledTask(this.scheduleCronTask(cronTask));
            }
        }
        if (this.fixedRateTasks != null) {
            for (IntervalTask intervalTask : this.fixedRateTasks) {
                this.addScheduledTask(this.scheduleFixedRateTask(intervalTask));
            }
        }
        if (this.fixedDelayTasks != null) {
            for (IntervalTask intervalTask : this.fixedDelayTasks) {
                this.addScheduledTask(this.scheduleFixedDelayTask(intervalTask));
            }
        }
    }

    private void addScheduledTask(ScheduledTask task2) {
        if (task2 != null) {
            this.scheduledTasks.add(task2);
        }
    }

    public ScheduledTask scheduleTriggerTask(TriggerTask task2) {
        ScheduledTask scheduledTask = this.unresolvedTasks.remove(task2);
        boolean newTask = false;
        if (scheduledTask == null) {
            scheduledTask = new ScheduledTask();
            newTask = true;
        }
        if (this.taskScheduler != null) {
            scheduledTask.future = this.taskScheduler.schedule(task2.getRunnable(), task2.getTrigger());
        } else {
            this.addTriggerTask(task2);
            this.unresolvedTasks.put(task2, scheduledTask);
        }
        return newTask ? scheduledTask : null;
    }

    public ScheduledTask scheduleCronTask(CronTask task2) {
        ScheduledTask scheduledTask = this.unresolvedTasks.remove(task2);
        boolean newTask = false;
        if (scheduledTask == null) {
            scheduledTask = new ScheduledTask();
            newTask = true;
        }
        if (this.taskScheduler != null) {
            scheduledTask.future = this.taskScheduler.schedule(task2.getRunnable(), task2.getTrigger());
        } else {
            this.addCronTask(task2);
            this.unresolvedTasks.put(task2, scheduledTask);
        }
        return newTask ? scheduledTask : null;
    }

    public ScheduledTask scheduleFixedRateTask(IntervalTask task2) {
        ScheduledTask scheduledTask = this.unresolvedTasks.remove(task2);
        boolean newTask = false;
        if (scheduledTask == null) {
            scheduledTask = new ScheduledTask();
            newTask = true;
        }
        if (this.taskScheduler != null) {
            if (task2.getInitialDelay() > 0L) {
                Date startTime = new Date(System.currentTimeMillis() + task2.getInitialDelay());
                scheduledTask.future = this.taskScheduler.scheduleAtFixedRate(task2.getRunnable(), startTime, task2.getInterval());
            } else {
                scheduledTask.future = this.taskScheduler.scheduleAtFixedRate(task2.getRunnable(), task2.getInterval());
            }
        } else {
            this.addFixedRateTask(task2);
            this.unresolvedTasks.put(task2, scheduledTask);
        }
        return newTask ? scheduledTask : null;
    }

    public ScheduledTask scheduleFixedDelayTask(IntervalTask task2) {
        ScheduledTask scheduledTask = this.unresolvedTasks.remove(task2);
        boolean newTask = false;
        if (scheduledTask == null) {
            scheduledTask = new ScheduledTask();
            newTask = true;
        }
        if (this.taskScheduler != null) {
            if (task2.getInitialDelay() > 0L) {
                Date startTime = new Date(System.currentTimeMillis() + task2.getInitialDelay());
                scheduledTask.future = this.taskScheduler.scheduleWithFixedDelay(task2.getRunnable(), startTime, task2.getInterval());
            } else {
                scheduledTask.future = this.taskScheduler.scheduleWithFixedDelay(task2.getRunnable(), task2.getInterval());
            }
        } else {
            this.addFixedDelayTask(task2);
            this.unresolvedTasks.put(task2, scheduledTask);
        }
        return newTask ? scheduledTask : null;
    }

    @Override
    public void destroy() {
        for (ScheduledTask task2 : this.scheduledTasks) {
            task2.cancel();
        }
        if (this.localExecutor != null) {
            this.localExecutor.shutdownNow();
        }
    }
}

