/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.concurrent;

import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.enterprise.concurrent.ManagedExecutors;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.ListenableFuture;

public class ConcurrentTaskExecutor
implements AsyncListenableTaskExecutor,
SchedulingTaskExecutor {
    private static Class<?> managedExecutorServiceClass;
    private Executor concurrentExecutor;
    private TaskExecutorAdapter adaptedExecutor;

    public ConcurrentTaskExecutor() {
        this.setConcurrentExecutor(null);
    }

    public ConcurrentTaskExecutor(Executor concurrentExecutor) {
        this.setConcurrentExecutor(concurrentExecutor);
    }

    public final void setConcurrentExecutor(Executor concurrentExecutor) {
        if (concurrentExecutor != null) {
            this.concurrentExecutor = concurrentExecutor;
            this.adaptedExecutor = managedExecutorServiceClass != null && managedExecutorServiceClass.isInstance(concurrentExecutor) ? new ManagedTaskExecutorAdapter(concurrentExecutor) : new TaskExecutorAdapter(concurrentExecutor);
        } else {
            this.concurrentExecutor = Executors.newSingleThreadExecutor();
            this.adaptedExecutor = new TaskExecutorAdapter(this.concurrentExecutor);
        }
    }

    public final Executor getConcurrentExecutor() {
        return this.concurrentExecutor;
    }

    public final void setTaskDecorator(TaskDecorator taskDecorator) {
        this.adaptedExecutor.setTaskDecorator(taskDecorator);
    }

    @Override
    public void execute(Runnable task2) {
        this.adaptedExecutor.execute(task2);
    }

    @Override
    public void execute(Runnable task2, long startTimeout) {
        this.adaptedExecutor.execute(task2, startTimeout);
    }

    @Override
    public Future<?> submit(Runnable task2) {
        return this.adaptedExecutor.submit(task2);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task2) {
        return this.adaptedExecutor.submit(task2);
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable task2) {
        return this.adaptedExecutor.submitListenable(task2);
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> task2) {
        return this.adaptedExecutor.submitListenable(task2);
    }

    @Override
    public boolean prefersShortLivedTasks() {
        return true;
    }

    static {
        try {
            managedExecutorServiceClass = ClassUtils.forName("javax.enterprise.concurrent.ManagedExecutorService", ConcurrentTaskScheduler.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            managedExecutorServiceClass = null;
        }
    }

    protected static class ManagedTaskBuilder {
        protected ManagedTaskBuilder() {
        }

        public static Runnable buildManagedTask(Runnable task2, String identityName) {
            HashMap<String, String> properties = new HashMap<String, String>(2);
            if (task2 instanceof SchedulingAwareRunnable) {
                properties.put("javax.enterprise.concurrent.LONGRUNNING_HINT", Boolean.toString(((SchedulingAwareRunnable)task2).isLongLived()));
            }
            properties.put("javax.enterprise.concurrent.IDENTITY_NAME", identityName);
            return ManagedExecutors.managedTask((Runnable)task2, properties, null);
        }

        public static <T> Callable<T> buildManagedTask(Callable<T> task2, String identityName) {
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("javax.enterprise.concurrent.IDENTITY_NAME", identityName);
            return ManagedExecutors.managedTask(task2, properties, null);
        }
    }

    private static class ManagedTaskExecutorAdapter
    extends TaskExecutorAdapter {
        public ManagedTaskExecutorAdapter(Executor concurrentExecutor) {
            super(concurrentExecutor);
        }

        @Override
        public void execute(Runnable task2) {
            super.execute(ManagedTaskBuilder.buildManagedTask(task2, task2.toString()));
        }

        @Override
        public Future<?> submit(Runnable task2) {
            return super.submit(ManagedTaskBuilder.buildManagedTask(task2, task2.toString()));
        }

        @Override
        public <T> Future<T> submit(Callable<T> task2) {
            return super.submit(ManagedTaskBuilder.buildManagedTask(task2, task2.toString()));
        }

        @Override
        public ListenableFuture<?> submitListenable(Runnable task2) {
            return super.submitListenable(ManagedTaskBuilder.buildManagedTask(task2, task2.toString()));
        }

        @Override
        public <T> ListenableFuture<T> submitListenable(Callable<T> task2) {
            return super.submitListenable(ManagedTaskBuilder.buildManagedTask(task2, task2.toString()));
        }
    }
}

