/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.springframework.util.concurrent.FailureCallback;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;
import org.springframework.util.concurrent.SuccessCallback;

public class AsyncResult<V>
implements ListenableFuture<V> {
    private final V value;
    private final ExecutionException executionException;

    public AsyncResult(V value2) {
        this(value2, null);
    }

    private AsyncResult(V value2, ExecutionException ex) {
        this.value = value2;
        this.executionException = ex;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public V get() throws ExecutionException {
        if (this.executionException != null) {
            throw this.executionException;
        }
        return this.value;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws ExecutionException {
        return this.get();
    }

    @Override
    public void addCallback(ListenableFutureCallback<? super V> callback) {
        this.addCallback((SuccessCallback<? super V>)callback, (FailureCallback)callback);
    }

    @Override
    public void addCallback(SuccessCallback<? super V> successCallback, FailureCallback failureCallback) {
        try {
            if (this.executionException != null) {
                Throwable cause = this.executionException.getCause();
                failureCallback.onFailure(cause != null ? cause : this.executionException);
            } else {
                successCallback.onSuccess(this.value);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static <V> ListenableFuture<V> forValue(V value2) {
        return new AsyncResult<V>(value2, null);
    }

    public static <V> ListenableFuture<V> forExecutionException(Throwable ex) {
        return new AsyncResult<Object>(null, ex instanceof ExecutionException ? (ExecutionException)ex : new ExecutionException(ex));
    }
}

