/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.beans.PropertyDescriptor;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.DynamicMBean;
import javax.management.JMX;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.MBeanServerNotFoundException;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class JmxUtils {
    public static final String IDENTITY_OBJECT_NAME_KEY = "identity";
    private static final String MBEAN_SUFFIX = "MBean";
    private static final Log logger = LogFactory.getLog(JmxUtils.class);

    public static MBeanServer locateMBeanServer() throws MBeanServerNotFoundException {
        return JmxUtils.locateMBeanServer(null);
    }

    public static MBeanServer locateMBeanServer(String agentId) throws MBeanServerNotFoundException {
        ArrayList<MBeanServer> servers;
        MBeanServer server = null;
        if (!"".equals(agentId) && !CollectionUtils.isEmpty(servers = MBeanServerFactory.findMBeanServer(agentId))) {
            if (servers.size() > 1 && logger.isWarnEnabled()) {
                logger.warn("Found more than one MBeanServer instance" + (agentId != null ? " with agent id [" + agentId + "]" : "") + ". Returning first from list.");
            }
            server = (MBeanServer)servers.get(0);
        }
        if (server == null && !StringUtils.hasLength(agentId)) {
            try {
                server = ManagementFactory.getPlatformMBeanServer();
            }
            catch (SecurityException ex) {
                throw new MBeanServerNotFoundException("No specific MBeanServer found, and not allowed to obtain the Java platform MBeanServer", ex);
            }
        }
        if (server == null) {
            throw new MBeanServerNotFoundException("Unable to locate an MBeanServer instance" + (agentId != null ? " with agent id [" + agentId + "]" : ""));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Found MBeanServer: " + server);
        }
        return server;
    }

    public static Class<?>[] parameterInfoToTypes(MBeanParameterInfo[] paramInfo) throws ClassNotFoundException {
        return JmxUtils.parameterInfoToTypes(paramInfo, ClassUtils.getDefaultClassLoader());
    }

    public static Class<?>[] parameterInfoToTypes(MBeanParameterInfo[] paramInfo, ClassLoader classLoader) throws ClassNotFoundException {
        Class[] types2 = null;
        if (paramInfo != null && paramInfo.length > 0) {
            types2 = new Class[paramInfo.length];
            for (int x = 0; x < paramInfo.length; ++x) {
                types2[x] = ClassUtils.forName(paramInfo[x].getType(), classLoader);
            }
        }
        return types2;
    }

    public static String[] getMethodSignature(Method method) {
        Class<?>[] types2 = method.getParameterTypes();
        String[] signature2 = new String[types2.length];
        for (int x = 0; x < types2.length; ++x) {
            signature2[x] = types2[x].getName();
        }
        return signature2;
    }

    public static String getAttributeName(PropertyDescriptor property, boolean useStrictCasing) {
        if (useStrictCasing) {
            return StringUtils.capitalize(property.getName());
        }
        return property.getName();
    }

    public static ObjectName appendIdentityToObjectName(ObjectName objectName, Object managedResource) throws MalformedObjectNameException {
        Hashtable<String, String> keyProperties = objectName.getKeyPropertyList();
        keyProperties.put(IDENTITY_OBJECT_NAME_KEY, ObjectUtils.getIdentityHexString(managedResource));
        return ObjectNameManager.getInstance(objectName.getDomain(), keyProperties);
    }

    public static Class<?> getClassToExpose(Object managedBean) {
        return ClassUtils.getUserClass(managedBean);
    }

    public static Class<?> getClassToExpose(Class<?> clazz2) {
        return ClassUtils.getUserClass(clazz2);
    }

    public static boolean isMBean(Class<?> clazz2) {
        return clazz2 != null && (DynamicMBean.class.isAssignableFrom(clazz2) || JmxUtils.getMBeanInterface(clazz2) != null || JmxUtils.getMXBeanInterface(clazz2) != null);
    }

    public static Class<?> getMBeanInterface(Class<?> clazz2) {
        Class<?>[] implementedInterfaces2;
        if (clazz2 == null || clazz2.getSuperclass() == null) {
            return null;
        }
        String mbeanInterfaceName = clazz2.getName() + MBEAN_SUFFIX;
        for (Class<?> iface : implementedInterfaces2 = clazz2.getInterfaces()) {
            if (!iface.getName().equals(mbeanInterfaceName)) continue;
            return iface;
        }
        return JmxUtils.getMBeanInterface(clazz2.getSuperclass());
    }

    public static Class<?> getMXBeanInterface(Class<?> clazz2) {
        Class<?>[] implementedInterfaces2;
        if (clazz2 == null || clazz2.getSuperclass() == null) {
            return null;
        }
        for (Class<?> iface : implementedInterfaces2 = clazz2.getInterfaces()) {
            if (!JMX.isMXBeanInterface(iface)) continue;
            return iface;
        }
        return JmxUtils.getMXBeanInterface(clazz2.getSuperclass());
    }

    @Deprecated
    public static boolean isMXBeanSupportAvailable() {
        return true;
    }
}

