/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.jmx.export.assembler.AbstractMBeanInfoAssembler;
import org.springframework.jmx.support.JmxUtils;

public abstract class AbstractReflectiveMBeanInfoAssembler
extends AbstractMBeanInfoAssembler {
    protected static final String FIELD_GET_METHOD = "getMethod";
    protected static final String FIELD_SET_METHOD = "setMethod";
    protected static final String FIELD_ROLE = "role";
    protected static final String ROLE_GETTER = "getter";
    protected static final String ROLE_SETTER = "setter";
    protected static final String ROLE_OPERATION = "operation";
    protected static final String FIELD_VISIBILITY = "visibility";
    protected static final int ATTRIBUTE_OPERATION_VISIBILITY = 4;
    protected static final String FIELD_CLASS = "class";
    protected static final String FIELD_LOG = "log";
    protected static final String FIELD_LOG_FILE = "logFile";
    protected static final String FIELD_CURRENCY_TIME_LIMIT = "currencyTimeLimit";
    protected static final String FIELD_DEFAULT = "default";
    protected static final String FIELD_PERSIST_POLICY = "persistPolicy";
    protected static final String FIELD_PERSIST_PERIOD = "persistPeriod";
    protected static final String FIELD_PERSIST_LOCATION = "persistLocation";
    protected static final String FIELD_PERSIST_NAME = "persistName";
    protected static final String FIELD_DISPLAY_NAME = "displayName";
    protected static final String FIELD_UNITS = "units";
    protected static final String FIELD_METRIC_TYPE = "metricType";
    protected static final String FIELD_METRIC_CATEGORY = "metricCategory";
    private Integer defaultCurrencyTimeLimit;
    private boolean useStrictCasing = true;
    private boolean exposeClassDescriptor = false;
    private ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();

    public void setDefaultCurrencyTimeLimit(Integer defaultCurrencyTimeLimit) {
        this.defaultCurrencyTimeLimit = defaultCurrencyTimeLimit;
    }

    protected Integer getDefaultCurrencyTimeLimit() {
        return this.defaultCurrencyTimeLimit;
    }

    public void setUseStrictCasing(boolean useStrictCasing) {
        this.useStrictCasing = useStrictCasing;
    }

    protected boolean isUseStrictCasing() {
        return this.useStrictCasing;
    }

    public void setExposeClassDescriptor(boolean exposeClassDescriptor) {
        this.exposeClassDescriptor = exposeClassDescriptor;
    }

    protected boolean isExposeClassDescriptor() {
        return this.exposeClassDescriptor;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    protected ParameterNameDiscoverer getParameterNameDiscoverer() {
        return this.parameterNameDiscoverer;
    }

    @Override
    protected ModelMBeanAttributeInfo[] getAttributeInfo(Object managedBean, String beanKey) throws JMException {
        PropertyDescriptor[] props = BeanUtils.getPropertyDescriptors(this.getClassToExpose(managedBean));
        ArrayList<ModelMBeanAttributeInfo> infos = new ArrayList<ModelMBeanAttributeInfo>();
        for (PropertyDescriptor prop : props) {
            Method setter2;
            Method getter2 = prop.getReadMethod();
            if (getter2 != null && getter2.getDeclaringClass() == Object.class) continue;
            if (getter2 != null && !this.includeReadAttribute(getter2, beanKey)) {
                getter2 = null;
            }
            if ((setter2 = prop.getWriteMethod()) != null && !this.includeWriteAttribute(setter2, beanKey)) {
                setter2 = null;
            }
            if (getter2 == null && setter2 == null) continue;
            String attrName = JmxUtils.getAttributeName(prop, this.isUseStrictCasing());
            String description = this.getAttributeDescription(prop, beanKey);
            ModelMBeanAttributeInfo info2 = new ModelMBeanAttributeInfo(attrName, description, getter2, setter2);
            Descriptor desc = info2.getDescriptor();
            if (getter2 != null) {
                desc.setField(FIELD_GET_METHOD, getter2.getName());
            }
            if (setter2 != null) {
                desc.setField(FIELD_SET_METHOD, setter2.getName());
            }
            this.populateAttributeDescriptor(desc, getter2, setter2, beanKey);
            info2.setDescriptor(desc);
            infos.add(info2);
        }
        return infos.toArray(new ModelMBeanAttributeInfo[infos.size()]);
    }

    @Override
    protected ModelMBeanOperationInfo[] getOperationInfo(Object managedBean, String beanKey) {
        Method[] methods2 = this.getClassToExpose(managedBean).getMethods();
        ArrayList<ModelMBeanOperationInfo> infos = new ArrayList<ModelMBeanOperationInfo>();
        for (Method method : methods2) {
            Descriptor desc;
            if (method.isSynthetic() || Object.class == method.getDeclaringClass()) continue;
            ModelMBeanOperationInfo info2 = null;
            PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
            if (pd != null && (method.equals(pd.getReadMethod()) && this.includeReadAttribute(method, beanKey) || method.equals(pd.getWriteMethod()) && this.includeWriteAttribute(method, beanKey))) {
                info2 = this.createModelMBeanOperationInfo(method, pd.getName(), beanKey);
                desc = info2.getDescriptor();
                if (method.equals(pd.getReadMethod())) {
                    desc.setField(FIELD_ROLE, ROLE_GETTER);
                } else {
                    desc.setField(FIELD_ROLE, ROLE_SETTER);
                }
                desc.setField(FIELD_VISIBILITY, 4);
                if (this.isExposeClassDescriptor()) {
                    desc.setField(FIELD_CLASS, this.getClassForDescriptor(managedBean).getName());
                }
                info2.setDescriptor(desc);
            }
            if (info2 == null && this.includeOperation(method, beanKey)) {
                info2 = this.createModelMBeanOperationInfo(method, method.getName(), beanKey);
                desc = info2.getDescriptor();
                desc.setField(FIELD_ROLE, ROLE_OPERATION);
                if (this.isExposeClassDescriptor()) {
                    desc.setField(FIELD_CLASS, this.getClassForDescriptor(managedBean).getName());
                }
                this.populateOperationDescriptor(desc, method, beanKey);
                info2.setDescriptor(desc);
            }
            if (info2 == null) continue;
            infos.add(info2);
        }
        return infos.toArray(new ModelMBeanOperationInfo[infos.size()]);
    }

    protected ModelMBeanOperationInfo createModelMBeanOperationInfo(Method method, String name, String beanKey) {
        MBeanParameterInfo[] params2 = this.getOperationParameters(method, beanKey);
        if (params2.length == 0) {
            return new ModelMBeanOperationInfo(this.getOperationDescription(method, beanKey), method);
        }
        return new ModelMBeanOperationInfo(method.getName(), this.getOperationDescription(method, beanKey), this.getOperationParameters(method, beanKey), method.getReturnType().getName(), 3);
    }

    protected Class<?> getClassForDescriptor(Object managedBean) {
        if (AopUtils.isJdkDynamicProxy(managedBean)) {
            return AopProxyUtils.proxiedUserInterfaces(managedBean)[0];
        }
        return this.getClassToExpose(managedBean);
    }

    protected abstract boolean includeReadAttribute(Method var1, String var2);

    protected abstract boolean includeWriteAttribute(Method var1, String var2);

    protected abstract boolean includeOperation(Method var1, String var2);

    protected String getAttributeDescription(PropertyDescriptor propertyDescriptor, String beanKey) {
        return propertyDescriptor.getDisplayName();
    }

    protected String getOperationDescription(Method method, String beanKey) {
        return method.getName();
    }

    protected MBeanParameterInfo[] getOperationParameters(Method method, String beanKey) {
        String[] paramNames;
        ParameterNameDiscoverer paramNameDiscoverer = this.getParameterNameDiscoverer();
        String[] stringArray = paramNames = paramNameDiscoverer != null ? paramNameDiscoverer.getParameterNames(method) : null;
        if (paramNames == null) {
            return new MBeanParameterInfo[0];
        }
        MBeanParameterInfo[] info2 = new MBeanParameterInfo[paramNames.length];
        Class<?>[] typeParameters = method.getParameterTypes();
        for (int i = 0; i < info2.length; ++i) {
            info2[i] = new MBeanParameterInfo(paramNames[i], typeParameters[i].getName(), paramNames[i]);
        }
        return info2;
    }

    @Override
    protected void populateMBeanDescriptor(Descriptor descriptor, Object managedBean, String beanKey) {
        this.applyDefaultCurrencyTimeLimit(descriptor);
    }

    protected void populateAttributeDescriptor(Descriptor desc, Method getter2, Method setter2, String beanKey) {
        this.applyDefaultCurrencyTimeLimit(desc);
    }

    protected void populateOperationDescriptor(Descriptor desc, Method method, String beanKey) {
        this.applyDefaultCurrencyTimeLimit(desc);
    }

    protected final void applyDefaultCurrencyTimeLimit(Descriptor desc) {
        if (this.getDefaultCurrencyTimeLimit() != null) {
            desc.setField(FIELD_CURRENCY_TIME_LIMIT, this.getDefaultCurrencyTimeLimit().toString());
        }
    }

    protected void applyCurrencyTimeLimit(Descriptor desc, int currencyTimeLimit) {
        if (currencyTimeLimit > 0) {
            desc.setField(FIELD_CURRENCY_TIME_LIMIT, Integer.toString(currencyTimeLimit));
        } else if (currencyTimeLimit == 0) {
            desc.setField(FIELD_CURRENCY_TIME_LIMIT, Integer.toString(Integer.MAX_VALUE));
        } else {
            this.applyDefaultCurrencyTimeLimit(desc);
        }
    }
}

