/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.support.JdbcUtils;

public class DatabaseStartupValidator
implements InitializingBean {
    public static final int DEFAULT_INTERVAL = 1;
    public static final int DEFAULT_TIMEOUT = 60;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private DataSource dataSource;
    private String validationQuery;
    private int interval = 1;
    private int timeout = 60;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterPropertiesSet() {
        DataSource dataSource = this.dataSource;
        if (dataSource == null) {
            throw new IllegalArgumentException("Property 'dataSource' is required");
        }
        if (this.validationQuery == null) {
            throw new IllegalArgumentException("Property 'validationQuery' is required");
        }
        try {
            boolean validated = false;
            long beginTime = System.currentTimeMillis();
            long deadLine = beginTime + (long)(this.timeout * 1000);
            SQLException latestEx = null;
            while (!validated && System.currentTimeMillis() < deadLine) {
                Connection con = null;
                Statement stmt = null;
                try {
                    con = dataSource.getConnection();
                    stmt = con.createStatement();
                    stmt.execute(this.validationQuery);
                    validated = true;
                }
                catch (SQLException ex) {
                    block12: {
                        try {
                            float rest2;
                            latestEx = ex;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Validation query [" + this.validationQuery + "] threw exception", ex);
                            }
                            if (!this.logger.isWarnEnabled() || !((rest2 = (float)(deadLine - System.currentTimeMillis()) / 1000.0f) > (float)this.interval)) break block12;
                            this.logger.warn("Database has not started up yet - retrying in " + this.interval + " seconds (timeout in " + rest2 + " seconds)");
                        }
                        catch (Throwable throwable2) {
                            JdbcUtils.closeStatement(stmt);
                            JdbcUtils.closeConnection(con);
                            throw throwable2;
                        }
                    }
                    JdbcUtils.closeStatement(stmt);
                    JdbcUtils.closeConnection(con);
                }
                JdbcUtils.closeStatement(stmt);
                JdbcUtils.closeConnection(con);
                if (validated) continue;
                Thread.sleep(this.interval * 1000);
            }
            if (!validated) {
                throw new CannotGetJdbcConnectionException("Database has not started up within " + this.timeout + " seconds", latestEx);
            }
            if (this.logger.isInfoEnabled()) {
                float duration = (float)(System.currentTimeMillis() - beginTime) / 1000.0f;
                this.logger.info("Database startup detected after " + duration + " seconds");
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

