/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.util.Assert;

public abstract class AbstractFallbackSQLExceptionTranslator
implements SQLExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SQLExceptionTranslator fallbackTranslator;

    public void setFallbackTranslator(SQLExceptionTranslator fallback) {
        this.fallbackTranslator = fallback;
    }

    public SQLExceptionTranslator getFallbackTranslator() {
        return this.fallbackTranslator;
    }

    @Override
    public DataAccessException translate(String task2, String sql2, SQLException ex) {
        DataAccessException dae;
        Assert.notNull(ex, "Cannot translate a null SQLException");
        if (task2 == null) {
            task2 = "";
        }
        if (sql2 == null) {
            sql2 = "";
        }
        if ((dae = this.doTranslate(task2, sql2, ex)) != null) {
            return dae;
        }
        SQLExceptionTranslator fallback = this.getFallbackTranslator();
        if (fallback != null && (dae = fallback.translate(task2, sql2, ex)) != null) {
            return dae;
        }
        return new UncategorizedSQLException(task2, sql2, ex);
    }

    protected abstract DataAccessException doTranslate(String var1, String var2, SQLException var3);

    protected String buildMessage(String task2, String sql2, SQLException ex) {
        return task2 + "; SQL [" + sql2 + "]; " + ex.getMessage();
    }
}

