/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.object.SqlUpdate;

public class BatchSqlUpdate
extends SqlUpdate {
    public static final int DEFAULT_BATCH_SIZE = 5000;
    private int batchSize = 5000;
    private boolean trackRowsAffected = true;
    private final LinkedList<Object[]> parameterQueue = new LinkedList();
    private final List<Integer> rowsAffected = new ArrayList<Integer>();

    public BatchSqlUpdate() {
    }

    public BatchSqlUpdate(DataSource ds, String sql2) {
        super(ds, sql2);
    }

    public BatchSqlUpdate(DataSource ds, String sql2, int[] types2) {
        super(ds, sql2, types2);
    }

    public BatchSqlUpdate(DataSource ds, String sql2, int[] types2, int batchSize) {
        super(ds, sql2, types2);
        this.setBatchSize(batchSize);
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setTrackRowsAffected(boolean trackRowsAffected) {
        this.trackRowsAffected = trackRowsAffected;
    }

    @Override
    protected boolean supportsLobParameters() {
        return false;
    }

    @Override
    public int update(Object ... params2) throws DataAccessException {
        this.validateParameters(params2);
        this.parameterQueue.add((Object[])params2.clone());
        if (this.parameterQueue.size() == this.batchSize) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Triggering auto-flush because queue reached batch size of " + this.batchSize);
            }
            this.flush();
        }
        return -1;
    }

    public int[] flush() {
        int[] rowsAffected;
        if (this.parameterQueue.isEmpty()) {
            return new int[0];
        }
        for (int rowCount : rowsAffected = this.getJdbcTemplate().batchUpdate(this.getSql(), new BatchPreparedStatementSetter(){

            @Override
            public int getBatchSize() {
                return BatchSqlUpdate.this.parameterQueue.size();
            }

            @Override
            public void setValues(PreparedStatement ps, int index2) throws SQLException {
                Object[] params2 = (Object[])BatchSqlUpdate.this.parameterQueue.removeFirst();
                BatchSqlUpdate.this.newPreparedStatementSetter(params2).setValues(ps);
            }
        })) {
            this.checkRowsAffected(rowCount);
            if (!this.trackRowsAffected) continue;
            this.rowsAffected.add(rowCount);
        }
        return rowsAffected;
    }

    public int getQueueCount() {
        return this.parameterQueue.size();
    }

    public int getExecutionCount() {
        return this.rowsAffected.size();
    }

    public int[] getRowsAffected() {
        int[] result2 = new int[this.rowsAffected.size()];
        int i = 0;
        Iterator<Integer> it = this.rowsAffected.iterator();
        while (it.hasNext()) {
            result2[i] = it.next();
            ++i;
        }
        return result2;
    }

    public void reset() {
        this.parameterQueue.clear();
        this.rowsAffected.clear();
    }
}

