/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlRowSetResultSetExtractor;
import org.springframework.jdbc.core.namedparam.EmptySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterBatchUpdateUtils;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSourceUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.util.Assert;

public class NamedParameterJdbcTemplate
implements NamedParameterJdbcOperations {
    public static final int DEFAULT_CACHE_LIMIT = 256;
    private final JdbcOperations classicJdbcTemplate;
    private volatile int cacheLimit = 256;
    private final Map<String, ParsedSql> parsedSqlCache = new LinkedHashMap<String, ParsedSql>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ParsedSql> eldest) {
            return this.size() > NamedParameterJdbcTemplate.this.getCacheLimit();
        }
    };

    public NamedParameterJdbcTemplate(DataSource dataSource) {
        Assert.notNull(dataSource, "DataSource must not be null");
        this.classicJdbcTemplate = new JdbcTemplate(dataSource);
    }

    public NamedParameterJdbcTemplate(JdbcOperations classicJdbcTemplate) {
        Assert.notNull(classicJdbcTemplate, "JdbcTemplate must not be null");
        this.classicJdbcTemplate = classicJdbcTemplate;
    }

    @Override
    public JdbcOperations getJdbcOperations() {
        return this.classicJdbcTemplate;
    }

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    @Override
    public <T> T execute(String sql2, SqlParameterSource paramSource, PreparedStatementCallback<T> action2) throws DataAccessException {
        return this.getJdbcOperations().execute(this.getPreparedStatementCreator(sql2, paramSource), action2);
    }

    @Override
    public <T> T execute(String sql2, Map<String, ?> paramMap, PreparedStatementCallback<T> action2) throws DataAccessException {
        return this.execute(sql2, new MapSqlParameterSource(paramMap), action2);
    }

    @Override
    public <T> T execute(String sql2, PreparedStatementCallback<T> action2) throws DataAccessException {
        return this.execute(sql2, EmptySqlParameterSource.INSTANCE, action2);
    }

    @Override
    public <T> T query(String sql2, SqlParameterSource paramSource, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.getJdbcOperations().query(this.getPreparedStatementCreator(sql2, paramSource), rse);
    }

    @Override
    public <T> T query(String sql2, Map<String, ?> paramMap, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(sql2, (SqlParameterSource)new MapSqlParameterSource(paramMap), rse);
    }

    @Override
    public <T> T query(String sql2, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(sql2, (SqlParameterSource)EmptySqlParameterSource.INSTANCE, rse);
    }

    @Override
    public void query(String sql2, SqlParameterSource paramSource, RowCallbackHandler rch) throws DataAccessException {
        this.getJdbcOperations().query(this.getPreparedStatementCreator(sql2, paramSource), rch);
    }

    @Override
    public void query(String sql2, Map<String, ?> paramMap, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql2, (SqlParameterSource)new MapSqlParameterSource(paramMap), rch);
    }

    @Override
    public void query(String sql2, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql2, (SqlParameterSource)EmptySqlParameterSource.INSTANCE, rch);
    }

    @Override
    public <T> List<T> query(String sql2, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws DataAccessException {
        return this.getJdbcOperations().query(this.getPreparedStatementCreator(sql2, paramSource), rowMapper);
    }

    @Override
    public <T> List<T> query(String sql2, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(sql2, (SqlParameterSource)new MapSqlParameterSource(paramMap), rowMapper);
    }

    @Override
    public <T> List<T> query(String sql2, RowMapper<T> rowMapper) throws DataAccessException {
        return this.query(sql2, (SqlParameterSource)EmptySqlParameterSource.INSTANCE, rowMapper);
    }

    @Override
    public <T> T queryForObject(String sql2, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws DataAccessException {
        List<T> results = this.getJdbcOperations().query(this.getPreparedStatementCreator(sql2, paramSource), rowMapper);
        return DataAccessUtils.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql2, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryForObject(sql2, (SqlParameterSource)new MapSqlParameterSource(paramMap), rowMapper);
    }

    @Override
    public <T> T queryForObject(String sql2, SqlParameterSource paramSource, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql2, paramSource, new SingleColumnRowMapper<T>(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql2, Map<String, ?> paramMap, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql2, paramMap, new SingleColumnRowMapper<T>(requiredType));
    }

    @Override
    public Map<String, Object> queryForMap(String sql2, SqlParameterSource paramSource) throws DataAccessException {
        return this.queryForObject(sql2, paramSource, new ColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql2, Map<String, ?> paramMap) throws DataAccessException {
        return this.queryForObject(sql2, paramMap, new ColumnMapRowMapper());
    }

    @Override
    public <T> List<T> queryForList(String sql2, SqlParameterSource paramSource, Class<T> elementType2) throws DataAccessException {
        return this.query(sql2, paramSource, new SingleColumnRowMapper<T>(elementType2));
    }

    @Override
    public <T> List<T> queryForList(String sql2, Map<String, ?> paramMap, Class<T> elementType2) throws DataAccessException {
        return this.queryForList(sql2, new MapSqlParameterSource(paramMap), elementType2);
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql2, SqlParameterSource paramSource) throws DataAccessException {
        return this.query(sql2, paramSource, new ColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql2, Map<String, ?> paramMap) throws DataAccessException {
        return this.queryForList(sql2, new MapSqlParameterSource(paramMap));
    }

    @Override
    public SqlRowSet queryForRowSet(String sql2, SqlParameterSource paramSource) throws DataAccessException {
        return this.getJdbcOperations().query(this.getPreparedStatementCreator(sql2, paramSource), new SqlRowSetResultSetExtractor());
    }

    @Override
    public SqlRowSet queryForRowSet(String sql2, Map<String, ?> paramMap) throws DataAccessException {
        return this.queryForRowSet(sql2, new MapSqlParameterSource(paramMap));
    }

    @Override
    public int update(String sql2, SqlParameterSource paramSource) throws DataAccessException {
        return this.getJdbcOperations().update(this.getPreparedStatementCreator(sql2, paramSource));
    }

    @Override
    public int update(String sql2, Map<String, ?> paramMap) throws DataAccessException {
        return this.update(sql2, new MapSqlParameterSource(paramMap));
    }

    @Override
    public int update(String sql2, SqlParameterSource paramSource, KeyHolder generatedKeyHolder) throws DataAccessException {
        return this.update(sql2, paramSource, generatedKeyHolder, null);
    }

    @Override
    public int update(String sql2, SqlParameterSource paramSource, KeyHolder generatedKeyHolder, String[] keyColumnNames) throws DataAccessException {
        ParsedSql parsedSql = this.getParsedSql(sql2);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(parsedSql, paramSource);
        Object[] params2 = NamedParameterUtils.buildValueArray(parsedSql, paramSource, null);
        List<SqlParameter> declaredParameters = NamedParameterUtils.buildSqlParameterList(parsedSql, paramSource);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, declaredParameters);
        if (keyColumnNames != null) {
            pscf.setGeneratedKeysColumnNames(keyColumnNames);
        } else {
            pscf.setReturnGeneratedKeys(true);
        }
        return this.getJdbcOperations().update(pscf.newPreparedStatementCreator(params2), generatedKeyHolder);
    }

    @Override
    public int[] batchUpdate(String sql2, Map<String, ?>[] batchValues) {
        return this.batchUpdate(sql2, SqlParameterSourceUtils.createBatch(batchValues));
    }

    @Override
    public int[] batchUpdate(String sql2, SqlParameterSource[] batchArgs) {
        return NamedParameterBatchUpdateUtils.executeBatchUpdateWithNamedParameters(this.getParsedSql(sql2), batchArgs, this.getJdbcOperations());
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql2, SqlParameterSource paramSource) {
        ParsedSql parsedSql = this.getParsedSql(sql2);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(parsedSql, paramSource);
        Object[] params2 = NamedParameterUtils.buildValueArray(parsedSql, paramSource, null);
        List<SqlParameter> declaredParameters = NamedParameterUtils.buildSqlParameterList(parsedSql, paramSource);
        PreparedStatementCreatorFactory pscf = new PreparedStatementCreatorFactory(sqlToUse, declaredParameters);
        return pscf.newPreparedStatementCreator(params2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParsedSql getParsedSql(String sql2) {
        if (this.getCacheLimit() <= 0) {
            return NamedParameterUtils.parseSqlStatement(sql2);
        }
        Map<String, ParsedSql> map2 = this.parsedSqlCache;
        synchronized (map2) {
            ParsedSql parsedSql = this.parsedSqlCache.get(sql2);
            if (parsedSql == null) {
                parsedSql = NamedParameterUtils.parseSqlStatement(sql2);
                this.parsedSqlCache.put(sql2, parsedSql);
            }
            return parsedSql;
        }
    }
}

