/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.SQLWarningException;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.ArgumentTypePreparedStatementSetter;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.BatchUpdateUtils;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.InterruptibleBatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.ParameterizedPreparedStatementSetter;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.ResultSetSupportingSqlParameter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.core.SqlOutParameter;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.core.SqlReturnResultSet;
import org.springframework.jdbc.core.SqlReturnUpdateCount;
import org.springframework.jdbc.core.SqlRowSetResultSetExtractor;
import org.springframework.jdbc.core.StatementCallback;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.util.Assert;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;

public class JdbcTemplate
extends JdbcAccessor
implements JdbcOperations {
    private static final String RETURN_RESULT_SET_PREFIX = "#result-set-";
    private static final String RETURN_UPDATE_COUNT_PREFIX = "#update-count-";
    private NativeJdbcExtractor nativeJdbcExtractor;
    private boolean ignoreWarnings = true;
    private int fetchSize = -1;
    private int maxRows = -1;
    private int queryTimeout = -1;
    private boolean skipResultsProcessing = false;
    private boolean skipUndeclaredResults = false;
    private boolean resultsMapCaseInsensitive = false;

    public JdbcTemplate() {
    }

    public JdbcTemplate(DataSource dataSource) {
        this.setDataSource(dataSource);
        this.afterPropertiesSet();
    }

    public JdbcTemplate(DataSource dataSource, boolean lazyInit) {
        this.setDataSource(dataSource);
        this.setLazyInit(lazyInit);
        this.afterPropertiesSet();
    }

    public void setNativeJdbcExtractor(NativeJdbcExtractor extractor) {
        this.nativeJdbcExtractor = extractor;
    }

    public NativeJdbcExtractor getNativeJdbcExtractor() {
        return this.nativeJdbcExtractor;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setSkipResultsProcessing(boolean skipResultsProcessing) {
        this.skipResultsProcessing = skipResultsProcessing;
    }

    public boolean isSkipResultsProcessing() {
        return this.skipResultsProcessing;
    }

    public void setSkipUndeclaredResults(boolean skipUndeclaredResults) {
        this.skipUndeclaredResults = skipUndeclaredResults;
    }

    public boolean isSkipUndeclaredResults() {
        return this.skipUndeclaredResults;
    }

    public void setResultsMapCaseInsensitive(boolean resultsMapCaseInsensitive) {
        this.resultsMapCaseInsensitive = resultsMapCaseInsensitive;
    }

    public boolean isResultsMapCaseInsensitive() {
        return this.resultsMapCaseInsensitive;
    }

    @Override
    public <T> T execute(ConnectionCallback<T> action2) throws DataAccessException {
        Assert.notNull(action2, "Callback object must not be null");
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        try {
            Connection conToUse = con;
            conToUse = this.nativeJdbcExtractor != null ? this.nativeJdbcExtractor.getNativeConnection(con) : this.createConnectionProxy(con);
            T t = action2.doInConnection(conToUse);
            return t;
        }
        catch (SQLException ex) {
            DataSourceUtils.releaseConnection(con, this.getDataSource());
            con = null;
            throw this.getExceptionTranslator().translate("ConnectionCallback", JdbcTemplate.getSql(action2), ex);
        }
        finally {
            DataSourceUtils.releaseConnection(con, this.getDataSource());
        }
    }

    protected Connection createConnectionProxy(Connection con) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(con));
    }

    @Override
    public <T> T execute(StatementCallback<T> action2) throws DataAccessException {
        T t;
        Assert.notNull(action2, "Callback object must not be null");
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        Statement stmt = null;
        try {
            Connection conToUse = con;
            if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativeStatements()) {
                conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
            }
            stmt = conToUse.createStatement();
            this.applyStatementSettings(stmt);
            Statement stmtToUse = stmt;
            if (this.nativeJdbcExtractor != null) {
                stmtToUse = this.nativeJdbcExtractor.getNativeStatement(stmt);
            }
            T result2 = action2.doInStatement(stmtToUse);
            this.handleWarnings(stmt);
            t = result2;
        }
        catch (SQLException ex) {
            try {
                JdbcUtils.closeStatement(stmt);
                stmt = null;
                DataSourceUtils.releaseConnection(con, this.getDataSource());
                con = null;
                throw this.getExceptionTranslator().translate("StatementCallback", JdbcTemplate.getSql(action2), ex);
            }
            catch (Throwable throwable2) {
                JdbcUtils.closeStatement(stmt);
                DataSourceUtils.releaseConnection(con, this.getDataSource());
                throw throwable2;
            }
        }
        JdbcUtils.closeStatement(stmt);
        DataSourceUtils.releaseConnection(con, this.getDataSource());
        return t;
    }

    @Override
    public void execute(final String sql2) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL statement [" + sql2 + "]");
        }
        class ExecuteStatementCallback
        implements StatementCallback<Object>,
        SqlProvider {
            ExecuteStatementCallback() {
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException {
                stmt.execute(sql2);
                return null;
            }

            @Override
            public String getSql() {
                return sql2;
            }
        }
        this.execute(new ExecuteStatementCallback());
    }

    @Override
    public <T> T query(final String sql2, final ResultSetExtractor<T> rse) throws DataAccessException {
        Assert.notNull(sql2, "SQL must not be null");
        Assert.notNull(rse, "ResultSetExtractor must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL query [" + sql2 + "]");
        }
        class QueryStatementCallback
        implements StatementCallback<T>,
        SqlProvider {
            QueryStatementCallback() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInStatement(Statement stmt) throws SQLException {
                Object t;
                ResultSet rs = null;
                try {
                    ResultSet rsToUse = rs = stmt.executeQuery(sql2);
                    if (JdbcTemplate.this.nativeJdbcExtractor != null) {
                        rsToUse = JdbcTemplate.this.nativeJdbcExtractor.getNativeResultSet(rs);
                    }
                    t = rse.extractData(rsToUse);
                }
                catch (Throwable throwable2) {
                    JdbcUtils.closeResultSet(rs);
                    throw throwable2;
                }
                JdbcUtils.closeResultSet(rs);
                return t;
            }

            @Override
            public String getSql() {
                return sql2;
            }
        }
        return this.execute(new QueryStatementCallback());
    }

    @Override
    public void query(String sql2, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql2, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public <T> List<T> query(String sql2, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(sql2, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public Map<String, Object> queryForMap(String sql2) throws DataAccessException {
        return this.queryForObject(sql2, this.getColumnMapRowMapper());
    }

    @Override
    public <T> T queryForObject(String sql2, RowMapper<T> rowMapper) throws DataAccessException {
        List<T> results = this.query(sql2, rowMapper);
        return DataAccessUtils.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql2, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql2, this.getSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> List<T> queryForList(String sql2, Class<T> elementType2) throws DataAccessException {
        return this.query(sql2, this.getSingleColumnRowMapper(elementType2));
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql2) throws DataAccessException {
        return this.query(sql2, this.getColumnMapRowMapper());
    }

    @Override
    public SqlRowSet queryForRowSet(String sql2) throws DataAccessException {
        return this.query(sql2, new SqlRowSetResultSetExtractor());
    }

    @Override
    public int update(final String sql2) throws DataAccessException {
        Assert.notNull(sql2, "SQL must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL update [" + sql2 + "]");
        }
        class UpdateStatementCallback
        implements StatementCallback<Integer>,
        SqlProvider {
            UpdateStatementCallback() {
            }

            @Override
            public Integer doInStatement(Statement stmt) throws SQLException {
                int rows = stmt.executeUpdate(sql2);
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug("SQL update affected " + rows + " rows");
                }
                return rows;
            }

            @Override
            public String getSql() {
                return sql2;
            }
        }
        return this.execute(new UpdateStatementCallback());
    }

    @Override
    public int[] batchUpdate(final String ... sql2) throws DataAccessException {
        Assert.notEmpty(sql2, "SQL array must not be empty");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL batch update of " + sql2.length + " statements");
        }
        class BatchUpdateStatementCallback
        implements StatementCallback<int[]>,
        SqlProvider {
            private String currSql;

            BatchUpdateStatementCallback() {
            }

            @Override
            public int[] doInStatement(Statement stmt) throws SQLException, DataAccessException {
                int[] rowsAffected = new int[sql2.length];
                if (JdbcUtils.supportsBatchUpdates(stmt.getConnection())) {
                    for (String sqlStmt : sql2) {
                        this.currSql = this.appendSql(this.currSql, sqlStmt);
                        stmt.addBatch(sqlStmt);
                    }
                    try {
                        rowsAffected = stmt.executeBatch();
                    }
                    catch (BatchUpdateException ex) {
                        String batchExceptionSql = null;
                        for (int i = 0; i < ex.getUpdateCounts().length; ++i) {
                            if (ex.getUpdateCounts()[i] != -3) continue;
                            batchExceptionSql = this.appendSql(batchExceptionSql, sql2[i]);
                        }
                        if (StringUtils.hasLength(batchExceptionSql)) {
                            this.currSql = batchExceptionSql;
                        }
                        throw ex;
                    }
                } else {
                    for (int i = 0; i < sql2.length; ++i) {
                        this.currSql = sql2[i];
                        if (stmt.execute(sql2[i])) {
                            throw new InvalidDataAccessApiUsageException("Invalid batch SQL statement: " + sql2[i]);
                        }
                        rowsAffected[i] = stmt.getUpdateCount();
                    }
                }
                return rowsAffected;
            }

            private String appendSql(String sql22, String statement) {
                return StringUtils.isEmpty(sql22) ? statement : sql22 + "; " + statement;
            }

            @Override
            public String getSql() {
                return this.currSql;
            }
        }
        return this.execute(new BatchUpdateStatementCallback());
    }

    @Override
    public <T> T execute(PreparedStatementCreator psc, PreparedStatementCallback<T> action2) throws DataAccessException {
        T t;
        Assert.notNull(psc, "PreparedStatementCreator must not be null");
        Assert.notNull(action2, "Callback object must not be null");
        if (this.logger.isDebugEnabled()) {
            String sql2 = JdbcTemplate.getSql(psc);
            this.logger.debug("Executing prepared SQL statement" + (sql2 != null ? " [" + sql2 + "]" : ""));
        }
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        PreparedStatement ps = null;
        try {
            Connection conToUse = con;
            if (this.nativeJdbcExtractor != null && this.nativeJdbcExtractor.isNativeConnectionNecessaryForNativePreparedStatements()) {
                conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
            }
            ps = psc.createPreparedStatement(conToUse);
            this.applyStatementSettings(ps);
            PreparedStatement psToUse = ps;
            if (this.nativeJdbcExtractor != null) {
                psToUse = this.nativeJdbcExtractor.getNativePreparedStatement(ps);
            }
            T result2 = action2.doInPreparedStatement(psToUse);
            this.handleWarnings(ps);
            t = result2;
        }
        catch (SQLException ex) {
            try {
                if (psc instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)psc)).cleanupParameters();
                }
                String sql3 = JdbcTemplate.getSql(psc);
                psc = null;
                JdbcUtils.closeStatement(ps);
                ps = null;
                DataSourceUtils.releaseConnection(con, this.getDataSource());
                con = null;
                throw this.getExceptionTranslator().translate("PreparedStatementCallback", sql3, ex);
            }
            catch (Throwable throwable2) {
                if (psc instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)psc)).cleanupParameters();
                }
                JdbcUtils.closeStatement(ps);
                DataSourceUtils.releaseConnection(con, this.getDataSource());
                throw throwable2;
            }
        }
        if (psc instanceof ParameterDisposer) {
            ((ParameterDisposer)((Object)psc)).cleanupParameters();
        }
        JdbcUtils.closeStatement(ps);
        DataSourceUtils.releaseConnection(con, this.getDataSource());
        return t;
    }

    @Override
    public <T> T execute(String sql2, PreparedStatementCallback<T> action2) throws DataAccessException {
        return this.execute(new SimplePreparedStatementCreator(sql2), action2);
    }

    public <T> T query(PreparedStatementCreator psc, final PreparedStatementSetter pss, final ResultSetExtractor<T> rse) throws DataAccessException {
        Assert.notNull(rse, "ResultSetExtractor must not be null");
        this.logger.debug("Executing prepared SQL query");
        return this.execute(psc, new PreparedStatementCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T doInPreparedStatement(PreparedStatement ps) throws SQLException {
                Object t;
                ResultSet rs = null;
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    ResultSet rsToUse = rs = ps.executeQuery();
                    if (JdbcTemplate.this.nativeJdbcExtractor != null) {
                        rsToUse = JdbcTemplate.this.nativeJdbcExtractor.getNativeResultSet(rs);
                    }
                    t = rse.extractData(rsToUse);
                }
                catch (Throwable throwable2) {
                    JdbcUtils.closeResultSet(rs);
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                    throw throwable2;
                }
                JdbcUtils.closeResultSet(rs);
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)pss)).cleanupParameters();
                }
                return t;
            }
        });
    }

    @Override
    public <T> T query(PreparedStatementCreator psc, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(psc, null, rse);
    }

    @Override
    public <T> T query(String sql2, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(new SimplePreparedStatementCreator(sql2), pss, rse);
    }

    @Override
    public <T> T query(String sql2, Object[] args2, int[] argTypes, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(sql2, this.newArgTypePreparedStatementSetter(args2, argTypes), rse);
    }

    @Override
    public <T> T query(String sql2, Object[] args2, ResultSetExtractor<T> rse) throws DataAccessException {
        return this.query(sql2, this.newArgPreparedStatementSetter(args2), rse);
    }

    @Override
    public <T> T query(String sql2, ResultSetExtractor<T> rse, Object ... args2) throws DataAccessException {
        return this.query(sql2, this.newArgPreparedStatementSetter(args2), rse);
    }

    @Override
    public void query(PreparedStatementCreator psc, RowCallbackHandler rch) throws DataAccessException {
        this.query(psc, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql2, PreparedStatementSetter pss, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql2, pss, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql2, Object[] args2, int[] argTypes, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql2, this.newArgTypePreparedStatementSetter(args2, argTypes), rch);
    }

    @Override
    public void query(String sql2, Object[] args2, RowCallbackHandler rch) throws DataAccessException {
        this.query(sql2, this.newArgPreparedStatementSetter(args2), rch);
    }

    @Override
    public void query(String sql2, RowCallbackHandler rch, Object ... args2) throws DataAccessException {
        this.query(sql2, this.newArgPreparedStatementSetter(args2), rch);
    }

    @Override
    public <T> List<T> query(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(psc, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql2, PreparedStatementSetter pss, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(sql2, pss, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql2, Object[] args2, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(sql2, args2, argTypes, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql2, Object[] args2, RowMapper<T> rowMapper) throws DataAccessException {
        return (List)this.query(sql2, args2, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> query(String sql2, RowMapper<T> rowMapper, Object ... args2) throws DataAccessException {
        return (List)this.query(sql2, args2, new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> T queryForObject(String sql2, Object[] args2, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        List results = (List)this.query(sql2, args2, argTypes, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return DataAccessUtils.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql2, Object[] args2, RowMapper<T> rowMapper) throws DataAccessException {
        List results = (List)this.query(sql2, args2, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return DataAccessUtils.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql2, RowMapper<T> rowMapper, Object ... args2) throws DataAccessException {
        List results = (List)this.query(sql2, args2, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return DataAccessUtils.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(String sql2, Object[] args2, int[] argTypes, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql2, args2, argTypes, this.getSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql2, Object[] args2, Class<T> requiredType) throws DataAccessException {
        return this.queryForObject(sql2, args2, this.getSingleColumnRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql2, Class<T> requiredType, Object ... args2) throws DataAccessException {
        return this.queryForObject(sql2, args2, this.getSingleColumnRowMapper(requiredType));
    }

    @Override
    public Map<String, Object> queryForMap(String sql2, Object[] args2, int[] argTypes) throws DataAccessException {
        return this.queryForObject(sql2, args2, argTypes, this.getColumnMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql2, Object ... args2) throws DataAccessException {
        return this.queryForObject(sql2, args2, this.getColumnMapRowMapper());
    }

    @Override
    public <T> List<T> queryForList(String sql2, Object[] args2, int[] argTypes, Class<T> elementType2) throws DataAccessException {
        return this.query(sql2, args2, argTypes, this.getSingleColumnRowMapper(elementType2));
    }

    @Override
    public <T> List<T> queryForList(String sql2, Object[] args2, Class<T> elementType2) throws DataAccessException {
        return this.query(sql2, args2, this.getSingleColumnRowMapper(elementType2));
    }

    @Override
    public <T> List<T> queryForList(String sql2, Class<T> elementType2, Object ... args2) throws DataAccessException {
        return this.query(sql2, args2, this.getSingleColumnRowMapper(elementType2));
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql2, Object[] args2, int[] argTypes) throws DataAccessException {
        return this.query(sql2, args2, argTypes, this.getColumnMapRowMapper());
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql2, Object ... args2) throws DataAccessException {
        return this.query(sql2, args2, this.getColumnMapRowMapper());
    }

    @Override
    public SqlRowSet queryForRowSet(String sql2, Object[] args2, int[] argTypes) throws DataAccessException {
        return this.query(sql2, args2, argTypes, new SqlRowSetResultSetExtractor());
    }

    @Override
    public SqlRowSet queryForRowSet(String sql2, Object ... args2) throws DataAccessException {
        return this.query(sql2, args2, new SqlRowSetResultSetExtractor());
    }

    protected int update(PreparedStatementCreator psc, final PreparedStatementSetter pss) throws DataAccessException {
        this.logger.debug("Executing prepared SQL update");
        return this.execute(psc, new PreparedStatementCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    if (pss != null) {
                        pss.setValues(ps);
                    }
                    int rows = ps.executeUpdate();
                    if (JdbcTemplate.this.logger.isDebugEnabled()) {
                        JdbcTemplate.this.logger.debug("SQL update affected " + rows + " rows");
                    }
                    Integer n = rows;
                    return n;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
    }

    @Override
    public int update(PreparedStatementCreator psc) throws DataAccessException {
        return this.update(psc, (PreparedStatementSetter)null);
    }

    @Override
    public int update(PreparedStatementCreator psc, final KeyHolder generatedKeyHolder) throws DataAccessException {
        Assert.notNull(generatedKeyHolder, "KeyHolder must not be null");
        this.logger.debug("Executing SQL update and returning generated keys");
        return this.execute(psc, new PreparedStatementCallback<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer doInPreparedStatement(PreparedStatement ps) throws SQLException {
                int rows = ps.executeUpdate();
                List<Map<String, Object>> generatedKeys = generatedKeyHolder.getKeyList();
                generatedKeys.clear();
                ResultSet keys = ps.getGeneratedKeys();
                if (keys != null) {
                    try {
                        RowMapperResultSetExtractor<Map<String, Object>> rse = new RowMapperResultSetExtractor<Map<String, Object>>(JdbcTemplate.this.getColumnMapRowMapper(), 1);
                        generatedKeys.addAll((Collection<Map<String, Object>>)rse.extractData(keys));
                    }
                    finally {
                        JdbcUtils.closeResultSet(keys);
                    }
                }
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug("SQL update affected " + rows + " rows and returned " + generatedKeys.size() + " keys");
                }
                return rows;
            }
        });
    }

    @Override
    public int update(String sql2, PreparedStatementSetter pss) throws DataAccessException {
        return this.update((PreparedStatementCreator)new SimplePreparedStatementCreator(sql2), pss);
    }

    @Override
    public int update(String sql2, Object[] args2, int[] argTypes) throws DataAccessException {
        return this.update(sql2, this.newArgTypePreparedStatementSetter(args2, argTypes));
    }

    @Override
    public int update(String sql2, Object ... args2) throws DataAccessException {
        return this.update(sql2, this.newArgPreparedStatementSetter(args2));
    }

    @Override
    public int[] batchUpdate(String sql2, final BatchPreparedStatementSetter pss) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL batch update [" + sql2 + "]");
        }
        return this.execute(sql2, new PreparedStatementCallback<int[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    InterruptibleBatchPreparedStatementSetter ipss;
                    int batchSize = pss.getBatchSize();
                    InterruptibleBatchPreparedStatementSetter interruptibleBatchPreparedStatementSetter = ipss = pss instanceof InterruptibleBatchPreparedStatementSetter ? (InterruptibleBatchPreparedStatementSetter)pss : null;
                    if (JdbcUtils.supportsBatchUpdates(ps.getConnection())) {
                        for (int i = 0; i < batchSize; ++i) {
                            pss.setValues(ps, i);
                            if (ipss != null && ipss.isBatchExhausted(i)) break;
                            ps.addBatch();
                        }
                        int[] i = ps.executeBatch();
                        return i;
                    }
                    ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
                    for (int i = 0; i < batchSize; ++i) {
                        pss.setValues(ps, i);
                        if (ipss != null && ipss.isBatchExhausted(i)) break;
                        rowsAffected.add(ps.executeUpdate());
                    }
                    int[] rowsAffectedArray = new int[rowsAffected.size()];
                    for (int i = 0; i < rowsAffectedArray.length; ++i) {
                        rowsAffectedArray[i] = (Integer)rowsAffected.get(i);
                    }
                    int[] nArray = rowsAffectedArray;
                    return nArray;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
    }

    @Override
    public int[] batchUpdate(String sql2, List<Object[]> batchArgs) throws DataAccessException {
        return this.batchUpdate(sql2, batchArgs, new int[0]);
    }

    @Override
    public int[] batchUpdate(String sql2, List<Object[]> batchArgs, int[] argTypes) throws DataAccessException {
        return BatchUpdateUtils.executeBatchUpdate(sql2, batchArgs, argTypes, this);
    }

    @Override
    public <T> int[][] batchUpdate(String sql2, final Collection<T> batchArgs, final int batchSize, final ParameterizedPreparedStatementSetter<T> pss) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Executing SQL batch update [" + sql2 + "] with a batch size of " + batchSize);
        }
        return this.execute(sql2, new PreparedStatementCallback<int[][]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[][] doInPreparedStatement(PreparedStatement ps) throws SQLException {
                ArrayList<int[]> rowsAffected = new ArrayList<int[]>();
                try {
                    boolean batchSupported = true;
                    if (!JdbcUtils.supportsBatchUpdates(ps.getConnection())) {
                        batchSupported = false;
                        JdbcTemplate.this.logger.warn("JDBC Driver does not support Batch updates; resorting to single statement execution");
                    }
                    int n = 0;
                    for (Object obj : batchArgs) {
                        pss.setValues(ps, obj);
                        ++n;
                        if (batchSupported) {
                            ps.addBatch();
                            if (n % batchSize != 0 && n != batchArgs.size()) continue;
                            if (JdbcTemplate.this.logger.isDebugEnabled()) {
                                int batchIdx = n % batchSize == 0 ? n / batchSize : n / batchSize + 1;
                                int items = n - (n % batchSize == 0 ? n / batchSize - 1 : n / batchSize) * batchSize;
                                JdbcTemplate.this.logger.debug("Sending SQL batch update #" + batchIdx + " with " + items + " items");
                            }
                            rowsAffected.add(ps.executeBatch());
                            continue;
                        }
                        int i = ps.executeUpdate();
                        rowsAffected.add(new int[]{i});
                    }
                    int[][] result2 = new int[rowsAffected.size()][];
                    for (int i = 0; i < result2.length; ++i) {
                        result2[i] = (int[])rowsAffected.get(i);
                    }
                    int[][] nArrayArray = result2;
                    return nArrayArray;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)((Object)pss)).cleanupParameters();
                    }
                }
            }
        });
    }

    @Override
    public <T> T execute(CallableStatementCreator csc, CallableStatementCallback<T> action2) throws DataAccessException {
        T t;
        Assert.notNull(csc, "CallableStatementCreator must not be null");
        Assert.notNull(action2, "Callback object must not be null");
        if (this.logger.isDebugEnabled()) {
            String sql2 = JdbcTemplate.getSql(csc);
            this.logger.debug("Calling stored procedure" + (sql2 != null ? " [" + sql2 + "]" : ""));
        }
        Connection con = DataSourceUtils.getConnection(this.getDataSource());
        CallableStatement cs = null;
        try {
            Connection conToUse = con;
            if (this.nativeJdbcExtractor != null) {
                conToUse = this.nativeJdbcExtractor.getNativeConnection(con);
            }
            cs = csc.createCallableStatement(conToUse);
            this.applyStatementSettings(cs);
            CallableStatement csToUse = cs;
            if (this.nativeJdbcExtractor != null) {
                csToUse = this.nativeJdbcExtractor.getNativeCallableStatement(cs);
            }
            T result2 = action2.doInCallableStatement(csToUse);
            this.handleWarnings(cs);
            t = result2;
        }
        catch (SQLException ex) {
            try {
                if (csc instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)csc)).cleanupParameters();
                }
                String sql3 = JdbcTemplate.getSql(csc);
                csc = null;
                JdbcUtils.closeStatement(cs);
                cs = null;
                DataSourceUtils.releaseConnection(con, this.getDataSource());
                con = null;
                throw this.getExceptionTranslator().translate("CallableStatementCallback", sql3, ex);
            }
            catch (Throwable throwable2) {
                if (csc instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)csc)).cleanupParameters();
                }
                JdbcUtils.closeStatement(cs);
                DataSourceUtils.releaseConnection(con, this.getDataSource());
                throw throwable2;
            }
        }
        if (csc instanceof ParameterDisposer) {
            ((ParameterDisposer)((Object)csc)).cleanupParameters();
        }
        JdbcUtils.closeStatement(cs);
        DataSourceUtils.releaseConnection(con, this.getDataSource());
        return t;
    }

    @Override
    public <T> T execute(String callString, CallableStatementCallback<T> action2) throws DataAccessException {
        return this.execute(new SimpleCallableStatementCreator(callString), action2);
    }

    @Override
    public Map<String, Object> call(CallableStatementCreator csc, List<SqlParameter> declaredParameters) throws DataAccessException {
        final ArrayList<SqlParameter> updateCountParameters = new ArrayList<SqlParameter>();
        final ArrayList<SqlParameter> resultSetParameters = new ArrayList<SqlParameter>();
        final ArrayList<SqlParameter> callParameters = new ArrayList<SqlParameter>();
        for (SqlParameter parameter : declaredParameters) {
            if (parameter.isResultsParameter()) {
                if (parameter instanceof SqlReturnResultSet) {
                    resultSetParameters.add(parameter);
                    continue;
                }
                updateCountParameters.add(parameter);
                continue;
            }
            callParameters.add(parameter);
        }
        return this.execute(csc, new CallableStatementCallback<Map<String, Object>>(){

            @Override
            public Map<String, Object> doInCallableStatement(CallableStatement cs) throws SQLException {
                boolean retVal = cs.execute();
                int updateCount = cs.getUpdateCount();
                if (JdbcTemplate.this.logger.isDebugEnabled()) {
                    JdbcTemplate.this.logger.debug("CallableStatement.execute() returned '" + retVal + "'");
                    JdbcTemplate.this.logger.debug("CallableStatement.getUpdateCount() returned " + updateCount);
                }
                Map<String, Object> returnedResults = JdbcTemplate.this.createResultsMap();
                if (retVal || updateCount != -1) {
                    returnedResults.putAll(JdbcTemplate.this.extractReturnedResults(cs, updateCountParameters, resultSetParameters, updateCount));
                }
                returnedResults.putAll(JdbcTemplate.this.extractOutputParameters(cs, callParameters));
                return returnedResults;
            }
        });
    }

    protected Map<String, Object> extractReturnedResults(CallableStatement cs, List<SqlParameter> updateCountParameters, List<SqlParameter> resultSetParameters, int updateCount) throws SQLException {
        HashMap<String, Object> returnedResults = new HashMap<String, Object>();
        int rsIndex = 0;
        int updateIndex = 0;
        if (!this.skipResultsProcessing) {
            boolean moreResults;
            do {
                if (updateCount == -1) {
                    if (resultSetParameters != null && resultSetParameters.size() > rsIndex) {
                        SqlReturnResultSet declaredRsParam = (SqlReturnResultSet)resultSetParameters.get(rsIndex);
                        returnedResults.putAll(this.processResultSet(cs.getResultSet(), declaredRsParam));
                        ++rsIndex;
                    } else if (!this.skipUndeclaredResults) {
                        String rsName = RETURN_RESULT_SET_PREFIX + (rsIndex + 1);
                        SqlReturnResultSet undeclaredRsParam = new SqlReturnResultSet(rsName, this.getColumnMapRowMapper());
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Added default SqlReturnResultSet parameter named '" + rsName + "'");
                        }
                        returnedResults.putAll(this.processResultSet(cs.getResultSet(), undeclaredRsParam));
                        ++rsIndex;
                    }
                } else if (updateCountParameters != null && updateCountParameters.size() > updateIndex) {
                    SqlReturnUpdateCount ucParam = (SqlReturnUpdateCount)updateCountParameters.get(updateIndex);
                    String declaredUcName = ucParam.getName();
                    returnedResults.put(declaredUcName, updateCount);
                    ++updateIndex;
                } else if (!this.skipUndeclaredResults) {
                    String undeclaredName = RETURN_UPDATE_COUNT_PREFIX + (updateIndex + 1);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Added default SqlReturnUpdateCount parameter named '" + undeclaredName + "'");
                    }
                    returnedResults.put(undeclaredName, updateCount);
                    ++updateIndex;
                }
                moreResults = cs.getMoreResults();
                updateCount = cs.getUpdateCount();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("CallableStatement.getUpdateCount() returned " + updateCount);
            } while (moreResults || updateCount != -1);
        }
        return returnedResults;
    }

    protected Map<String, Object> extractOutputParameters(CallableStatement cs, List<SqlParameter> parameters) throws SQLException {
        HashMap<String, Object> returnedResults = new HashMap<String, Object>();
        int sqlColIndex = 1;
        for (SqlParameter param2 : parameters) {
            if (param2 instanceof SqlOutParameter) {
                Object out;
                SqlOutParameter outParam = (SqlOutParameter)param2;
                if (outParam.isReturnTypeSupported()) {
                    out = outParam.getSqlReturnType().getTypeValue(cs, sqlColIndex, outParam.getSqlType(), outParam.getTypeName());
                    returnedResults.put(outParam.getName(), out);
                } else {
                    out = cs.getObject(sqlColIndex);
                    if (out instanceof ResultSet) {
                        if (outParam.isResultSetSupported()) {
                            returnedResults.putAll(this.processResultSet((ResultSet)out, outParam));
                        } else {
                            String rsName = outParam.getName();
                            SqlReturnResultSet rsParam = new SqlReturnResultSet(rsName, this.getColumnMapRowMapper());
                            returnedResults.putAll(this.processResultSet((ResultSet)out, rsParam));
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Added default SqlReturnResultSet parameter named '" + rsName + "'");
                            }
                        }
                    } else {
                        returnedResults.put(outParam.getName(), out);
                    }
                }
            }
            if (param2.isResultsParameter()) continue;
            ++sqlColIndex;
        }
        return returnedResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> processResultSet(ResultSet rs, ResultSetSupportingSqlParameter param2) throws SQLException {
        if (rs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> returnedResults = new HashMap<String, Object>();
        try {
            ResultSet rsToUse = rs;
            if (this.nativeJdbcExtractor != null) {
                rsToUse = this.nativeJdbcExtractor.getNativeResultSet(rs);
            }
            if (param2.getRowMapper() != null) {
                RowMapper<?> rowMapper = param2.getRowMapper();
                Object result2 = new RowMapperResultSetExtractor(rowMapper).extractData(rsToUse);
                returnedResults.put(param2.getName(), result2);
            } else if (param2.getRowCallbackHandler() != null) {
                RowCallbackHandler rch = param2.getRowCallbackHandler();
                new RowCallbackHandlerResultSetExtractor(rch).extractData(rsToUse);
                returnedResults.put(param2.getName(), "ResultSet returned from stored procedure was processed");
            } else if (param2.getResultSetExtractor() != null) {
                Object result3 = param2.getResultSetExtractor().extractData(rsToUse);
                returnedResults.put(param2.getName(), result3);
            }
        }
        finally {
            JdbcUtils.closeResultSet(rs);
        }
        return returnedResults;
    }

    protected RowMapper<Map<String, Object>> getColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected <T> RowMapper<T> getSingleColumnRowMapper(Class<T> requiredType) {
        return new SingleColumnRowMapper<T>(requiredType);
    }

    protected Map<String, Object> createResultsMap() {
        if (this.isResultsMapCaseInsensitive()) {
            return new LinkedCaseInsensitiveMap<Object>();
        }
        return new LinkedHashMap<String, Object>();
    }

    protected void applyStatementSettings(Statement stmt) throws SQLException {
        int maxRows;
        int fetchSize = this.getFetchSize();
        if (fetchSize != -1) {
            stmt.setFetchSize(fetchSize);
        }
        if ((maxRows = this.getMaxRows()) != -1) {
            stmt.setMaxRows(maxRows);
        }
        DataSourceUtils.applyTimeout(stmt, this.getDataSource(), this.getQueryTimeout());
    }

    protected PreparedStatementSetter newArgPreparedStatementSetter(Object[] args2) {
        return new ArgumentPreparedStatementSetter(args2);
    }

    protected PreparedStatementSetter newArgTypePreparedStatementSetter(Object[] args2, int[] argTypes) {
        return new ArgumentTypePreparedStatementSetter(args2, argTypes);
    }

    protected void handleWarnings(Statement stmt) throws SQLException {
        if (this.isIgnoreWarnings()) {
            if (this.logger.isDebugEnabled()) {
                for (SQLWarning warningToLog = stmt.getWarnings(); warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                    this.logger.debug("SQLWarning ignored: SQL state '" + warningToLog.getSQLState() + "', error code '" + warningToLog.getErrorCode() + "', message [" + warningToLog.getMessage() + "]");
                }
            }
        } else {
            this.handleWarnings(stmt.getWarnings());
        }
    }

    protected void handleWarnings(SQLWarning warning2) throws SQLWarningException {
        if (warning2 != null) {
            throw new SQLWarningException("Warning not ignored", warning2);
        }
    }

    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor<Object> {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        @Override
        public Object extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.rch.processRow(rs);
            }
            return null;
        }
    }

    private static class SimpleCallableStatementCreator
    implements CallableStatementCreator,
    SqlProvider {
        private final String callString;

        public SimpleCallableStatementCreator(String callString) {
            Assert.notNull(callString, "Call string must not be null");
            this.callString = callString;
        }

        @Override
        public CallableStatement createCallableStatement(Connection con) throws SQLException {
            return con.prepareCall(this.callString);
        }

        @Override
        public String getSql() {
            return this.callString;
        }
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private final String sql;

        public SimplePreparedStatementCreator(String sql2) {
            Assert.notNull(sql2, "SQL must not be null");
            this.sql = sql2;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return con.prepareStatement(this.sql);
        }

        @Override
        public String getSql() {
            return this.sql;
        }
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args2[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("unwrap")) {
                if (((Class)args2[0]).isInstance(proxy)) {
                    return proxy;
                }
            } else if (method.getName().equals("isWrapperFor")) {
                if (((Class)args2[0]).isInstance(proxy)) {
                    return true;
                }
            } else {
                if (method.getName().equals("close")) {
                    return null;
                }
                if (method.getName().equals("isClosed")) {
                    return false;
                }
                if (method.getName().equals("getTargetConnection")) {
                    return this.target;
                }
            }
            try {
                Object retVal = method.invoke((Object)this.target, args2);
                if (retVal instanceof Statement) {
                    JdbcTemplate.this.applyStatementSettings((Statement)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

