/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.StatementCreatorUtils;

public abstract class BatchUpdateUtils {
    public static int[] executeBatchUpdate(String sql2, final List<Object[]> batchValues, final int[] columnTypes, JdbcOperations jdbcOperations) {
        return jdbcOperations.batchUpdate(sql2, new BatchPreparedStatementSetter(){

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object[] values2 = (Object[])batchValues.get(i);
                BatchUpdateUtils.setStatementParameters(values2, ps, columnTypes);
            }

            @Override
            public int getBatchSize() {
                return batchValues.size();
            }
        });
    }

    protected static void setStatementParameters(Object[] values2, PreparedStatement ps, int[] columnTypes) throws SQLException {
        int colIndex = 0;
        for (Object value2 : values2) {
            ++colIndex;
            if (value2 instanceof SqlParameterValue) {
                SqlParameterValue paramValue = (SqlParameterValue)value2;
                StatementCreatorUtils.setParameterValue(ps, colIndex, paramValue, paramValue.getValue());
                continue;
            }
            int colType = columnTypes == null || columnTypes.length < colIndex ? Integer.MIN_VALUE : columnTypes[colIndex - 1];
            StatementCreatorUtils.setParameterValue(ps, colIndex, colType, value2);
        }
    }
}

