/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.StatementCreatorUtils;

public class ArgumentTypePreparedStatementSetter
implements PreparedStatementSetter,
ParameterDisposer {
    private final Object[] args;
    private final int[] argTypes;

    public ArgumentTypePreparedStatementSetter(Object[] args2, int[] argTypes) {
        if (args2 != null && argTypes == null || args2 == null && argTypes != null || args2 != null && args2.length != argTypes.length) {
            throw new InvalidDataAccessApiUsageException("args and argTypes parameters must match");
        }
        this.args = args2;
        this.argTypes = argTypes;
    }

    @Override
    public void setValues(PreparedStatement ps) throws SQLException {
        int parameterPosition = 1;
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                Object arg = this.args[i];
                if (arg instanceof Collection && this.argTypes[i] != 2003) {
                    Collection entries = (Collection)arg;
                    for (Object entry2 : entries) {
                        if (entry2 instanceof Object[]) {
                            Object[] valueArray;
                            for (Object argValue : valueArray = (Object[])entry2) {
                                this.doSetValue(ps, parameterPosition, this.argTypes[i], argValue);
                                ++parameterPosition;
                            }
                            continue;
                        }
                        this.doSetValue(ps, parameterPosition, this.argTypes[i], entry2);
                        ++parameterPosition;
                    }
                    continue;
                }
                this.doSetValue(ps, parameterPosition, this.argTypes[i], arg);
                ++parameterPosition;
            }
        }
    }

    protected void doSetValue(PreparedStatement ps, int parameterPosition, int argType, Object argValue) throws SQLException {
        StatementCreatorUtils.setParameterValue(ps, parameterPosition, argType, argValue);
    }

    @Override
    public void cleanupParameters() {
        StatementCreatorUtils.cleanupParameters(this.args);
    }
}

