/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.weblogic;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Hashtable;

class WebLogicClassPreProcessorAdapter
implements InvocationHandler {
    private final ClassFileTransformer transformer;
    private final ClassLoader loader;

    public WebLogicClassPreProcessorAdapter(ClassFileTransformer transformer, ClassLoader loader) {
        this.transformer = transformer;
        this.loader = loader;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        String name = method.getName();
        if ("equals".equals(name)) {
            return proxy == args2[0];
        }
        if ("hashCode".equals(name)) {
            return this.hashCode();
        }
        if ("toString".equals(name)) {
            return this.toString();
        }
        if ("initialize".equals(name)) {
            this.initialize((Hashtable)args2[0]);
            return null;
        }
        if ("preProcess".equals(name)) {
            return this.preProcess((String)args2[0], (byte[])args2[1]);
        }
        throw new IllegalArgumentException("Unknown method: " + method);
    }

    public void initialize(Hashtable<?, ?> params2) {
    }

    public byte[] preProcess(String className, byte[] classBytes2) {
        try {
            byte[] result2 = this.transformer.transform(this.loader, className, null, null, classBytes2);
            return result2 != null ? result2 : classBytes2;
        }
        catch (IllegalClassFormatException ex) {
            throw new IllegalStateException("Cannot transform due to illegal class format", ex);
        }
    }

    public String toString() {
        return this.getClass().getName() + " for transformer: " + this.transformer;
    }
}

