/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.support;

import java.beans.PropertyEditorSupport;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.format.Formatter;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class FormatterPropertyEditorAdapter
extends PropertyEditorSupport {
    private final Formatter<Object> formatter;

    public FormatterPropertyEditorAdapter(Formatter<?> formatter) {
        Assert.notNull(formatter, "Formatter must not be null");
        this.formatter = formatter;
    }

    public Class<?> getFieldType() {
        return FormattingConversionService.getFieldType(this.formatter);
    }

    @Override
    public void setAsText(String text2) throws IllegalArgumentException {
        if (StringUtils.hasText(text2)) {
            try {
                this.setValue(this.formatter.parse(text2, LocaleContextHolder.getLocale()));
            }
            catch (IllegalArgumentException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException("Parse attempt failed for value [" + text2 + "]", ex);
            }
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getAsText() {
        Object value2 = this.getValue();
        return value2 != null ? this.formatter.print(value2, LocaleContextHolder.getLocale()) : "";
    }
}

