/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.CompilablePropertyAccessor;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ReflectivePropertyAccessor
implements PropertyAccessor {
    private static final Set<Class<?>> ANY_TYPES = Collections.emptySet();
    private static final Set<Class<?>> BOOLEAN_TYPES;
    private final boolean allowWrite;
    private final Map<PropertyCacheKey, InvokerPair> readerCache = new ConcurrentHashMap<PropertyCacheKey, InvokerPair>(64);
    private final Map<PropertyCacheKey, Member> writerCache = new ConcurrentHashMap<PropertyCacheKey, Member>(64);
    private final Map<PropertyCacheKey, TypeDescriptor> typeDescriptorCache = new ConcurrentHashMap<PropertyCacheKey, TypeDescriptor>(64);
    private final Map<Class<?>, Method[]> sortedMethodsCache = new ConcurrentHashMap(64);
    private volatile InvokerPair lastReadInvokerPair;

    public ReflectivePropertyAccessor() {
        this.allowWrite = true;
    }

    public ReflectivePropertyAccessor(boolean allowWrite) {
        this.allowWrite = allowWrite;
    }

    @Override
    public Class<?>[] getSpecificTargetClasses() {
        return null;
    }

    @Override
    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        Class<?> type;
        if (target == null) {
            return false;
        }
        Class<?> clazz2 = type = target instanceof Class ? (Class<?>)target : target.getClass();
        if (type.isArray() && name.equals("length")) {
            return true;
        }
        PropertyCacheKey cacheKey = new PropertyCacheKey(type, name, target instanceof Class);
        if (this.readerCache.containsKey(cacheKey)) {
            return true;
        }
        Method method = this.findGetterForProperty(name, type, target);
        if (method != null) {
            Property property = new Property(type, method, null);
            TypeDescriptor typeDescriptor = new TypeDescriptor(property);
            this.readerCache.put(cacheKey, new InvokerPair(method, typeDescriptor));
            this.typeDescriptorCache.put(cacheKey, typeDescriptor);
            return true;
        }
        Field field2 = this.findField(name, type, target);
        if (field2 != null) {
            TypeDescriptor typeDescriptor = new TypeDescriptor(field2);
            this.readerCache.put(cacheKey, new InvokerPair(field2, typeDescriptor));
            this.typeDescriptorCache.put(cacheKey, typeDescriptor);
            return true;
        }
        return false;
    }

    @Override
    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        Object value2;
        InvokerPair invoker;
        Class<?> type;
        if (target == null) {
            throw new AccessException("Cannot read property of null target");
        }
        Class<?> clazz2 = type = target instanceof Class ? (Class<?>)target : target.getClass();
        if (type.isArray() && name.equals("length")) {
            if (target instanceof Class) {
                throw new AccessException("Cannot access length on array class itself");
            }
            return new TypedValue(Array.getLength(target));
        }
        PropertyCacheKey cacheKey = new PropertyCacheKey(type, name, target instanceof Class);
        this.lastReadInvokerPair = invoker = this.readerCache.get(cacheKey);
        if (invoker == null || invoker.member instanceof Method) {
            Method method = (Method)(invoker != null ? invoker.member : null);
            if (method == null && (method = this.findGetterForProperty(name, type, target)) != null) {
                Property property = new Property(type, method, null);
                TypeDescriptor typeDescriptor = new TypeDescriptor(property);
                this.lastReadInvokerPair = invoker = new InvokerPair(method, typeDescriptor);
                this.readerCache.put(cacheKey, invoker);
            }
            if (method != null) {
                try {
                    ReflectionUtils.makeAccessible(method);
                    value2 = method.invoke(target, new Object[0]);
                    return new TypedValue(value2, invoker.typeDescriptor.narrow(value2));
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access property '" + name + "' through getter method", ex);
                }
            }
        }
        if (invoker == null || invoker.member instanceof Field) {
            Field field2 = (Field)(invoker == null ? null : invoker.member);
            if (field2 == null && (field2 = this.findField(name, type, target)) != null) {
                this.lastReadInvokerPair = invoker = new InvokerPair(field2, new TypeDescriptor(field2));
                this.readerCache.put(cacheKey, invoker);
            }
            if (field2 != null) {
                try {
                    ReflectionUtils.makeAccessible(field2);
                    value2 = field2.get(target);
                    return new TypedValue(value2, invoker.typeDescriptor.narrow(value2));
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access field '" + name + "'", ex);
                }
            }
        }
        throw new AccessException("Neither getter method nor field found for property '" + name + "'");
    }

    @Override
    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        if (!this.allowWrite || target == null) {
            return false;
        }
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        PropertyCacheKey cacheKey = new PropertyCacheKey(type, name, target instanceof Class);
        if (this.writerCache.containsKey(cacheKey)) {
            return true;
        }
        Method method = this.findSetterForProperty(name, type, target);
        if (method != null) {
            Property property = new Property(type, null, method);
            TypeDescriptor typeDescriptor = new TypeDescriptor(property);
            this.writerCache.put(cacheKey, method);
            this.typeDescriptorCache.put(cacheKey, typeDescriptor);
            return true;
        }
        Field field2 = this.findField(name, type, target);
        if (field2 != null) {
            this.writerCache.put(cacheKey, field2);
            this.typeDescriptorCache.put(cacheKey, new TypeDescriptor(field2));
            return true;
        }
        return false;
    }

    @Override
    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        PropertyCacheKey cacheKey;
        Member cachedMember;
        if (!this.allowWrite) {
            throw new AccessException("PropertyAccessor for property '" + name + "' on target [" + target + "] does not allow write operations");
        }
        if (target == null) {
            throw new AccessException("Cannot write property on null target");
        }
        Class<?> type = target instanceof Class ? (Class<?>)target : target.getClass();
        Object possiblyConvertedNewValue = newValue;
        TypeDescriptor typeDescriptor = this.getTypeDescriptor(context, target, name);
        if (typeDescriptor != null) {
            try {
                possiblyConvertedNewValue = context.getTypeConverter().convertValue(newValue, TypeDescriptor.forObject(newValue), typeDescriptor);
            }
            catch (EvaluationException evaluationException) {
                throw new AccessException("Type conversion failure", evaluationException);
            }
        }
        if ((cachedMember = this.writerCache.get(cacheKey = new PropertyCacheKey(type, name, target instanceof Class))) == null || cachedMember instanceof Method) {
            Method method = (Method)cachedMember;
            if (method == null && (method = this.findSetterForProperty(name, type, target)) != null) {
                cachedMember = method;
                this.writerCache.put(cacheKey, cachedMember);
            }
            if (method != null) {
                try {
                    ReflectionUtils.makeAccessible(method);
                    method.invoke(target, possiblyConvertedNewValue);
                    return;
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access property '" + name + "' through setter method", ex);
                }
            }
        }
        if (cachedMember == null || cachedMember instanceof Field) {
            Field field2 = (Field)cachedMember;
            if (field2 == null && (field2 = this.findField(name, type, target)) != null) {
                cachedMember = field2;
                this.writerCache.put(cacheKey, cachedMember);
            }
            if (field2 != null) {
                try {
                    ReflectionUtils.makeAccessible(field2);
                    field2.set(target, possiblyConvertedNewValue);
                    return;
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access field '" + name + "'", ex);
                }
            }
        }
        throw new AccessException("Neither setter method nor field found for property '" + name + "'");
    }

    @Deprecated
    public Member getLastReadInvokerPair() {
        InvokerPair lastReadInvoker = this.lastReadInvokerPair;
        return lastReadInvoker != null ? lastReadInvoker.member : null;
    }

    private TypeDescriptor getTypeDescriptor(EvaluationContext context, Object target, String name) {
        Class<?> type;
        if (target == null) {
            return null;
        }
        Class<?> clazz2 = type = target instanceof Class ? (Class<?>)target : target.getClass();
        if (type.isArray() && name.equals("length")) {
            return TypeDescriptor.valueOf(Integer.TYPE);
        }
        PropertyCacheKey cacheKey = new PropertyCacheKey(type, name, target instanceof Class);
        TypeDescriptor typeDescriptor = this.typeDescriptorCache.get(cacheKey);
        if (typeDescriptor == null) {
            try {
                if (this.canRead(context, target, name) || this.canWrite(context, target, name)) {
                    typeDescriptor = this.typeDescriptorCache.get(cacheKey);
                }
            }
            catch (AccessException accessException) {
                // empty catch block
            }
        }
        return typeDescriptor;
    }

    private Method findGetterForProperty(String propertyName, Class<?> clazz2, Object target) {
        Method method = this.findGetterForProperty(propertyName, clazz2, target instanceof Class);
        if (method == null && target instanceof Class) {
            method = this.findGetterForProperty(propertyName, target.getClass(), false);
        }
        return method;
    }

    private Method findSetterForProperty(String propertyName, Class<?> clazz2, Object target) {
        Method method = this.findSetterForProperty(propertyName, clazz2, target instanceof Class);
        if (method == null && target instanceof Class) {
            method = this.findSetterForProperty(propertyName, target.getClass(), false);
        }
        return method;
    }

    protected Method findGetterForProperty(String propertyName, Class<?> clazz2, boolean mustBeStatic) {
        Method method = this.findMethodForProperty(this.getPropertyMethodSuffixes(propertyName), "get", clazz2, mustBeStatic, 0, ANY_TYPES);
        if (method == null) {
            method = this.findMethodForProperty(this.getPropertyMethodSuffixes(propertyName), "is", clazz2, mustBeStatic, 0, BOOLEAN_TYPES);
        }
        return method;
    }

    protected Method findSetterForProperty(String propertyName, Class<?> clazz2, boolean mustBeStatic) {
        return this.findMethodForProperty(this.getPropertyMethodSuffixes(propertyName), "set", clazz2, mustBeStatic, 1, ANY_TYPES);
    }

    private Method findMethodForProperty(String[] methodSuffixes, String prefix, Class<?> clazz2, boolean mustBeStatic, int numberOfParams, Set<Class<?>> requiredReturnTypes) {
        Method[] methods2 = this.getSortedMethods(clazz2);
        for (String methodSuffix : methodSuffixes) {
            for (Method method : methods2) {
                if (!this.isCandidateForProperty(method, clazz2) || !method.getName().equals(prefix + methodSuffix) || method.getParameterTypes().length != numberOfParams || mustBeStatic && !Modifier.isStatic(method.getModifiers()) || !requiredReturnTypes.isEmpty() && !requiredReturnTypes.contains(method.getReturnType())) continue;
                return method;
            }
        }
        return null;
    }

    protected boolean isCandidateForProperty(Method method, Class<?> targetClass) {
        return true;
    }

    private Method[] getSortedMethods(Class<?> clazz2) {
        Method[] methods2 = this.sortedMethodsCache.get(clazz2);
        if (methods2 == null) {
            methods2 = clazz2.getMethods();
            Arrays.sort(methods2, new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    return o1.isBridge() == o2.isBridge() ? 0 : (o1.isBridge() ? 1 : -1);
                }
            });
            this.sortedMethodsCache.put(clazz2, methods2);
        }
        return methods2;
    }

    protected String[] getPropertyMethodSuffixes(String propertyName) {
        String suffix = this.getPropertyMethodSuffix(propertyName);
        if (suffix.length() > 0 && Character.isUpperCase(suffix.charAt(0))) {
            return new String[]{suffix};
        }
        return new String[]{suffix, StringUtils.capitalize(suffix)};
    }

    protected String getPropertyMethodSuffix(String propertyName) {
        if (propertyName.length() > 1 && Character.isUpperCase(propertyName.charAt(1))) {
            return propertyName;
        }
        return StringUtils.capitalize(propertyName);
    }

    private Field findField(String name, Class<?> clazz2, Object target) {
        Field field2 = this.findField(name, clazz2, target instanceof Class);
        if (field2 == null && target instanceof Class) {
            field2 = this.findField(name, target.getClass(), false);
        }
        return field2;
    }

    protected Field findField(String name, Class<?> clazz2, boolean mustBeStatic) {
        Field field2;
        Field[] fields = clazz2.getFields();
        for (Field field3 : fields) {
            if (!field3.getName().equals(name) || mustBeStatic && !Modifier.isStatic(field3.getModifiers())) continue;
            return field3;
        }
        if (clazz2.getSuperclass() != null && (field2 = this.findField(name, clazz2.getSuperclass(), mustBeStatic)) != null) {
            return field2;
        }
        for (AnnotatedElement annotatedElement : clazz2.getInterfaces()) {
            Field field4 = this.findField(name, (Class<?>)annotatedElement, mustBeStatic);
            if (field4 == null) continue;
            return field4;
        }
        return null;
    }

    public PropertyAccessor createOptimalAccessor(EvaluationContext context, Object target, String name) {
        Class<?> clazz2;
        if (target == null) {
            return this;
        }
        Class<?> clazz3 = clazz2 = target instanceof Class ? (Class<?>)target : target.getClass();
        if (clazz2.isArray()) {
            return this;
        }
        PropertyCacheKey cacheKey = new PropertyCacheKey(clazz2, name, target instanceof Class);
        InvokerPair invocationTarget = this.readerCache.get(cacheKey);
        if (invocationTarget == null || invocationTarget.member instanceof Method) {
            Method method = (Method)(invocationTarget != null ? invocationTarget.member : null);
            if (method == null && (method = this.findGetterForProperty(name, clazz2, target)) != null) {
                invocationTarget = new InvokerPair(method, new TypeDescriptor(new MethodParameter(method, -1)));
                ReflectionUtils.makeAccessible(method);
                this.readerCache.put(cacheKey, invocationTarget);
            }
            if (method != null) {
                return new OptimalPropertyAccessor(invocationTarget);
            }
        }
        if (invocationTarget == null || invocationTarget.member instanceof Field) {
            Field field2;
            Field field3 = field2 = invocationTarget != null ? (Field)invocationTarget.member : null;
            if (field2 == null && (field2 = this.findField(name, clazz2, target instanceof Class)) != null) {
                invocationTarget = new InvokerPair(field2, new TypeDescriptor(field2));
                ReflectionUtils.makeAccessible(field2);
                this.readerCache.put(cacheKey, invocationTarget);
            }
            if (field2 != null) {
                return new OptimalPropertyAccessor(invocationTarget);
            }
        }
        return this;
    }

    static {
        HashSet<Class<Boolean>> booleanTypes = new HashSet<Class<Boolean>>(4);
        booleanTypes.add(Boolean.class);
        booleanTypes.add(Boolean.TYPE);
        BOOLEAN_TYPES = Collections.unmodifiableSet(booleanTypes);
    }

    public static class OptimalPropertyAccessor
    implements CompilablePropertyAccessor {
        public final Member member;
        private final TypeDescriptor typeDescriptor;
        private final boolean needsToBeMadeAccessible;

        OptimalPropertyAccessor(InvokerPair target) {
            this.member = target.member;
            this.typeDescriptor = target.typeDescriptor;
            this.needsToBeMadeAccessible = !Modifier.isPublic(this.member.getModifiers()) || !Modifier.isPublic(this.member.getDeclaringClass().getModifiers());
        }

        @Override
        public Class<?>[] getSpecificTargetClasses() {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        @Override
        public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
            Class<?> type;
            if (target == null) {
                return false;
            }
            Class<?> clazz2 = type = target instanceof Class ? (Class<?>)target : target.getClass();
            if (type.isArray()) {
                return false;
            }
            if (this.member instanceof Method) {
                Method method = (Method)this.member;
                String getterName = "get" + StringUtils.capitalize(name);
                if (getterName.equals(method.getName())) {
                    return true;
                }
                getterName = "is" + StringUtils.capitalize(name);
                return getterName.equals(method.getName());
            }
            Field field2 = (Field)this.member;
            return field2.getName().equals(name);
        }

        @Override
        public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
            if (this.member instanceof Method) {
                Method method = (Method)this.member;
                try {
                    if (this.needsToBeMadeAccessible && !method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    Object value2 = method.invoke(target, new Object[0]);
                    return new TypedValue(value2, this.typeDescriptor.narrow(value2));
                }
                catch (Exception ex) {
                    throw new AccessException("Unable to access property '" + name + "' through getter method", ex);
                }
            }
            Field field2 = (Field)this.member;
            try {
                if (this.needsToBeMadeAccessible && !field2.isAccessible()) {
                    field2.setAccessible(true);
                }
                Object value3 = field2.get(target);
                return new TypedValue(value3, this.typeDescriptor.narrow(value3));
            }
            catch (Exception ex) {
                throw new AccessException("Unable to access field '" + name + "'", ex);
            }
        }

        @Override
        public boolean canWrite(EvaluationContext context, Object target, String name) {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        @Override
        public void write(EvaluationContext context, Object target, String name, Object newValue) {
            throw new UnsupportedOperationException("Should not be called on an OptimalPropertyAccessor");
        }

        @Override
        public boolean isCompilable() {
            return Modifier.isPublic(this.member.getModifiers()) && Modifier.isPublic(this.member.getDeclaringClass().getModifiers());
        }

        @Override
        public Class<?> getPropertyType() {
            if (this.member instanceof Method) {
                return ((Method)this.member).getReturnType();
            }
            return ((Field)this.member).getType();
        }

        @Override
        public void generateCode(String propertyName, MethodVisitor mv, CodeFlow cf) {
            boolean isStatic = Modifier.isStatic(this.member.getModifiers());
            String descriptor = cf.lastDescriptor();
            String classDesc = this.member.getDeclaringClass().getName().replace('.', '/');
            if (!isStatic) {
                if (descriptor == null) {
                    cf.loadTarget(mv);
                }
                if (descriptor == null || !classDesc.equals(descriptor.substring(1))) {
                    mv.visitTypeInsn(192, classDesc);
                }
            } else if (descriptor != null) {
                mv.visitInsn(87);
            }
            if (this.member instanceof Method) {
                mv.visitMethodInsn(isStatic ? 184 : 182, classDesc, this.member.getName(), CodeFlow.createSignatureDescriptor((Method)this.member), false);
            } else {
                mv.visitFieldInsn(isStatic ? 178 : 180, classDesc, this.member.getName(), CodeFlow.toJvmDescriptor(((Field)this.member).getType()));
            }
        }
    }

    private static final class PropertyCacheKey
    implements Comparable<PropertyCacheKey> {
        private final Class<?> clazz;
        private final String property;
        private boolean targetIsClass;

        public PropertyCacheKey(Class<?> clazz2, String name, boolean targetIsClass) {
            this.clazz = clazz2;
            this.property = name;
            this.targetIsClass = targetIsClass;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PropertyCacheKey)) {
                return false;
            }
            PropertyCacheKey otherKey = (PropertyCacheKey)other;
            return this.clazz == otherKey.clazz && this.property.equals(otherKey.property) && this.targetIsClass == otherKey.targetIsClass;
        }

        public int hashCode() {
            return this.clazz.hashCode() * 29 + this.property.hashCode();
        }

        public String toString() {
            return "CacheKey [clazz=" + this.clazz.getName() + ", property=" + this.property + ", " + this.property + ", targetIsClass=" + this.targetIsClass + "]";
        }

        @Override
        public int compareTo(PropertyCacheKey other) {
            int result2 = this.clazz.getName().compareTo(other.clazz.getName());
            if (result2 == 0) {
                result2 = this.property.compareTo(other.property);
            }
            return result2;
        }
    }

    private static class InvokerPair {
        final Member member;
        final TypeDescriptor typeDescriptor;

        public InvokerPair(Member member, TypeDescriptor typeDescriptor) {
            this.member = member;
            this.typeDescriptor = typeDescriptor;
        }
    }
}

