/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.expression.spel.support.ReflectiveMethodExecutor;

public class ReflectiveMethodResolver
implements MethodResolver {
    private final boolean useDistance;
    private Map<Class<?>, MethodFilter> filters;

    public ReflectiveMethodResolver() {
        this.useDistance = true;
    }

    public ReflectiveMethodResolver(boolean useDistance) {
        this.useDistance = useDistance;
    }

    public void registerMethodFilter(Class<?> type, MethodFilter filter2) {
        if (this.filters == null) {
            this.filters = new HashMap();
        }
        if (filter2 != null) {
            this.filters.put(type, filter2);
        } else {
            this.filters.remove(type);
        }
    }

    @Override
    public MethodExecutor resolve(EvaluationContext context, Object targetObject, String name, List<TypeDescriptor> argumentTypes) throws AccessException {
        try {
            MethodFilter filter2;
            TypeConverter typeConverter = context.getTypeConverter();
            Class<?> type = targetObject instanceof Class ? (Class<?>)targetObject : targetObject.getClass();
            ArrayList<Method> methods2 = new ArrayList<Method>(this.getMethods(type, targetObject));
            MethodFilter methodFilter = filter2 = this.filters != null ? this.filters.get(type) : null;
            if (filter2 != null) {
                ArrayList<Method> filtered2 = filter2.filter(methods2);
                ArrayList<Method> arrayList = methods2 = filtered2 instanceof ArrayList ? filtered2 : new ArrayList<Method>(filtered2);
            }
            if (methods2.size() > 1) {
                Collections.sort(methods2, new Comparator<Method>(){

                    @Override
                    public int compare(Method m1, Method m2) {
                        int m2pl;
                        int m1pl = m1.getParameterTypes().length;
                        if (m1pl == (m2pl = m2.getParameterTypes().length)) {
                            if (!m1.isVarArgs() && m2.isVarArgs()) {
                                return -1;
                            }
                            if (m1.isVarArgs() && !m2.isVarArgs()) {
                                return 1;
                            }
                            return 0;
                        }
                        return m1pl < m2pl ? -1 : (m1pl > m2pl ? 1 : 0);
                    }
                });
            }
            for (int i = 0; i < methods2.size(); ++i) {
                methods2.set(i, BridgeMethodResolver.findBridgedMethod((Method)methods2.get(i)));
            }
            LinkedHashSet methodsToIterate = new LinkedHashSet(methods2);
            Method closeMatch = null;
            int closeMatchDistance = Integer.MAX_VALUE;
            Method matchRequiringConversion = null;
            boolean multipleOptions = false;
            for (Method method : methodsToIterate) {
                if (!method.getName().equals(name)) continue;
                Class<?>[] paramTypes2 = method.getParameterTypes();
                ArrayList<TypeDescriptor> paramDescriptors = new ArrayList<TypeDescriptor>(paramTypes2.length);
                for (int i = 0; i < paramTypes2.length; ++i) {
                    paramDescriptors.add(new TypeDescriptor(new MethodParameter(method, i)));
                }
                ReflectionHelper.ArgumentsMatchInfo matchInfo = null;
                if (method.isVarArgs() && argumentTypes.size() >= paramTypes2.length - 1) {
                    matchInfo = ReflectionHelper.compareArgumentsVarargs(paramDescriptors, argumentTypes, typeConverter);
                } else if (paramTypes2.length == argumentTypes.size()) {
                    matchInfo = ReflectionHelper.compareArguments(paramDescriptors, argumentTypes, typeConverter);
                }
                if (matchInfo == null) continue;
                if (matchInfo.isExactMatch()) {
                    return new ReflectiveMethodExecutor(method);
                }
                if (matchInfo.isCloseMatch()) {
                    if (this.useDistance) {
                        int matchDistance = ReflectionHelper.getTypeDifferenceWeight(paramDescriptors, argumentTypes);
                        if (closeMatch != null && matchDistance >= closeMatchDistance) continue;
                        closeMatch = method;
                        closeMatchDistance = matchDistance;
                        continue;
                    }
                    if (closeMatch != null) continue;
                    closeMatch = method;
                    continue;
                }
                if (!matchInfo.isMatchRequiringConversion()) continue;
                if (matchRequiringConversion != null) {
                    multipleOptions = true;
                }
                matchRequiringConversion = method;
            }
            if (closeMatch != null) {
                return new ReflectiveMethodExecutor(closeMatch);
            }
            if (matchRequiringConversion != null) {
                if (multipleOptions) {
                    throw new SpelEvaluationException(SpelMessage.MULTIPLE_POSSIBLE_METHODS, name);
                }
                return new ReflectiveMethodExecutor(matchRequiringConversion);
            }
            return null;
        }
        catch (EvaluationException ex) {
            throw new AccessException("Failed to resolve method", ex);
        }
    }

    private Set<Method> getMethods(Class<?> type, Object targetObject) {
        Method[] methods2;
        if (targetObject instanceof Class) {
            Method[] methods3;
            LinkedHashSet<Method> result2 = new LinkedHashSet<Method>();
            for (Method method : methods3 = this.getMethods(type)) {
                if (!Modifier.isStatic(method.getModifiers())) continue;
                result2.add(method);
            }
            result2.addAll(Arrays.asList(this.getMethods(Class.class)));
            return result2;
        }
        if (Proxy.isProxyClass(type)) {
            LinkedHashSet<Method> result3 = new LinkedHashSet<Method>();
            for (Class<?> ifc : type.getInterfaces()) {
                Method[] methods4;
                for (Method method : methods4 = this.getMethods(ifc)) {
                    if (!this.isCandidateForInvocation(method, type)) continue;
                    result3.add(method);
                }
            }
            return result3;
        }
        LinkedHashSet<Method> result4 = new LinkedHashSet<Method>();
        for (Method method : methods2 = this.getMethods(type)) {
            if (!this.isCandidateForInvocation(method, type)) continue;
            result4.add(method);
        }
        return result4;
    }

    protected Method[] getMethods(Class<?> type) {
        return type.getMethods();
    }

    protected boolean isCandidateForInvocation(Method method, Class<?> targetClass) {
        return true;
    }
}

