/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.util.ReflectionUtils;

public class ReflectiveMethodExecutor
implements MethodExecutor {
    private final Method method;
    private final Integer varargsPosition;
    private boolean computedPublicDeclaringClass = false;
    private Class<?> publicDeclaringClass;
    private boolean argumentConversionOccurred = false;

    public ReflectiveMethodExecutor(Method method) {
        this.method = method;
        if (method.isVarArgs()) {
            Class<?>[] paramTypes2 = method.getParameterTypes();
            this.varargsPosition = paramTypes2.length - 1;
        } else {
            this.varargsPosition = null;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getPublicDeclaringClass() {
        if (!this.computedPublicDeclaringClass) {
            this.publicDeclaringClass = this.discoverPublicClass(this.method, this.method.getDeclaringClass());
            this.computedPublicDeclaringClass = true;
        }
        return this.publicDeclaringClass;
    }

    private Class<?> discoverPublicClass(Method method, Class<?> clazz2) {
        Class<?>[] ifcs;
        if (Modifier.isPublic(clazz2.getModifiers())) {
            try {
                clazz2.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return clazz2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        for (Class<?> ifc : ifcs = clazz2.getInterfaces()) {
            this.discoverPublicClass(method, ifc);
        }
        if (clazz2.getSuperclass() != null) {
            return this.discoverPublicClass(method, clazz2.getSuperclass());
        }
        return null;
    }

    public boolean didArgumentConversionOccur() {
        return this.argumentConversionOccurred;
    }

    @Override
    public TypedValue execute(EvaluationContext context, Object target, Object ... arguments) throws AccessException {
        try {
            if (arguments != null) {
                this.argumentConversionOccurred = ReflectionHelper.convertArguments(context.getTypeConverter(), arguments, this.method, this.varargsPosition);
                if (this.method.isVarArgs()) {
                    arguments = ReflectionHelper.setupArgumentsForVarargsInvocation(this.method.getParameterTypes(), arguments);
                }
            }
            ReflectionUtils.makeAccessible(this.method);
            Object value2 = this.method.invoke(target, arguments);
            return new TypedValue(value2, new TypeDescriptor(new MethodParameter(this.method, -1)).narrow(value2));
        }
        catch (Exception ex) {
            throw new AccessException("Problem invoking method: " + this.method, ex);
        }
    }
}

