/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class Projection
extends SpelNodeImpl {
    private final boolean nullSafe;

    public Projection(boolean nullSafe2, int pos, SpelNodeImpl expression) {
        super(pos, expression);
        this.nullSafe = nullSafe2;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        return this.getValueRef(state).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        TypedValue op = state.getActiveContextObject();
        Object operand = op.getValue();
        boolean operandIsArray = ObjectUtils.isArray(operand);
        if (operand instanceof Map) {
            Map mapData = (Map)operand;
            ArrayList<Object> result2 = new ArrayList<Object>();
            for (Map.Entry entry2 : mapData.entrySet()) {
                try {
                    state.pushActiveContextObject(new TypedValue(entry2));
                    state.enterScope();
                    result2.add(this.children[0].getValueInternal(state).getValue());
                }
                finally {
                    state.popActiveContextObject();
                    state.exitScope();
                }
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(result2), this);
        }
        if (operand instanceof Iterable || operandIsArray) {
            List<Object> data = operand instanceof Iterable ? (List<Object>)operand : Arrays.asList(ObjectUtils.toObjectArray(operand));
            ArrayList<Object> result3 = new ArrayList<Object>();
            int idx = 0;
            Class arrayElementType = null;
            for (Object t : data) {
                try {
                    state.pushActiveContextObject(new TypedValue(t));
                    state.enterScope("index", idx);
                    Object value2 = this.children[0].getValueInternal(state).getValue();
                    if (value2 != null && operandIsArray) {
                        arrayElementType = this.determineCommonType(arrayElementType, value2.getClass());
                    }
                    result3.add(value2);
                }
                finally {
                    state.exitScope();
                    state.popActiveContextObject();
                }
                ++idx;
            }
            if (operandIsArray) {
                if (arrayElementType == null) {
                    arrayElementType = Object.class;
                }
                Object resultArray = Array.newInstance(arrayElementType, result3.size());
                System.arraycopy(result3.toArray(), 0, resultArray, 0, result3.size());
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(resultArray), this);
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(result3), this);
        }
        if (operand == null) {
            if (this.nullSafe) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, "null");
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.PROJECTION_NOT_SUPPORTED_ON_TYPE, operand.getClass().getName());
    }

    @Override
    public String toStringAST() {
        return "![" + this.getChild(0).toStringAST() + "]";
    }

    private Class<?> determineCommonType(Class<?> oldType, Class<?> newType) {
        if (oldType == null) {
            return newType;
        }
        if (oldType.isAssignableFrom(newType)) {
            return oldType;
        }
        for (Class<?> nextType = newType; nextType != Object.class; nextType = nextType.getSuperclass()) {
            if (!nextType.isAssignableFrom(oldType)) continue;
            return nextType;
        }
        for (Class<?> nextInterface : ClassUtils.getAllInterfacesForClassAsSet(newType)) {
            if (!nextInterface.isAssignableFrom(oldType)) continue;
            return nextInterface;
        }
        return Object.class;
    }
}

