/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ejb.interceptor;

import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJBException;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.interceptor.InvocationContext;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;

public class SpringBeanAutowiringInterceptor {
    private final Map<Object, BeanFactoryReference> beanFactoryReferences = new WeakHashMap<Object, BeanFactoryReference>();

    @PostConstruct
    @PostActivate
    public void autowireBean(InvocationContext invocationContext) {
        this.doAutowireBean(invocationContext.getTarget());
        try {
            invocationContext.proceed();
        }
        catch (RuntimeException ex) {
            this.doReleaseBean(invocationContext.getTarget());
            throw ex;
        }
        catch (Error err2) {
            this.doReleaseBean(invocationContext.getTarget());
            throw err2;
        }
        catch (Exception ex) {
            this.doReleaseBean(invocationContext.getTarget());
            throw new EJBException(ex);
        }
    }

    protected void doAutowireBean(Object target) {
        AutowiredAnnotationBeanPostProcessor bpp = new AutowiredAnnotationBeanPostProcessor();
        this.configureBeanPostProcessor(bpp, target);
        bpp.setBeanFactory(this.getBeanFactory(target));
        bpp.processInjection(target);
    }

    protected void configureBeanPostProcessor(AutowiredAnnotationBeanPostProcessor processor, Object target) {
    }

    protected BeanFactory getBeanFactory(Object target) {
        BeanFactory factory = this.getBeanFactoryReference(target).getFactory();
        if (factory instanceof ApplicationContext) {
            factory = ((ApplicationContext)factory).getAutowireCapableBeanFactory();
        }
        return factory;
    }

    protected BeanFactoryReference getBeanFactoryReference(Object target) {
        String key = this.getBeanFactoryLocatorKey(target);
        BeanFactoryReference ref2 = this.getBeanFactoryLocator(target).useBeanFactory(key);
        this.beanFactoryReferences.put(target, ref2);
        return ref2;
    }

    protected BeanFactoryLocator getBeanFactoryLocator(Object target) {
        return ContextSingletonBeanFactoryLocator.getInstance();
    }

    protected String getBeanFactoryLocatorKey(Object target) {
        return null;
    }

    @PreDestroy
    @PrePassivate
    public void releaseBean(InvocationContext invocationContext) {
        this.doReleaseBean(invocationContext.getTarget());
        try {
            invocationContext.proceed();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new EJBException(ex);
        }
    }

    protected void doReleaseBean(Object target) {
        BeanFactoryReference ref2 = this.beanFactoryReferences.remove(target);
        if (ref2 != null) {
            ref2.release();
        }
    }
}

