/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Attribute;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.FieldVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.type.ClassMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class ClassMetadataReadingVisitor
extends ClassVisitor
implements ClassMetadata {
    private String className;
    private boolean isInterface;
    private boolean isAnnotation;
    private boolean isAbstract;
    private boolean isFinal;
    private String enclosingClassName;
    private boolean independentInnerClass;
    private String superClassName;
    private String[] interfaces;
    private Set<String> memberClassNames = new LinkedHashSet<String>(4);

    public ClassMetadataReadingVisitor() {
        super(393216);
    }

    @Override
    public void visit(int version, int access2, String name, String signature2, String supername, String[] interfaces2) {
        this.className = ClassUtils.convertResourcePathToClassName(name);
        this.isInterface = (access2 & 0x200) != 0;
        this.isAnnotation = (access2 & 0x2000) != 0;
        this.isAbstract = (access2 & 0x400) != 0;
        boolean bl = this.isFinal = (access2 & 0x10) != 0;
        if (supername != null && !this.isInterface) {
            this.superClassName = ClassUtils.convertResourcePathToClassName(supername);
        }
        this.interfaces = new String[interfaces2.length];
        for (int i = 0; i < interfaces2.length; ++i) {
            this.interfaces[i] = ClassUtils.convertResourcePathToClassName(interfaces2[i]);
        }
    }

    @Override
    public void visitOuterClass(String owner2, String name, String desc) {
        this.enclosingClassName = ClassUtils.convertResourcePathToClassName(owner2);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName2, int access2) {
        if (outerName != null) {
            String fqName = ClassUtils.convertResourcePathToClassName(name);
            String fqOuterName = ClassUtils.convertResourcePathToClassName(outerName);
            if (this.className.equals(fqName)) {
                this.enclosingClassName = fqOuterName;
                this.independentInnerClass = (access2 & 8) != 0;
            } else if (this.className.equals(fqOuterName)) {
                this.memberClassNames.add(fqName);
            }
        }
    }

    @Override
    public void visitSource(String source, String debug) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new EmptyAnnotationVisitor();
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public FieldVisitor visitField(int access2, String name, String desc, String signature2, Object value2) {
        return new EmptyFieldVisitor();
    }

    @Override
    public MethodVisitor visitMethod(int access2, String name, String desc, String signature2, String[] exceptions2) {
        return new EmptyMethodVisitor();
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isConcrete() {
        return !this.isInterface && !this.isAbstract;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isIndependent() {
        return this.enclosingClassName == null || this.independentInnerClass;
    }

    @Override
    public boolean hasEnclosingClass() {
        return this.enclosingClassName != null;
    }

    @Override
    public String getEnclosingClassName() {
        return this.enclosingClassName;
    }

    @Override
    public boolean hasSuperClass() {
        return this.superClassName != null;
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public String[] getInterfaceNames() {
        return this.interfaces;
    }

    @Override
    public String[] getMemberClassNames() {
        return StringUtils.toStringArray(this.memberClassNames);
    }

    private static class EmptyFieldVisitor
    extends FieldVisitor {
        public EmptyFieldVisitor() {
            super(393216);
        }
    }

    private static class EmptyMethodVisitor
    extends MethodVisitor {
        public EmptyMethodVisitor() {
            super(393216);
        }
    }

    private static class EmptyAnnotationVisitor
    extends AnnotationVisitor {
        public EmptyAnnotationVisitor() {
            super(393216);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return this;
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return this;
        }
    }
}

