/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClassRelativeResourceLoader
extends DefaultResourceLoader {
    private final Class<?> clazz;

    public ClassRelativeResourceLoader(Class<?> clazz2) {
        Assert.notNull(clazz2, "Class must not be null");
        this.clazz = clazz2;
        this.setClassLoader(clazz2.getClassLoader());
    }

    @Override
    protected Resource getResourceByPath(String path2) {
        return new ClassRelativeContextResource(path2, this.clazz);
    }

    private static class ClassRelativeContextResource
    extends ClassPathResource
    implements ContextResource {
        private final Class<?> clazz;

        public ClassRelativeContextResource(String path2, Class<?> clazz2) {
            super(path2, clazz2);
            this.clazz = clazz2;
        }

        @Override
        public String getPathWithinContext() {
            return this.getPath();
        }

        @Override
        public Resource createRelative(String relativePath) {
            String pathToUse = StringUtils.applyRelativePath(this.getPath(), relativePath);
            return new ClassRelativeContextResource(pathToUse, this.clazz);
        }
    }
}

