/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.springframework.core.convert.ConversionException;
import org.springframework.core.env.AbstractPropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.util.ClassUtils;

public class PropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    private final PropertySources propertySources;

    public PropertySourcesPropertyResolver(PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    @Override
    public boolean containsProperty(String key) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                if (!propertySource.containsProperty(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, String.class, true);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetValueType) {
        return this.getProperty(key, targetValueType, true);
    }

    @Override
    protected String getPropertyAsRawString(String key) {
        return this.getProperty(key, String.class, false);
    }

    protected <T> T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                Object value2;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Searching for key '" + key + "' in PropertySource '" + propertySource.getName() + "'");
                }
                if ((value2 = propertySource.getProperty(key)) == null) continue;
                if (resolveNestedPlaceholders && value2 instanceof String) {
                    value2 = this.resolveNestedPlaceholders((String)value2);
                }
                this.logKeyFound(key, propertySource, value2);
                return this.convertValueIfNecessary(value2, targetValueType);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Could not find key '" + key + "' in any property source");
        }
        return null;
    }

    @Override
    @Deprecated
    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetValueType) {
        if (this.propertySources != null) {
            for (PropertySource propertySource : this.propertySources) {
                Class<?> clazz2;
                Object value2;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace(String.format("Searching for key '%s' in [%s]", key, propertySource.getName()));
                }
                if ((value2 = propertySource.getProperty(key)) == null) continue;
                this.logKeyFound(key, propertySource, value2);
                if (value2 instanceof String) {
                    try {
                        clazz2 = ClassUtils.forName((String)value2, null);
                    }
                    catch (Exception ex) {
                        throw new ClassConversionException((String)value2, targetValueType, ex);
                    }
                } else {
                    clazz2 = value2 instanceof Class ? (Class<?>)value2 : value2.getClass();
                }
                if (!targetValueType.isAssignableFrom(clazz2)) {
                    throw new ClassConversionException(clazz2, targetValueType);
                }
                Class<?> targetClass = clazz2;
                return targetClass;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Could not find key '%s' in any property source", key));
        }
        return null;
    }

    protected void logKeyFound(String key, PropertySource<?> propertySource, Object value2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Found key '" + key + "' in PropertySource '" + propertySource.getName() + "' with value of type " + value2.getClass().getSimpleName());
        }
    }

    @Deprecated
    private static class ClassConversionException
    extends ConversionException {
        public ClassConversionException(Class<?> actual, Class<?> expected) {
            super(String.format("Actual type %s is not assignable to expected type %s", actual.getName(), expected.getName()));
        }

        public ClassConversionException(String actual, Class<?> expected, Exception ex) {
            super(String.format("Could not find/load class %s during attempt to convert to %s", actual, expected.getName()), ex);
        }
    }
}

