/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert;

import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.ObjectUtils;

public class ConversionFailedException
extends ConversionException {
    private final TypeDescriptor sourceType;
    private final TypeDescriptor targetType;
    private final Object value;

    public ConversionFailedException(TypeDescriptor sourceType, TypeDescriptor targetType, Object value2, Throwable cause) {
        super("Failed to convert from type [" + sourceType + "] to type [" + targetType + "] for value '" + ObjectUtils.nullSafeToString(value2) + "'", cause);
        this.sourceType = sourceType;
        this.targetType = targetType;
        this.value = value2;
    }

    public TypeDescriptor getSourceType() {
        return this.sourceType;
    }

    public TypeDescriptor getTargetType() {
        return this.targetType;
    }

    public Object getValue() {
        return this.value;
    }
}

