/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AnnotationAttributes
extends LinkedHashMap<String, Object> {
    private static final String UNKNOWN = "unknown";
    private final Class<? extends Annotation> annotationType;
    private final String displayName;
    boolean validated = false;

    public AnnotationAttributes() {
        this.annotationType = null;
        this.displayName = UNKNOWN;
    }

    public AnnotationAttributes(int initialCapacity) {
        super(initialCapacity);
        this.annotationType = null;
        this.displayName = UNKNOWN;
    }

    public AnnotationAttributes(Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, "'annotationType' must not be null");
        this.annotationType = annotationType;
        this.displayName = annotationType.getName();
    }

    public AnnotationAttributes(String annotationType, ClassLoader classLoader) {
        Assert.notNull(annotationType, "'annotationType' must not be null");
        this.annotationType = AnnotationAttributes.getAnnotationType(annotationType, classLoader);
        this.displayName = annotationType;
    }

    private static Class<? extends Annotation> getAnnotationType(String annotationType, ClassLoader classLoader) {
        if (classLoader != null) {
            try {
                return classLoader.loadClass(annotationType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public AnnotationAttributes(Map<String, Object> map2) {
        super(map2);
        this.annotationType = null;
        this.displayName = UNKNOWN;
    }

    public AnnotationAttributes(AnnotationAttributes other) {
        super(other);
        this.annotationType = other.annotationType;
        this.displayName = other.displayName;
        this.validated = other.validated;
    }

    public Class<? extends Annotation> annotationType() {
        return this.annotationType;
    }

    public String getString(String attributeName) {
        return this.getRequiredAttribute(attributeName, String.class);
    }

    @Deprecated
    public String getAliasedString(String attributeName, Class<? extends Annotation> annotationType, Object annotationSource) {
        return this.getRequiredAttributeWithAlias(attributeName, annotationType, annotationSource, String.class);
    }

    public String[] getStringArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, String[].class);
    }

    @Deprecated
    public String[] getAliasedStringArray(String attributeName, Class<? extends Annotation> annotationType, Object annotationSource) {
        return this.getRequiredAttributeWithAlias(attributeName, annotationType, annotationSource, String[].class);
    }

    public boolean getBoolean(String attributeName) {
        return this.getRequiredAttribute(attributeName, Boolean.class);
    }

    public <N extends Number> N getNumber(String attributeName) {
        return (N)this.getRequiredAttribute(attributeName, Number.class);
    }

    public <E extends Enum<?>> E getEnum(String attributeName) {
        return (E)this.getRequiredAttribute(attributeName, Enum.class);
    }

    public <T> Class<? extends T> getClass(String attributeName) {
        return this.getRequiredAttribute(attributeName, Class.class);
    }

    public Class<?>[] getClassArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, Class[].class);
    }

    @Deprecated
    public Class<?>[] getAliasedClassArray(String attributeName, Class<? extends Annotation> annotationType, Object annotationSource) {
        return this.getRequiredAttributeWithAlias(attributeName, annotationType, annotationSource, Class[].class);
    }

    public AnnotationAttributes getAnnotation(String attributeName) {
        return this.getRequiredAttribute(attributeName, AnnotationAttributes.class);
    }

    public <A extends Annotation> A getAnnotation(String attributeName, Class<A> annotationType) {
        return (A)((Annotation)this.getRequiredAttribute(attributeName, annotationType));
    }

    public AnnotationAttributes[] getAnnotationArray(String attributeName) {
        return this.getRequiredAttribute(attributeName, AnnotationAttributes[].class);
    }

    public <A extends Annotation> A[] getAnnotationArray(String attributeName, Class<A> annotationType) {
        Object array = Array.newInstance(annotationType, 0);
        return (Annotation[])this.getRequiredAttribute(attributeName, array.getClass());
    }

    private <T> T getRequiredAttribute(String attributeName, Class<T> expectedType) {
        Assert.hasText(attributeName, "'attributeName' must not be null or empty");
        Object value2 = this.get(attributeName);
        this.assertAttributePresence(attributeName, value2);
        this.assertNotException(attributeName, value2);
        if (!expectedType.isInstance(value2) && expectedType.isArray() && expectedType.getComponentType().isInstance(value2)) {
            Object array = Array.newInstance(expectedType.getComponentType(), 1);
            Array.set(array, 0, value2);
            value2 = array;
        }
        this.assertAttributeType(attributeName, value2, expectedType);
        return (T)value2;
    }

    private <T> T getRequiredAttributeWithAlias(String attributeName, Class<? extends Annotation> annotationType, Object annotationSource, Class<T> expectedType) {
        Assert.hasText(attributeName, "'attributeName' must not be null or empty");
        Assert.notNull(annotationType, "'annotationType' must not be null");
        Assert.notNull(expectedType, "'expectedType' must not be null");
        T attributeValue = this.getAttribute(attributeName, expectedType);
        List<String> aliasNames2 = AnnotationUtils.getAttributeAliasMap(annotationType).get(attributeName);
        if (aliasNames2 != null) {
            for (String aliasName : aliasNames2) {
                T aliasValue = this.getAttribute(aliasName, expectedType);
                boolean attributeEmpty = ObjectUtils.isEmpty(attributeValue);
                boolean aliasEmpty = ObjectUtils.isEmpty(aliasValue);
                if (!(attributeEmpty || aliasEmpty || ObjectUtils.nullSafeEquals(attributeValue, aliasValue))) {
                    String elementName = annotationSource == null ? "unknown element" : annotationSource.toString();
                    String msg = String.format("In annotation [%s] declared on [%s], attribute [%s] and its alias [%s] are present with values of [%s] and [%s], but only one is permitted.", annotationType.getName(), elementName, attributeName, aliasName, ObjectUtils.nullSafeToString(attributeValue), ObjectUtils.nullSafeToString(aliasValue));
                    throw new AnnotationConfigurationException(msg);
                }
                if (expectedType.isArray() && attributeValue == null && aliasValue != null) {
                    attributeValue = aliasValue;
                    continue;
                }
                if (!attributeEmpty || aliasEmpty) continue;
                attributeValue = aliasValue;
            }
            this.assertAttributePresence(attributeName, aliasNames2, attributeValue);
        }
        return attributeValue;
    }

    private <T> T getAttribute(String attributeName, Class<T> expectedType) {
        Object value2 = this.get(attributeName);
        if (value2 != null) {
            this.assertNotException(attributeName, value2);
            this.assertAttributeType(attributeName, value2, expectedType);
        }
        return (T)value2;
    }

    private void assertAttributePresence(String attributeName, Object attributeValue) {
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Attribute '%s' not found in attributes for annotation [%s]", attributeName, this.displayName));
        }
    }

    private void assertAttributePresence(String attributeName, List<String> aliases2, Object attributeValue) {
        if (attributeValue == null) {
            throw new IllegalArgumentException(String.format("Neither attribute '%s' nor one of its aliases %s was found in attributes for annotation [%s]", attributeName, aliases2, this.displayName));
        }
    }

    private void assertNotException(String attributeName, Object attributeValue) {
        if (attributeValue instanceof Exception) {
            throw new IllegalArgumentException(String.format("Attribute '%s' for annotation [%s] was not resolvable due to exception [%s]", attributeName, this.displayName, attributeValue), (Exception)attributeValue);
        }
    }

    private void assertAttributeType(String attributeName, Object attributeValue, Class<?> expectedType) {
        if (!expectedType.isInstance(attributeValue)) {
            throw new IllegalArgumentException(String.format("Attribute '%s' is of type [%s], but [%s] was expected in attributes for annotation [%s]", attributeName, attributeValue.getClass().getSimpleName(), expectedType.getSimpleName(), this.displayName));
        }
    }

    @Override
    public Object putIfAbsent(String key, Object value2) {
        Object obj = this.get(key);
        if (obj == null) {
            obj = this.put(key, value2);
        }
        return obj;
    }

    @Override
    public String toString() {
        Iterator entries = this.entrySet().iterator();
        StringBuilder sb = new StringBuilder("{");
        while (entries.hasNext()) {
            Map.Entry entry2 = entries.next();
            sb.append((String)entry2.getKey());
            sb.append('=');
            sb.append(this.valueToString(entry2.getValue()));
            sb.append(entries.hasNext() ? ", " : "");
        }
        sb.append("}");
        return sb.toString();
    }

    private String valueToString(Object value2) {
        if (value2 == this) {
            return "(this Map)";
        }
        if (value2 instanceof Object[]) {
            return "[" + StringUtils.arrayToDelimitedString((Object[])value2, ", ") + "]";
        }
        return String.valueOf(value2);
    }

    public static AnnotationAttributes fromMap(Map<String, Object> map2) {
        if (map2 == null) {
            return null;
        }
        if (map2 instanceof AnnotationAttributes) {
            return (AnnotationAttributes)map2;
        }
        return new AnnotationAttributes(map2);
    }
}

