/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class AnnotatedElementUtils {
    private static final Boolean CONTINUE = null;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Processor<Boolean> alwaysTrueAnnotationProcessor = new AlwaysTrueBooleanAnnotationProcessor();

    public static AnnotatedElement forAnnotations(final Annotation ... annotations2) {
        return new AnnotatedElement(){

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                for (Annotation ann : annotations2) {
                    if (ann.annotationType() != annotationClass) continue;
                    return (T)ann;
                }
                return null;
            }

            @Override
            public Annotation[] getAnnotations() {
                return annotations2;
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return annotations2;
            }
        };
    }

    public static Set<String> getMetaAnnotationTypes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "'annotationType' must not be null");
        return AnnotatedElementUtils.getMetaAnnotationTypes(element, element.getAnnotation(annotationType));
    }

    public static Set<String> getMetaAnnotationTypes(AnnotatedElement element, String annotationName) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasLength(annotationName, "'annotationName' must not be null or empty");
        return AnnotatedElementUtils.getMetaAnnotationTypes(element, AnnotationUtils.getAnnotation(element, annotationName));
    }

    private static Set<String> getMetaAnnotationTypes(AnnotatedElement element, Annotation composed) {
        if (composed == null) {
            return null;
        }
        try {
            final LinkedHashSet<String> types2 = new LinkedHashSet<String>();
            AnnotatedElementUtils.searchWithGetSemantics(composed.annotationType(), null, null, null, new SimpleAnnotationProcessor<Object>(true){

                @Override
                public Object process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                    types2.add(annotation.annotationType().getName());
                    return CONTINUE;
                }
            }, new HashSet<AnnotatedElement>(), 1);
            return !types2.isEmpty() ? types2 : null;
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            throw new IllegalStateException("Failed to introspect annotations on " + element, ex);
        }
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "'annotationType' must not be null");
        return AnnotatedElementUtils.hasMetaAnnotationTypes(element, annotationType, null);
    }

    public static boolean hasMetaAnnotationTypes(AnnotatedElement element, String annotationName) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasLength(annotationName, "'annotationName' must not be null or empty");
        return AnnotatedElementUtils.hasMetaAnnotationTypes(element, null, annotationName);
    }

    private static boolean hasMetaAnnotationTypes(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName) {
        return Boolean.TRUE.equals(AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, annotationName, new SimpleAnnotationProcessor<Boolean>(){

            @Override
            public Boolean process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                return metaDepth > 0 ? Boolean.TRUE : CONTINUE;
            }
        }));
    }

    public static boolean isAnnotated(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "'annotationType' must not be null");
        if (element.isAnnotationPresent(annotationType)) {
            return true;
        }
        return Boolean.TRUE.equals(AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, null, alwaysTrueAnnotationProcessor));
    }

    public static boolean isAnnotated(AnnotatedElement element, String annotationName) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.hasLength(annotationName, "'annotationName' must not be null or empty");
        return Boolean.TRUE.equals(AnnotatedElementUtils.searchWithGetSemantics(element, null, annotationName, alwaysTrueAnnotationProcessor));
    }

    @Deprecated
    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, String annotationName) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes(element, annotationName);
    }

    @Deprecated
    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement element, String annotationName, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes(element, annotationName, classValuesAsString, nestedAnnotationsAsMap);
    }

    public static AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        Assert.notNull(annotationType, "'annotationType' must not be null");
        AnnotationAttributes attributes = AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, null, new MergedAnnotationAttributesProcessor());
        AnnotationUtils.postProcessAnnotationAttributes(element, attributes, false, false);
        return attributes;
    }

    public static AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement element, String annotationName) {
        return AnnotatedElementUtils.getMergedAnnotationAttributes(element, annotationName, false, false);
    }

    public static AnnotationAttributes getMergedAnnotationAttributes(AnnotatedElement element, String annotationName, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        Assert.hasLength(annotationName, "'annotationName' must not be null or empty");
        AnnotationAttributes attributes = AnnotatedElementUtils.searchWithGetSemantics(element, null, annotationName, new MergedAnnotationAttributesProcessor(classValuesAsString, nestedAnnotationsAsMap));
        AnnotationUtils.postProcessAnnotationAttributes(element, attributes, classValuesAsString, nestedAnnotationsAsMap);
        return attributes;
    }

    public static <A extends Annotation> A getMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        A annotation;
        Assert.notNull(annotationType, "'annotationType' must not be null");
        if (!(element instanceof Class) && (annotation = element.getAnnotation(annotationType)) != null) {
            return AnnotationUtils.synthesizeAnnotation(annotation, element);
        }
        AnnotationAttributes attributes = AnnotatedElementUtils.getMergedAnnotationAttributes(element, annotationType);
        return AnnotationUtils.synthesizeAnnotation(attributes, annotationType, element);
    }

    public static <A extends Annotation> Set<A> getAllMergedAnnotations(AnnotatedElement element, Class<A> annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "'annotationType' must not be null");
        MergedAnnotationAttributesProcessor processor = new MergedAnnotationAttributesProcessor(false, false, true);
        AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, null, processor);
        return AnnotatedElementUtils.postProcessAndSynthesizeAggregatedResults(element, annotationType, processor.getAggregatedResults());
    }

    public static <A extends Annotation> Set<A> getMergedRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType) {
        return AnnotatedElementUtils.getMergedRepeatableAnnotations(element, annotationType, null);
    }

    public static <A extends Annotation> Set<A> getMergedRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType, Class<? extends Annotation> containerType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "'annotationType' must not be null");
        if (containerType == null) {
            containerType = AnnotatedElementUtils.resolveContainerType(annotationType);
        } else {
            AnnotatedElementUtils.validateContainerType(annotationType, containerType);
        }
        MergedAnnotationAttributesProcessor processor = new MergedAnnotationAttributesProcessor(false, false, true);
        AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, null, containerType, processor);
        return AnnotatedElementUtils.postProcessAndSynthesizeAggregatedResults(element, annotationType, processor.getAggregatedResults());
    }

    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement element, String annotationName) {
        return AnnotatedElementUtils.getAllAnnotationAttributes(element, annotationName, false, false);
    }

    public static MultiValueMap<String, Object> getAllAnnotationAttributes(AnnotatedElement element, String annotationName, final boolean classValuesAsString, final boolean nestedAnnotationsAsMap) {
        final LinkedMultiValueMap<String, Object> attributesMap = new LinkedMultiValueMap<String, Object>();
        AnnotatedElementUtils.searchWithGetSemantics(element, null, annotationName, new SimpleAnnotationProcessor<Object>(){

            @Override
            public Object process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
                AnnotationAttributes annotationAttributes = AnnotationUtils.getAnnotationAttributes(annotation, classValuesAsString, nestedAnnotationsAsMap);
                for (Map.Entry entry2 : annotationAttributes.entrySet()) {
                    attributesMap.add(entry2.getKey(), entry2.getValue());
                }
                return CONTINUE;
            }
        });
        return !attributesMap.isEmpty() ? attributesMap : null;
    }

    public static boolean hasAnnotation(AnnotatedElement element, Class<? extends Annotation> annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "'annotationType' must not be null");
        if (element.isAnnotationPresent(annotationType)) {
            return true;
        }
        return Boolean.TRUE.equals(AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, null, alwaysTrueAnnotationProcessor));
    }

    public static AnnotationAttributes findMergedAnnotationAttributes(AnnotatedElement element, Class<? extends Annotation> annotationType, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        AnnotationAttributes attributes = AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, null, new MergedAnnotationAttributesProcessor(classValuesAsString, nestedAnnotationsAsMap));
        AnnotationUtils.postProcessAnnotationAttributes(element, attributes, classValuesAsString, nestedAnnotationsAsMap);
        return attributes;
    }

    public static AnnotationAttributes findMergedAnnotationAttributes(AnnotatedElement element, String annotationName, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        AnnotationAttributes attributes = AnnotatedElementUtils.searchWithFindSemantics(element, null, annotationName, new MergedAnnotationAttributesProcessor(classValuesAsString, nestedAnnotationsAsMap));
        AnnotationUtils.postProcessAnnotationAttributes(element, attributes, classValuesAsString, nestedAnnotationsAsMap);
        return attributes;
    }

    public static <A extends Annotation> A findMergedAnnotation(AnnotatedElement element, Class<A> annotationType) {
        A annotation;
        Assert.notNull(annotationType, "'annotationType' must not be null");
        if (!(element instanceof Class) && (annotation = element.getAnnotation(annotationType)) != null) {
            return AnnotationUtils.synthesizeAnnotation(annotation, element);
        }
        AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(element, annotationType, false, false);
        return AnnotationUtils.synthesizeAnnotation(attributes, annotationType, element);
    }

    @Deprecated
    public static <A extends Annotation> A findMergedAnnotation(AnnotatedElement element, String annotationName) {
        AnnotationAttributes attributes = AnnotatedElementUtils.findMergedAnnotationAttributes(element, annotationName, false, false);
        return (A)AnnotationUtils.synthesizeAnnotation(attributes, attributes.annotationType(), element);
    }

    public static <A extends Annotation> Set<A> findAllMergedAnnotations(AnnotatedElement element, Class<A> annotationType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "'annotationType' must not be null");
        MergedAnnotationAttributesProcessor processor = new MergedAnnotationAttributesProcessor(false, false, true);
        AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, null, processor);
        return AnnotatedElementUtils.postProcessAndSynthesizeAggregatedResults(element, annotationType, processor.getAggregatedResults());
    }

    public static <A extends Annotation> Set<A> findMergedRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType) {
        return AnnotatedElementUtils.findMergedRepeatableAnnotations(element, annotationType, null);
    }

    public static <A extends Annotation> Set<A> findMergedRepeatableAnnotations(AnnotatedElement element, Class<A> annotationType, Class<? extends Annotation> containerType) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        Assert.notNull(annotationType, "'annotationType' must not be null");
        if (containerType == null) {
            containerType = AnnotatedElementUtils.resolveContainerType(annotationType);
        } else {
            AnnotatedElementUtils.validateContainerType(annotationType, containerType);
        }
        MergedAnnotationAttributesProcessor processor = new MergedAnnotationAttributesProcessor(false, false, true);
        AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, null, containerType, processor);
        return AnnotatedElementUtils.postProcessAndSynthesizeAggregatedResults(element, annotationType, processor.getAggregatedResults());
    }

    private static <T> T searchWithGetSemantics(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName, Processor<T> processor) {
        return AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, annotationName, null, processor);
    }

    private static <T> T searchWithGetSemantics(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName, Class<? extends Annotation> containerType, Processor<T> processor) {
        try {
            return AnnotatedElementUtils.searchWithGetSemantics(element, annotationType, annotationName, containerType, processor, new HashSet<AnnotatedElement>(), 0);
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            throw new IllegalStateException("Failed to introspect annotations on " + element, ex);
        }
    }

    private static <T> T searchWithGetSemantics(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName, Class<? extends Annotation> containerType, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth) {
        Assert.notNull(element, "AnnotatedElement must not be null");
        if (visited.add(element)) {
            try {
                List<Annotation> declaredAnnotations = Arrays.asList(element.getDeclaredAnnotations());
                T result2 = AnnotatedElementUtils.searchWithGetSemanticsInAnnotations(element, declaredAnnotations, annotationType, annotationName, containerType, processor, visited, metaDepth);
                if (result2 != null) {
                    return result2;
                }
                if (element instanceof Class) {
                    ArrayList<Annotation> inheritedAnnotations = new ArrayList<Annotation>();
                    for (Annotation annotation : element.getAnnotations()) {
                        if (declaredAnnotations.contains(annotation)) continue;
                        inheritedAnnotations.add(annotation);
                    }
                    result2 = AnnotatedElementUtils.searchWithGetSemanticsInAnnotations(element, inheritedAnnotations, annotationType, annotationName, containerType, processor, visited, metaDepth);
                    if (result2 != null) {
                        return result2;
                    }
                }
            }
            catch (Throwable ex) {
                AnnotationUtils.handleIntrospectionFailure(element, ex);
            }
        }
        return null;
    }

    private static <T> T searchWithGetSemanticsInAnnotations(AnnotatedElement element, List<Annotation> annotations2, Class<? extends Annotation> annotationType, String annotationName, Class<? extends Annotation> containerType, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth) {
        Object result2;
        Class<? extends Annotation> currentAnnotationType;
        for (Annotation annotation : annotations2) {
            currentAnnotationType = annotation.annotationType();
            if (AnnotationUtils.isInJavaLangAnnotationPackage(currentAnnotationType)) continue;
            if (currentAnnotationType == annotationType || currentAnnotationType.getName().equals(annotationName) || processor.alwaysProcesses()) {
                result2 = processor.process(element, annotation, metaDepth);
                if (result2 == null) continue;
                if (processor.aggregates() && metaDepth == 0) {
                    processor.getAggregatedResults().add(result2);
                    continue;
                }
                return result2;
            }
            if (currentAnnotationType != containerType) continue;
            result2 = AnnotatedElementUtils.getRawAnnotationsFromContainer((AnnotatedElement)element, (Annotation)annotation);
            int n = ((T)result2).length;
            for (int i = 0; i < n; ++i) {
                T contained = result2[i];
                T result3 = processor.process(element, (Annotation)contained, metaDepth);
                if (result3 == null) continue;
                processor.getAggregatedResults().add(result3);
            }
        }
        for (Annotation annotation : annotations2) {
            currentAnnotationType = annotation.annotationType();
            if (AnnotationUtils.isInJavaLangAnnotationPackage(currentAnnotationType) || (result2 = AnnotatedElementUtils.searchWithGetSemantics(currentAnnotationType, annotationType, annotationName, containerType, processor, visited, metaDepth + 1)) == null) continue;
            processor.postProcess(element, annotation, result2);
            if (processor.aggregates() && metaDepth == 0) {
                processor.getAggregatedResults().add(result2);
                continue;
            }
            return result2;
        }
        return null;
    }

    private static <T> T searchWithFindSemantics(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName, Processor<T> processor) {
        return AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, annotationName, null, processor);
    }

    private static <T> T searchWithFindSemantics(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName, Class<? extends Annotation> containerType, Processor<T> processor) {
        if (containerType != null && !processor.aggregates()) {
            throw new IllegalArgumentException("Searches for repeatable annotations must supply an aggregating Processor");
        }
        try {
            return AnnotatedElementUtils.searchWithFindSemantics(element, annotationType, annotationName, containerType, processor, new HashSet<AnnotatedElement>(), 0);
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            throw new IllegalStateException("Failed to introspect annotations on " + element, ex);
        }
    }

    private static <T> T searchWithFindSemantics(AnnotatedElement element, Class<? extends Annotation> annotationType, String annotationName, Class<? extends Annotation> containerType, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth) {
        block21: {
            Assert.notNull(element, "AnnotatedElement must not be null");
            if (visited.add(element)) {
                try {
                    Annotation[] annotations2 = element.getDeclaredAnnotations();
                    if (annotations2.length > 0) {
                        Class<? extends Annotation> currentAnnotationType;
                        ArrayList<T> aggregatedResults = processor.aggregates() ? new ArrayList<T>() : null;
                        for (Annotation annotation : annotations2) {
                            currentAnnotationType = annotation.annotationType();
                            if (AnnotationUtils.isInJavaLangAnnotationPackage(currentAnnotationType)) continue;
                            if (currentAnnotationType == annotationType || currentAnnotationType.getName().equals(annotationName) || processor.alwaysProcesses()) {
                                Object result2 = processor.process(element, annotation, metaDepth);
                                if (result2 == null) continue;
                                if (aggregatedResults != null && metaDepth == 0) {
                                    aggregatedResults.add(result2);
                                    continue;
                                }
                                return result2;
                            }
                            if (currentAnnotationType != containerType) continue;
                            for (T contained : AnnotatedElementUtils.getRawAnnotationsFromContainer((AnnotatedElement)element, (Annotation)annotation)) {
                                T result3 = processor.process(element, (Annotation)contained, metaDepth);
                                if (aggregatedResults == null || result3 == null) continue;
                                aggregatedResults.add(result3);
                            }
                        }
                        Annotation[] annotationArray = annotations2;
                        int n = annotationArray.length;
                        for (int i = 0; i < n; ++i) {
                            T result2;
                            Annotation annotation;
                            annotation = annotationArray[i];
                            currentAnnotationType = annotation.annotationType();
                            if (AnnotationUtils.isInJavaLangAnnotationPackage(currentAnnotationType) || (result2 = AnnotatedElementUtils.searchWithFindSemantics(currentAnnotationType, annotationType, annotationName, containerType, processor, visited, metaDepth + 1)) == null) continue;
                            processor.postProcess(currentAnnotationType, annotation, result2);
                            if (aggregatedResults != null && metaDepth == 0) {
                                aggregatedResults.add(result2);
                                continue;
                            }
                            return result2;
                        }
                        if (!CollectionUtils.isEmpty(aggregatedResults)) {
                            processor.getAggregatedResults().addAll(0, aggregatedResults);
                        }
                    }
                    if (element instanceof Method) {
                        T t;
                        T t2;
                        Method method = (Method)element;
                        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
                        if (resolvedMethod != method && (t2 = AnnotatedElementUtils.searchWithFindSemantics(resolvedMethod, annotationType, annotationName, containerType, processor, visited, metaDepth)) != null) {
                            return t2;
                        }
                        Class<?>[] ifcs = method.getDeclaringClass().getInterfaces();
                        if (ifcs.length > 0 && (t = AnnotatedElementUtils.searchOnInterfaces(method, annotationType, annotationName, containerType, processor, visited, metaDepth, ifcs)) != null) {
                            return t;
                        }
                        Class<?> clazz2 = method.getDeclaringClass();
                        while ((clazz2 = clazz2.getSuperclass()) != null && Object.class != clazz2) {
                            T t3;
                            try {
                                Method equivalentMethod = clazz2.getDeclaredMethod(method.getName(), method.getParameterTypes());
                                Method resolvedEquivalentMethod = BridgeMethodResolver.findBridgedMethod(equivalentMethod);
                                T t4 = AnnotatedElementUtils.searchWithFindSemantics(resolvedEquivalentMethod, annotationType, annotationName, containerType, processor, visited, metaDepth);
                                if (t4 != null) {
                                    return t4;
                                }
                            }
                            catch (NoSuchMethodException equivalentMethod) {
                                // empty catch block
                            }
                            if ((t3 = AnnotatedElementUtils.searchOnInterfaces(method, annotationType, annotationName, containerType, processor, visited, metaDepth, clazz2.getInterfaces())) == null) continue;
                            return t3;
                        }
                        break block21;
                    }
                    if (element instanceof Class) {
                        T result5;
                        Class clazz3 = (Class)element;
                        for (Class<?> ifc : clazz3.getInterfaces()) {
                            T result6 = AnnotatedElementUtils.searchWithFindSemantics(ifc, annotationType, annotationName, containerType, processor, visited, metaDepth);
                            if (result6 == null) continue;
                            return result6;
                        }
                        Class clazz2 = clazz3.getSuperclass();
                        if (clazz2 != null && Object.class != clazz2 && (result5 = AnnotatedElementUtils.searchWithFindSemantics(clazz2, annotationType, annotationName, containerType, processor, visited, metaDepth)) != null) {
                            return result5;
                        }
                    }
                }
                catch (Throwable ex) {
                    AnnotationUtils.handleIntrospectionFailure(element, ex);
                }
            }
        }
        return null;
    }

    private static <T> T searchOnInterfaces(Method method, Class<? extends Annotation> annotationType, String annotationName, Class<? extends Annotation> containerType, Processor<T> processor, Set<AnnotatedElement> visited, int metaDepth, Class<?>[] ifcs) {
        for (Class<?> iface : ifcs) {
            if (!AnnotationUtils.isInterfaceWithAnnotatedMethods(iface)) continue;
            try {
                Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                T result2 = AnnotatedElementUtils.searchWithFindSemantics(equivalentMethod, annotationType, annotationName, containerType, processor, visited, metaDepth);
                if (result2 == null) continue;
                return result2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static <A extends Annotation> A[] getRawAnnotationsFromContainer(AnnotatedElement element, Annotation container) {
        try {
            return (Annotation[])AnnotationUtils.getValue(container);
        }
        catch (Throwable ex) {
            AnnotationUtils.handleIntrospectionFailure(element, ex);
            return EMPTY_ANNOTATION_ARRAY;
        }
    }

    private static Class<? extends Annotation> resolveContainerType(Class<? extends Annotation> annotationType) {
        Class<? extends Annotation> containerType = AnnotationUtils.resolveContainerAnnotationType(annotationType);
        if (containerType == null) {
            throw new IllegalArgumentException("Annotation type must be a repeatable annotation: failed to resolve container type for " + annotationType.getName());
        }
        return containerType;
    }

    private static void validateContainerType(Class<? extends Annotation> annotationType, Class<? extends Annotation> containerType) {
        try {
            Method method = containerType.getDeclaredMethod("value", new Class[0]);
            Class<?> returnType = method.getReturnType();
            if (!returnType.isArray() || returnType.getComponentType() != annotationType) {
                String msg = String.format("Container type [%s] must declare a 'value' attribute for an array of type [%s]", containerType.getName(), annotationType.getName());
                throw new AnnotationConfigurationException(msg);
            }
        }
        catch (Throwable ex) {
            AnnotationUtils.rethrowAnnotationConfigurationException(ex);
            String msg = String.format("Invalid declaration of container type [%s] for repeatable annotation [%s]", containerType.getName(), annotationType.getName());
            throw new AnnotationConfigurationException(msg, ex);
        }
    }

    private static <A extends Annotation> Set<A> postProcessAndSynthesizeAggregatedResults(AnnotatedElement element, Class<A> annotationType, List<AnnotationAttributes> aggregatedResults) {
        LinkedHashSet<A> annotations2 = new LinkedHashSet<A>();
        for (AnnotationAttributes attributes : aggregatedResults) {
            AnnotationUtils.postProcessAnnotationAttributes(element, attributes, false, false);
            annotations2.add(AnnotationUtils.synthesizeAnnotation(attributes, annotationType, element));
        }
        return annotations2;
    }

    private static class MergedAnnotationAttributesProcessor
    implements Processor<AnnotationAttributes> {
        private final boolean classValuesAsString;
        private final boolean nestedAnnotationsAsMap;
        private final boolean aggregates;
        private final List<AnnotationAttributes> aggregatedResults;

        MergedAnnotationAttributesProcessor() {
            this(false, false, false);
        }

        MergedAnnotationAttributesProcessor(boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
            this(classValuesAsString, nestedAnnotationsAsMap, false);
        }

        MergedAnnotationAttributesProcessor(boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean aggregates) {
            this.classValuesAsString = classValuesAsString;
            this.nestedAnnotationsAsMap = nestedAnnotationsAsMap;
            this.aggregates = aggregates;
            this.aggregatedResults = aggregates ? new ArrayList() : null;
        }

        @Override
        public boolean alwaysProcesses() {
            return false;
        }

        @Override
        public boolean aggregates() {
            return this.aggregates;
        }

        @Override
        public List<AnnotationAttributes> getAggregatedResults() {
            return this.aggregatedResults;
        }

        @Override
        public AnnotationAttributes process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
            return AnnotationUtils.retrieveAnnotationAttributes(annotatedElement, annotation, this.classValuesAsString, this.nestedAnnotationsAsMap);
        }

        @Override
        public void postProcess(AnnotatedElement element, Annotation annotation, AnnotationAttributes attributes) {
            annotation = AnnotationUtils.synthesizeAnnotation(annotation, element);
            Class<? extends Annotation> targetAnnotationType = attributes.annotationType();
            HashSet<String> valuesAlreadyReplaced = new HashSet<String>();
            for (Method attributeMethod : AnnotationUtils.getAttributeMethods(annotation.annotationType())) {
                String attributeName = attributeMethod.getName();
                String attributeOverrideName = AnnotationUtils.getAttributeOverrideName(attributeMethod, targetAnnotationType);
                if (attributeOverrideName != null) {
                    if (valuesAlreadyReplaced.contains(attributeOverrideName)) continue;
                    ArrayList<String> targetAttributeNames = new ArrayList<String>();
                    targetAttributeNames.add(attributeOverrideName);
                    valuesAlreadyReplaced.add(attributeOverrideName);
                    List<String> aliases2 = AnnotationUtils.getAttributeAliasMap(targetAnnotationType).get(attributeOverrideName);
                    if (aliases2 != null) {
                        for (String alias : aliases2) {
                            if (valuesAlreadyReplaced.contains(alias)) continue;
                            targetAttributeNames.add(alias);
                            valuesAlreadyReplaced.add(alias);
                        }
                    }
                    this.overrideAttributes(element, annotation, attributes, attributeName, targetAttributeNames);
                    continue;
                }
                if ("value".equals(attributeName) || !attributes.containsKey(attributeName)) continue;
                this.overrideAttribute(element, annotation, attributes, attributeName, attributeName);
            }
        }

        private void overrideAttributes(AnnotatedElement element, Annotation annotation, AnnotationAttributes attributes, String sourceAttributeName, List<String> targetAttributeNames) {
            Object adaptedValue = this.getAdaptedValue(element, annotation, sourceAttributeName);
            for (String targetAttributeName : targetAttributeNames) {
                attributes.put(targetAttributeName, adaptedValue);
            }
        }

        private void overrideAttribute(AnnotatedElement element, Annotation annotation, AnnotationAttributes attributes, String sourceAttributeName, String targetAttributeName) {
            attributes.put(targetAttributeName, this.getAdaptedValue(element, annotation, sourceAttributeName));
        }

        private Object getAdaptedValue(AnnotatedElement element, Annotation annotation, String sourceAttributeName) {
            Object value2 = AnnotationUtils.getValue(annotation, sourceAttributeName);
            return AnnotationUtils.adaptValue(element, value2, this.classValuesAsString, this.nestedAnnotationsAsMap);
        }
    }

    static class AlwaysTrueBooleanAnnotationProcessor
    extends SimpleAnnotationProcessor<Boolean> {
        AlwaysTrueBooleanAnnotationProcessor() {
        }

        @Override
        public final Boolean process(AnnotatedElement annotatedElement, Annotation annotation, int metaDepth) {
            return Boolean.TRUE;
        }
    }

    private static abstract class SimpleAnnotationProcessor<T>
    implements Processor<T> {
        private final boolean alwaysProcesses;

        public SimpleAnnotationProcessor() {
            this(false);
        }

        public SimpleAnnotationProcessor(boolean alwaysProcesses) {
            this.alwaysProcesses = alwaysProcesses;
        }

        @Override
        public final boolean alwaysProcesses() {
            return this.alwaysProcesses;
        }

        @Override
        public final void postProcess(AnnotatedElement annotatedElement, Annotation annotation, T result2) {
        }

        @Override
        public final boolean aggregates() {
            return false;
        }

        @Override
        public final List<T> getAggregatedResults() {
            throw new UnsupportedOperationException("SimpleAnnotationProcessor does not support aggregated results");
        }
    }

    private static interface Processor<T> {
        public T process(AnnotatedElement var1, Annotation var2, int var3);

        public void postProcess(AnnotatedElement var1, Annotation var2, T var3);

        public boolean alwaysProcesses();

        public boolean aggregates();

        public List<T> getAggregatedResults();
    }
}

