/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

abstract class SerializableTypeWrapper {
    private static final Class<?>[] SUPPORTED_SERIALIZABLE_TYPES = new Class[]{GenericArrayType.class, ParameterizedType.class, TypeVariable.class, WildcardType.class};
    static final ConcurrentReferenceHashMap<Type, Type> cache = new ConcurrentReferenceHashMap(256);

    SerializableTypeWrapper() {
    }

    public static Type forField(Field field2) {
        Assert.notNull(field2, "Field must not be null");
        return SerializableTypeWrapper.forTypeProvider(new FieldTypeProvider(field2));
    }

    public static Type forMethodParameter(MethodParameter methodParameter) {
        return SerializableTypeWrapper.forTypeProvider(new MethodParameterTypeProvider(methodParameter));
    }

    public static Type forGenericSuperclass(final Class<?> type) {
        return SerializableTypeWrapper.forTypeProvider(new SimpleTypeProvider(){

            @Override
            public Type getType() {
                return type.getGenericSuperclass();
            }
        });
    }

    public static Type[] forGenericInterfaces(final Class<?> type) {
        Type[] result2 = new Type[type.getGenericInterfaces().length];
        for (int i = 0; i < result2.length; ++i) {
            final int index2 = i;
            result2[i] = SerializableTypeWrapper.forTypeProvider(new SimpleTypeProvider(){

                @Override
                public Type getType() {
                    return type.getGenericInterfaces()[index2];
                }
            });
        }
        return result2;
    }

    public static Type[] forTypeParameters(final Class<?> type) {
        Type[] result2 = new Type[type.getTypeParameters().length];
        for (int i = 0; i < result2.length; ++i) {
            final int index2 = i;
            result2[i] = SerializableTypeWrapper.forTypeProvider(new SimpleTypeProvider(){

                @Override
                public Type getType() {
                    return type.getTypeParameters()[index2];
                }
            });
        }
        return result2;
    }

    public static <T extends Type> T unwrap(T type) {
        Object unwrapped = type;
        while (unwrapped instanceof SerializableTypeProxy) {
            unwrapped = ((SerializableTypeProxy)((Object)type)).getTypeProvider().getType();
        }
        return unwrapped;
    }

    static Type forTypeProvider(TypeProvider provider) {
        Assert.notNull(provider, "Provider must not be null");
        if (provider.getType() instanceof Serializable || provider.getType() == null) {
            return provider.getType();
        }
        Type cached = cache.get(provider.getType());
        if (cached != null) {
            return cached;
        }
        for (Class<?> type : SUPPORTED_SERIALIZABLE_TYPES) {
            if (!type.isAssignableFrom(provider.getType().getClass())) continue;
            ClassLoader classLoader = provider.getClass().getClassLoader();
            Class[] interfaces2 = new Class[]{type, SerializableTypeProxy.class, Serializable.class};
            TypeProxyInvocationHandler handler = new TypeProxyInvocationHandler(provider);
            cached = (Type)Proxy.newProxyInstance(classLoader, interfaces2, (InvocationHandler)handler);
            cache.put(provider.getType(), cached);
            return cached;
        }
        throw new IllegalArgumentException("Unsupported Type class: " + provider.getType().getClass().getName());
    }

    static class MethodInvokeTypeProvider
    implements TypeProvider {
        private final TypeProvider provider;
        private final String methodName;
        private final Class<?> declaringClass;
        private final int index;
        private transient Method method;
        private volatile transient Object result;

        public MethodInvokeTypeProvider(TypeProvider provider, Method method, int index2) {
            this.provider = provider;
            this.methodName = method.getName();
            this.declaringClass = method.getDeclaringClass();
            this.index = index2;
            this.method = method;
        }

        @Override
        public Type getType() {
            Object result2 = this.result;
            if (result2 == null) {
                this.result = result2 = ReflectionUtils.invokeMethod(this.method, this.provider.getType());
            }
            return result2 instanceof Type[] ? ((Type[])result2)[this.index] : (Type)result2;
        }

        @Override
        public Object getSource() {
            return null;
        }

        private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            inputStream.defaultReadObject();
            this.method = ReflectionUtils.findMethod(this.declaringClass, this.methodName);
            if (this.method.getReturnType() != Type.class && this.method.getReturnType() != Type[].class) {
                throw new IllegalStateException("Invalid return type on deserialized method - needs to be Type or Type[]: " + this.method);
            }
        }
    }

    static class MethodParameterTypeProvider
    implements TypeProvider {
        private final String methodName;
        private final Class<?>[] parameterTypes;
        private final Class<?> declaringClass;
        private final int parameterIndex;
        private transient MethodParameter methodParameter;

        public MethodParameterTypeProvider(MethodParameter methodParameter) {
            if (methodParameter.getMethod() != null) {
                this.methodName = methodParameter.getMethod().getName();
                this.parameterTypes = methodParameter.getMethod().getParameterTypes();
            } else {
                this.methodName = null;
                this.parameterTypes = methodParameter.getConstructor().getParameterTypes();
            }
            this.declaringClass = methodParameter.getDeclaringClass();
            this.parameterIndex = methodParameter.getParameterIndex();
            this.methodParameter = methodParameter;
        }

        @Override
        public Type getType() {
            return this.methodParameter.getGenericParameterType();
        }

        @Override
        public Object getSource() {
            return this.methodParameter;
        }

        private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            inputStream.defaultReadObject();
            try {
                this.methodParameter = this.methodName != null ? new MethodParameter(this.declaringClass.getDeclaredMethod(this.methodName, this.parameterTypes), this.parameterIndex) : new MethodParameter(this.declaringClass.getDeclaredConstructor(this.parameterTypes), this.parameterIndex);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Could not find original class structure", ex);
            }
        }
    }

    static class FieldTypeProvider
    implements TypeProvider {
        private final String fieldName;
        private final Class<?> declaringClass;
        private transient Field field;

        public FieldTypeProvider(Field field2) {
            this.fieldName = field2.getName();
            this.declaringClass = field2.getDeclaringClass();
            this.field = field2;
        }

        @Override
        public Type getType() {
            return this.field.getGenericType();
        }

        @Override
        public Object getSource() {
            return this.field;
        }

        private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
            inputStream.defaultReadObject();
            try {
                this.field = this.declaringClass.getDeclaredField(this.fieldName);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Could not find original class structure", ex);
            }
        }
    }

    private static class TypeProxyInvocationHandler
    implements InvocationHandler,
    Serializable {
        private final TypeProvider provider;

        public TypeProxyInvocationHandler(TypeProvider provider) {
            this.provider = provider;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            if (method.getName().equals("equals")) {
                Object other = args2[0];
                if (other instanceof Type) {
                    other = SerializableTypeWrapper.unwrap((Type)other);
                }
                return this.provider.getType().equals(other);
            }
            if (method.getName().equals("hashCode")) {
                return this.provider.getType().hashCode();
            }
            if (method.getName().equals("getTypeProvider")) {
                return this.provider;
            }
            if (Type.class == method.getReturnType() && args2 == null) {
                return SerializableTypeWrapper.forTypeProvider(new MethodInvokeTypeProvider(this.provider, method, -1));
            }
            if (Type[].class == method.getReturnType() && args2 == null) {
                Type[] result2 = new Type[((Type[])method.invoke((Object)this.provider.getType(), args2)).length];
                for (int i = 0; i < result2.length; ++i) {
                    result2[i] = SerializableTypeWrapper.forTypeProvider(new MethodInvokeTypeProvider(this.provider, method, i));
                }
                return result2;
            }
            try {
                return method.invoke((Object)this.provider.getType(), args2);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static abstract class SimpleTypeProvider
    implements TypeProvider {
        private SimpleTypeProvider() {
        }

        @Override
        public Object getSource() {
            return null;
        }
    }

    static interface TypeProvider
    extends Serializable {
        public Type getType();

        public Object getSource();
    }

    static interface SerializableTypeProxy {
        public TypeProvider getTypeProvider();
    }
}

