/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.DecoratingClassLoader;
import org.springframework.lang.UsesJava7;
import org.springframework.util.FileCopyUtils;

@UsesJava7
public class OverridingClassLoader
extends DecoratingClassLoader {
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle.", "javassist.", "org.aspectj.", "net.sf.cglib."};
    private static final String CLASS_FILE_SUFFIX = ".class";
    private final ClassLoader overrideDelegate;

    public OverridingClassLoader(ClassLoader parent) {
        this(parent, null);
    }

    public OverridingClassLoader(ClassLoader parent, ClassLoader overrideDelegate) {
        super(parent);
        this.overrideDelegate = overrideDelegate;
        for (String packageName : DEFAULT_EXCLUDED_PACKAGES) {
            this.excludePackage(packageName);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.overrideDelegate != null && this.isEligibleForOverriding(name)) {
            return this.overrideDelegate.loadClass(name);
        }
        return super.loadClass(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result2;
        if (this.isEligibleForOverriding(name) && (result2 = this.loadClassForOverriding(name)) != null) {
            if (resolve) {
                this.resolveClass(result2);
            }
            return result2;
        }
        return super.loadClass(name, resolve);
    }

    protected boolean isEligibleForOverriding(String className) {
        return !this.isExcluded(className);
    }

    protected Class<?> loadClassForOverriding(String name) throws ClassNotFoundException {
        byte[] bytes2;
        Class<?> result2 = this.findLoadedClass(name);
        if (result2 == null && (bytes2 = this.loadBytesForClass(name)) != null) {
            result2 = this.defineClass(name, bytes2, 0, bytes2.length);
        }
        return result2;
    }

    protected byte[] loadBytesForClass(String name) throws ClassNotFoundException {
        InputStream is = this.openStreamForClass(name);
        if (is == null) {
            return null;
        }
        try {
            byte[] bytes2 = FileCopyUtils.copyToByteArray(is);
            return this.transformIfNecessary(name, bytes2);
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", ex);
        }
    }

    protected InputStream openStreamForClass(String name) {
        String internalName = name.replace('.', '/') + CLASS_FILE_SUFFIX;
        return this.getParent().getResourceAsStream(internalName);
    }

    protected byte[] transformIfNecessary(String name, byte[] bytes2) {
        return bytes2;
    }

    static {
        if (parallelCapableClassLoaderAvailable) {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

