/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class MethodIntrospector {
    public static <T> Map<Method, T> selectMethods(Class<?> targetType, final MetadataLookup<T> metadataLookup) {
        final LinkedHashMap methodMap = new LinkedHashMap();
        LinkedHashSet handlerTypes = new LinkedHashSet();
        Class specificHandlerType = null;
        if (!Proxy.isProxyClass(targetType)) {
            handlerTypes.add(targetType);
            specificHandlerType = targetType;
        }
        handlerTypes.addAll(Arrays.asList(targetType.getInterfaces()));
        for (Class clazz2 : handlerTypes) {
            final Class targetClass = specificHandlerType != null ? specificHandlerType : clazz2;
            ReflectionUtils.doWithMethods(clazz2, new ReflectionUtils.MethodCallback(){

                @Override
                public void doWith(Method method) {
                    Method bridgedMethod;
                    Method specificMethod = ClassUtils.getMostSpecificMethod(method, targetClass);
                    Object result2 = metadataLookup.inspect(specificMethod);
                    if (result2 != null && ((bridgedMethod = BridgeMethodResolver.findBridgedMethod(specificMethod)) == specificMethod || metadataLookup.inspect(bridgedMethod) == null)) {
                        methodMap.put(specificMethod, result2);
                    }
                }
            }, ReflectionUtils.USER_DECLARED_METHODS);
        }
        return methodMap;
    }

    public static Set<Method> selectMethods(Class<?> targetType, final ReflectionUtils.MethodFilter methodFilter) {
        return MethodIntrospector.selectMethods(targetType, new MetadataLookup<Boolean>(){

            @Override
            public Boolean inspect(Method method) {
                return methodFilter.matches(method) ? Boolean.TRUE : null;
            }
        }).keySet();
    }

    public static Method selectInvocableMethod(Method method, Class<?> targetType) {
        if (method.getDeclaringClass().isAssignableFrom(targetType)) {
            return method;
        }
        try {
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (Class<?> ifc : targetType.getInterfaces()) {
                try {
                    return ifc.getMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            return targetType.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(String.format("Need to invoke method '%s' declared on target class '%s', but not found in any interface(s) of the exposed proxy type. Either pull the method up to an interface or switch to CGLIB proxies by enforcing proxy-target-class mode in your configuration.", method.getName(), method.getDeclaringClass().getSimpleName()));
        }
    }

    public static interface MetadataLookup<T> {
        public T inspect(Method var1);
    }
}

