/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;

public class LocalVariableTableParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static final Log logger = LogFactory.getLog(LocalVariableTableParameterNameDiscoverer.class);
    private static final Map<Member, String[]> NO_DEBUG_INFO_MAP = Collections.emptyMap();
    private final Map<Class<?>, Map<Member, String[]>> parameterNamesCache = new ConcurrentHashMap(32);

    @Override
    public String[] getParameterNames(Method method) {
        Method originalMethod = BridgeMethodResolver.findBridgedMethod(method);
        Class<?> declaringClass = originalMethod.getDeclaringClass();
        Map<Member, String[]> map2 = this.parameterNamesCache.get(declaringClass);
        if (map2 == null) {
            map2 = this.inspectClass(declaringClass);
            this.parameterNamesCache.put(declaringClass, map2);
        }
        if (map2 != NO_DEBUG_INFO_MAP) {
            return map2.get(originalMethod);
        }
        return null;
    }

    @Override
    public String[] getParameterNames(Constructor<?> ctor) {
        Class<?> declaringClass = ctor.getDeclaringClass();
        Map<Member, String[]> map2 = this.parameterNamesCache.get(declaringClass);
        if (map2 == null) {
            map2 = this.inspectClass(declaringClass);
            this.parameterNamesCache.put(declaringClass, map2);
        }
        if (map2 != NO_DEBUG_INFO_MAP) {
            return map2.get(ctor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Member, String[]> inspectClass(Class<?> clazz2) {
        InputStream is = clazz2.getResourceAsStream(ClassUtils.getClassFileName(clazz2));
        if (is == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot find '.class' file for class [" + clazz2 + "] - unable to determine constructor/method parameter names");
            }
            return NO_DEBUG_INFO_MAP;
        }
        try {
            ClassReader classReader = new ClassReader(is);
            ConcurrentHashMap<Member, String[]> map2 = new ConcurrentHashMap<Member, String[]>(32);
            classReader.accept(new ParameterNameDiscoveringVisitor(clazz2, map2), 0);
            ConcurrentHashMap<Member, String[]> concurrentHashMap = map2;
            return concurrentHashMap;
        }
        catch (IOException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception thrown while reading '.class' file for class [" + clazz2 + "] - unable to determine constructor/method parameter names", ex);
            }
        }
        catch (IllegalArgumentException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("ASM ClassReader failed to parse class file [" + clazz2 + "], probably due to a new Java class file version that isn't supported yet - unable to determine constructor/method parameter names", ex);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
        return NO_DEBUG_INFO_MAP;
    }

    private static class LocalVariableTableVisitor
    extends MethodVisitor {
        private static final String CONSTRUCTOR = "<init>";
        private final Class<?> clazz;
        private final Map<Member, String[]> memberMap;
        private final String name;
        private final Type[] args;
        private final String[] parameterNames;
        private final boolean isStatic;
        private boolean hasLvtInfo = false;
        private final int[] lvtSlotIndex;

        public LocalVariableTableVisitor(Class<?> clazz2, Map<Member, String[]> map2, String name, String desc, boolean isStatic) {
            super(393216);
            this.clazz = clazz2;
            this.memberMap = map2;
            this.name = name;
            this.args = Type.getArgumentTypes(desc);
            this.parameterNames = new String[this.args.length];
            this.isStatic = isStatic;
            this.lvtSlotIndex = LocalVariableTableVisitor.computeLvtSlotIndices(isStatic, this.args);
        }

        @Override
        public void visitLocalVariable(String name, String description, String signature2, Label start, Label end, int index2) {
            this.hasLvtInfo = true;
            for (int i = 0; i < this.lvtSlotIndex.length; ++i) {
                if (this.lvtSlotIndex[i] != index2) continue;
                this.parameterNames[i] = name;
            }
        }

        @Override
        public void visitEnd() {
            if (this.hasLvtInfo || this.isStatic && this.parameterNames.length == 0) {
                this.memberMap.put(this.resolveMember(), this.parameterNames);
            }
        }

        private Member resolveMember() {
            ClassLoader loader = this.clazz.getClassLoader();
            Class[] argTypes = new Class[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                argTypes[i] = ClassUtils.resolveClassName(this.args[i].getClassName(), loader);
            }
            try {
                if (CONSTRUCTOR.equals(this.name)) {
                    return this.clazz.getDeclaredConstructor(argTypes);
                }
                return this.clazz.getDeclaredMethod(this.name, argTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Method [" + this.name + "] was discovered in the .class file but cannot be resolved in the class object", ex);
            }
        }

        private static int[] computeLvtSlotIndices(boolean isStatic, Type[] paramTypes2) {
            int[] lvtIndex = new int[paramTypes2.length];
            int nextIndex = isStatic ? 0 : 1;
            for (int i = 0; i < paramTypes2.length; ++i) {
                lvtIndex[i] = nextIndex++;
                if (!LocalVariableTableVisitor.isWideType(paramTypes2[i])) continue;
                nextIndex += 2;
            }
            return lvtIndex;
        }

        private static boolean isWideType(Type aType) {
            return aType == Type.LONG_TYPE || aType == Type.DOUBLE_TYPE;
        }
    }

    private static class ParameterNameDiscoveringVisitor
    extends ClassVisitor {
        private static final String STATIC_CLASS_INIT = "<clinit>";
        private final Class<?> clazz;
        private final Map<Member, String[]> memberMap;

        public ParameterNameDiscoveringVisitor(Class<?> clazz2, Map<Member, String[]> memberMap) {
            super(393216);
            this.clazz = clazz2;
            this.memberMap = memberMap;
        }

        @Override
        public MethodVisitor visitMethod(int access2, String name, String desc, String signature2, String[] exceptions2) {
            if (!ParameterNameDiscoveringVisitor.isSyntheticOrBridged(access2) && !STATIC_CLASS_INIT.equals(name)) {
                return new LocalVariableTableVisitor(this.clazz, this.memberMap, name, desc, ParameterNameDiscoveringVisitor.isStatic(access2));
            }
            return null;
        }

        private static boolean isSyntheticOrBridged(int access2) {
            return (access2 & 0x1000 | access2 & 0x40) > 0;
        }

        private static boolean isStatic(int access2) {
            return (access2 & 8) > 0;
        }
    }
}

