/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public abstract class GenericTypeResolver {
    private static final Map<Class<?>, Map<TypeVariable, Type>> typeVariableCache = new ConcurrentReferenceHashMap();

    @Deprecated
    public static Type getTargetType(MethodParameter methodParameter) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        return methodParameter.getGenericParameterType();
    }

    public static Class<?> resolveParameterType(MethodParameter methodParameter, Class<?> implementationClass) {
        Assert.notNull(methodParameter, "MethodParameter must not be null");
        Assert.notNull(implementationClass, "Class must not be null");
        methodParameter.setContainingClass(implementationClass);
        ResolvableType.resolveMethodParameter(methodParameter);
        return methodParameter.getParameterType();
    }

    public static Class<?> resolveReturnType(Method method, Class<?> clazz2) {
        Assert.notNull(method, "Method must not be null");
        Assert.notNull(clazz2, "Class must not be null");
        return ResolvableType.forMethodReturnType(method, clazz2).resolve(method.getReturnType());
    }

    @Deprecated
    public static Class<?> resolveReturnTypeForGenericMethod(Method method, Object[] args2, ClassLoader classLoader) {
        Assert.notNull(method, "Method must not be null");
        Assert.notNull(args2, "Argument array must not be null");
        TypeVariable<Method>[] declaredTypeVariables = method.getTypeParameters();
        Type genericReturnType = method.getGenericReturnType();
        Type[] methodArgumentTypes = method.getGenericParameterTypes();
        if (declaredTypeVariables.length == 0) {
            return method.getReturnType();
        }
        if (args2.length < methodArgumentTypes.length) {
            return null;
        }
        boolean locallyDeclaredTypeVariableMatchesReturnType = false;
        for (TypeVariable<Method> currentTypeVariable : declaredTypeVariables) {
            if (!currentTypeVariable.equals(genericReturnType)) continue;
            locallyDeclaredTypeVariableMatchesReturnType = true;
            break;
        }
        if (locallyDeclaredTypeVariableMatchesReturnType) {
            for (int i = 0; i < methodArgumentTypes.length; ++i) {
                Type[] actualTypeArguments;
                Type currentMethodArgumentType = methodArgumentTypes[i];
                if (currentMethodArgumentType.equals(genericReturnType)) {
                    return args2[i].getClass();
                }
                if (!(currentMethodArgumentType instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)currentMethodArgumentType;
                for (Type typeArg : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                    if (!typeArg.equals(genericReturnType)) continue;
                    Object arg = args2[i];
                    if (arg instanceof Class) {
                        return (Class)arg;
                    }
                    if (arg instanceof String && classLoader != null) {
                        try {
                            return classLoader.loadClass((String)arg);
                        }
                        catch (ClassNotFoundException ex) {
                            throw new IllegalStateException("Could not resolve specific class name argument [" + arg + "]", ex);
                        }
                    }
                    return method.getReturnType();
                }
            }
        }
        return method.getReturnType();
    }

    public static Class<?> resolveReturnTypeArgument(Method method, Class<?> genericIfc) {
        Assert.notNull(method, "method must not be null");
        ResolvableType resolvableType = ResolvableType.forMethodReturnType(method).as(genericIfc);
        if (!resolvableType.hasGenerics() || resolvableType.getType() instanceof WildcardType) {
            return null;
        }
        return GenericTypeResolver.getSingleGeneric(resolvableType);
    }

    public static Class<?> resolveTypeArgument(Class<?> clazz2, Class<?> genericIfc) {
        ResolvableType resolvableType = ResolvableType.forClass(clazz2).as(genericIfc);
        if (!resolvableType.hasGenerics()) {
            return null;
        }
        return GenericTypeResolver.getSingleGeneric(resolvableType);
    }

    private static Class<?> getSingleGeneric(ResolvableType resolvableType) {
        if (resolvableType.getGenerics().length > 1) {
            throw new IllegalArgumentException("Expected 1 type argument on generic interface [" + resolvableType + "] but found " + resolvableType.getGenerics().length);
        }
        return resolvableType.getGeneric(new int[0]).resolve();
    }

    public static Class<?>[] resolveTypeArguments(Class<?> clazz2, Class<?> genericIfc) {
        ResolvableType type = ResolvableType.forClass(clazz2).as(genericIfc);
        if (!type.hasGenerics() || type.isEntirelyUnresolvable()) {
            return null;
        }
        return type.resolveGenerics(Object.class);
    }

    public static Class<?> resolveType(Type genericType, Map<TypeVariable, Type> map2) {
        return ResolvableType.forType(genericType, new TypeVariableMapVariableResolver(map2)).resolve(Object.class);
    }

    public static Map<TypeVariable, Type> getTypeVariableMap(Class<?> clazz2) {
        Map<TypeVariable, Type> typeVariableMap = typeVariableCache.get(clazz2);
        if (typeVariableMap == null) {
            typeVariableMap = new HashMap<TypeVariable, Type>();
            GenericTypeResolver.buildTypeVariableMap(ResolvableType.forClass(clazz2), typeVariableMap);
            typeVariableCache.put(clazz2, Collections.unmodifiableMap(typeVariableMap));
        }
        return typeVariableMap;
    }

    private static void buildTypeVariableMap(ResolvableType type, Map<TypeVariable, Type> typeVariableMap) {
        if (type != ResolvableType.NONE) {
            if (type.getType() instanceof ParameterizedType) {
                TypeVariable<Class<?>>[] variables = type.resolve().getTypeParameters();
                for (int i = 0; i < variables.length; ++i) {
                    ResolvableType generic = type.getGeneric(i);
                    while (generic.getType() instanceof TypeVariable) {
                        generic = generic.resolveType();
                    }
                    if (generic == ResolvableType.NONE) continue;
                    typeVariableMap.put(variables[i], generic.getType());
                }
            }
            GenericTypeResolver.buildTypeVariableMap(type.getSuperType(), typeVariableMap);
            for (ResolvableType interfaceType : type.getInterfaces()) {
                GenericTypeResolver.buildTypeVariableMap(interfaceType, typeVariableMap);
            }
            if (type.resolve().isMemberClass()) {
                GenericTypeResolver.buildTypeVariableMap(ResolvableType.forClass(type.resolve().getEnclosingClass()), typeVariableMap);
            }
        }
    }

    private static class TypeVariableMapVariableResolver
    implements ResolvableType.VariableResolver {
        private final Map<TypeVariable, Type> typeVariableMap;

        public TypeVariableMapVariableResolver(Map<TypeVariable, Type> typeVariableMap) {
            this.typeVariableMap = typeVariableMap;
        }

        @Override
        public ResolvableType resolveVariable(TypeVariable<?> variable) {
            Type type = this.typeVariableMap.get(variable);
            return type != null ? ResolvableType.forType(type) : null;
        }

        @Override
        public Object getSource() {
            return this.typeVariableMap;
        }
    }
}

