/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessageSourceAccessor {
    private final MessageSource messageSource;
    private final Locale defaultLocale;

    public MessageSourceAccessor(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.defaultLocale = null;
    }

    public MessageSourceAccessor(MessageSource messageSource, Locale defaultLocale) {
        this.messageSource = messageSource;
        this.defaultLocale = defaultLocale;
    }

    protected Locale getDefaultLocale() {
        return this.defaultLocale != null ? this.defaultLocale : LocaleContextHolder.getLocale();
    }

    public String getMessage(String code2, String defaultMessage) {
        return this.messageSource.getMessage(code2, null, defaultMessage, this.getDefaultLocale());
    }

    public String getMessage(String code2, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code2, null, defaultMessage, locale);
    }

    public String getMessage(String code2, Object[] args2, String defaultMessage) {
        return this.messageSource.getMessage(code2, args2, defaultMessage, this.getDefaultLocale());
    }

    public String getMessage(String code2, Object[] args2, String defaultMessage, Locale locale) {
        return this.messageSource.getMessage(code2, args2, defaultMessage, locale);
    }

    public String getMessage(String code2) throws NoSuchMessageException {
        return this.messageSource.getMessage(code2, null, this.getDefaultLocale());
    }

    public String getMessage(String code2, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(code2, null, locale);
    }

    public String getMessage(String code2, Object[] args2) throws NoSuchMessageException {
        return this.messageSource.getMessage(code2, args2, this.getDefaultLocale());
    }

    public String getMessage(String code2, Object[] args2, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(code2, args2, locale);
    }

    public String getMessage(MessageSourceResolvable resolvable) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, this.getDefaultLocale());
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        return this.messageSource.getMessage(resolvable, locale);
    }
}

