/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.util;

abstract class SorterTemplate {
    private static final int MERGESORT_THRESHOLD = 12;
    private static final int QUICKSORT_THRESHOLD = 7;

    SorterTemplate() {
    }

    protected abstract void swap(int var1, int var2);

    protected abstract int compare(int var1, int var2);

    protected void quickSort(int lo2, int hi2) {
        this.quickSortHelper(lo2, hi2);
        this.insertionSort(lo2, hi2);
    }

    private void quickSortHelper(int lo2, int hi2) {
        int diff2;
        while ((diff2 = hi2 - lo2) > 7) {
            int i = (hi2 + lo2) / 2;
            if (this.compare(lo2, i) > 0) {
                this.swap(lo2, i);
            }
            if (this.compare(lo2, hi2) > 0) {
                this.swap(lo2, hi2);
            }
            if (this.compare(i, hi2) > 0) {
                this.swap(i, hi2);
            }
            int j = hi2 - 1;
            this.swap(i, j);
            i = lo2;
            int v = j;
            while (true) {
                if (this.compare(++i, v) < 0) {
                    continue;
                }
                while (this.compare(--j, v) > 0) {
                }
                if (j < i) break;
                this.swap(i, j);
            }
            this.swap(i, hi2 - 1);
            if (j - lo2 <= hi2 - i + 1) {
                this.quickSortHelper(lo2, j);
                lo2 = i + 1;
                continue;
            }
            this.quickSortHelper(i + 1, hi2);
            hi2 = j;
        }
    }

    private void insertionSort(int lo2, int hi2) {
        for (int i = lo2 + 1; i <= hi2; ++i) {
            for (int j = i; j > lo2 && this.compare(j - 1, j) > 0; --j) {
                this.swap(j - 1, j);
            }
        }
    }

    protected void mergeSort(int lo2, int hi2) {
        int diff2 = hi2 - lo2;
        if (diff2 <= 12) {
            this.insertionSort(lo2, hi2);
            return;
        }
        int mid = lo2 + diff2 / 2;
        this.mergeSort(lo2, mid);
        this.mergeSort(mid, hi2);
        this.merge(lo2, mid, hi2, mid - lo2, hi2 - mid);
    }

    private void merge(int lo2, int pivot, int hi2, int len1, int len2) {
        int len22;
        int second_cut;
        int first_cut;
        int len11;
        if (len1 == 0 || len2 == 0) {
            return;
        }
        if (len1 + len2 == 2) {
            if (this.compare(pivot, lo2) < 0) {
                this.swap(pivot, lo2);
            }
            return;
        }
        if (len1 > len2) {
            len11 = len1 / 2;
            first_cut = lo2 + len11;
            second_cut = this.lower(pivot, hi2, first_cut);
            len22 = second_cut - pivot;
        } else {
            len22 = len2 / 2;
            second_cut = pivot + len22;
            first_cut = this.upper(lo2, pivot, second_cut);
            len11 = first_cut - lo2;
        }
        this.rotate(first_cut, pivot, second_cut);
        int new_mid = first_cut + len22;
        this.merge(lo2, first_cut, new_mid, len11, len22);
        this.merge(new_mid, second_cut, hi2, len1 - len11, len2 - len22);
    }

    private void rotate(int lo2, int mid, int hi2) {
        int lot = lo2;
        int hit = mid - 1;
        while (lot < hit) {
            this.swap(lot++, hit--);
        }
        lot = mid;
        hit = hi2 - 1;
        while (lot < hit) {
            this.swap(lot++, hit--);
        }
        lot = lo2;
        hit = hi2 - 1;
        while (lot < hit) {
            this.swap(lot++, hit--);
        }
    }

    private int lower(int lo2, int hi2, int val) {
        int len = hi2 - lo2;
        while (len > 0) {
            int half = len / 2;
            int mid = lo2 + half;
            if (this.compare(mid, val) < 0) {
                lo2 = mid + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return lo2;
    }

    private int upper(int lo2, int hi2, int val) {
        int len = hi2 - lo2;
        while (len > 0) {
            int half = len / 2;
            int mid = lo2 + half;
            if (this.compare(val, mid) < 0) {
                len = half;
                continue;
            }
            lo2 = mid + 1;
            len = len - half - 1;
        }
        return lo2;
    }
}

