/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.cglib.core.Signature;

class BridgeMethodResolver {
    private final Map declToBridge;
    private final ClassLoader classLoader;

    public BridgeMethodResolver(Map declToBridge, ClassLoader classLoader) {
        this.declToBridge = declToBridge;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map resolveAll() {
        HashMap resolved = new HashMap();
        for (Map.Entry entry2 : this.declToBridge.entrySet()) {
            Class owner2 = (Class)entry2.getKey();
            Set bridges = (Set)entry2.getValue();
            try {
                InputStream is = this.classLoader.getResourceAsStream(owner2.getName().replace('.', '/') + ".class");
                if (is == null) {
                    return resolved;
                }
                try {
                    new ClassReader(is).accept(new BridgedFinder(bridges, resolved), 6);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return resolved;
    }

    private static class BridgedFinder
    extends ClassVisitor {
        private Map resolved;
        private Set eligibleMethods;
        private Signature currentMethod = null;

        BridgedFinder(Set eligibleMethods, Map resolved) {
            super(393216);
            this.resolved = resolved;
            this.eligibleMethods = eligibleMethods;
        }

        public void visit(int version, int access2, String name, String signature2, String superName, String[] interfaces2) {
        }

        public MethodVisitor visitMethod(int access2, String name, String desc, String signature2, String[] exceptions2) {
            Signature sig2 = new Signature(name, desc);
            if (this.eligibleMethods.remove(sig2)) {
                this.currentMethod = sig2;
                return new MethodVisitor(393216){

                    public void visitMethodInsn(int opcode, String owner2, String name, String desc, boolean itf) {
                        if (opcode == 183 && BridgedFinder.this.currentMethod != null) {
                            Signature target = new Signature(name, desc);
                            if (!target.equals(BridgedFinder.this.currentMethod)) {
                                BridgedFinder.this.resolved.put(BridgedFinder.this.currentMethod, target);
                            }
                            BridgedFinder.this.currentMethod = null;
                        }
                    }
                };
            }
            return null;
        }
    }
}

