/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cglib.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.asm.Type;
import org.springframework.cglib.core.CollectionUtils;
import org.springframework.cglib.core.Constants;
import org.springframework.cglib.core.MethodInfo;
import org.springframework.cglib.core.Signature;

public class TypeUtils {
    private static final Map transforms = new HashMap();
    private static final Map rtransforms = new HashMap();

    private TypeUtils() {
    }

    public static Type getType(String className) {
        return Type.getType("L" + className.replace('.', '/') + ";");
    }

    public static boolean isFinal(int access2) {
        return (0x10 & access2) != 0;
    }

    public static boolean isStatic(int access2) {
        return (8 & access2) != 0;
    }

    public static boolean isProtected(int access2) {
        return (4 & access2) != 0;
    }

    public static boolean isPublic(int access2) {
        return (1 & access2) != 0;
    }

    public static boolean isAbstract(int access2) {
        return (0x400 & access2) != 0;
    }

    public static boolean isInterface(int access2) {
        return (0x200 & access2) != 0;
    }

    public static boolean isPrivate(int access2) {
        return (2 & access2) != 0;
    }

    public static boolean isSynthetic(int access2) {
        return (0x1000 & access2) != 0;
    }

    public static boolean isBridge(int access2) {
        return (0x40 & access2) != 0;
    }

    public static String getPackageName(Type type) {
        return TypeUtils.getPackageName(TypeUtils.getClassName(type));
    }

    public static String getPackageName(String className) {
        int idx = className.lastIndexOf(46);
        return idx < 0 ? "" : className.substring(0, idx);
    }

    public static String upperFirst(String s2) {
        if (s2 == null || s2.length() == 0) {
            return s2;
        }
        return Character.toUpperCase(s2.charAt(0)) + s2.substring(1);
    }

    public static String getClassName(Type type) {
        if (TypeUtils.isPrimitive(type)) {
            return (String)rtransforms.get(type.getDescriptor());
        }
        if (TypeUtils.isArray(type)) {
            return TypeUtils.getClassName(TypeUtils.getComponentType(type)) + "[]";
        }
        return type.getClassName();
    }

    public static Type[] add(Type[] types2, Type extra) {
        if (types2 == null) {
            return new Type[]{extra};
        }
        List<Type> list2 = Arrays.asList(types2);
        if (list2.contains(extra)) {
            return types2;
        }
        Type[] copy2 = new Type[types2.length + 1];
        System.arraycopy(types2, 0, copy2, 0, types2.length);
        copy2[types2.length] = extra;
        return copy2;
    }

    public static Type[] add(Type[] t1, Type[] t2) {
        Type[] all = new Type[t1.length + t2.length];
        System.arraycopy(t1, 0, all, 0, t1.length);
        System.arraycopy(t2, 0, all, t1.length, t2.length);
        return all;
    }

    public static Type fromInternalName(String name) {
        return Type.getType("L" + name + ";");
    }

    public static Type[] fromInternalNames(String[] names) {
        if (names == null) {
            return null;
        }
        Type[] types2 = new Type[names.length];
        for (int i = 0; i < names.length; ++i) {
            types2[i] = TypeUtils.fromInternalName(names[i]);
        }
        return types2;
    }

    public static int getStackSize(Type[] types2) {
        int size2 = 0;
        for (int i = 0; i < types2.length; ++i) {
            size2 += types2[i].getSize();
        }
        return size2;
    }

    public static String[] toInternalNames(Type[] types2) {
        if (types2 == null) {
            return null;
        }
        String[] names = new String[types2.length];
        for (int i = 0; i < types2.length; ++i) {
            names[i] = types2[i].getInternalName();
        }
        return names;
    }

    public static Signature parseSignature(String s2) {
        int space = s2.indexOf(32);
        int lparen = s2.indexOf(40, space);
        int rparen = s2.indexOf(41, lparen);
        String returnType = s2.substring(0, space);
        String methodName = s2.substring(space + 1, lparen);
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        Iterator it = TypeUtils.parseTypes(s2, lparen + 1, rparen).iterator();
        while (it.hasNext()) {
            sb.append(it.next());
        }
        sb.append(')');
        sb.append(TypeUtils.map(returnType));
        return new Signature(methodName, sb.toString());
    }

    public static Type parseType(String s2) {
        return Type.getType(TypeUtils.map(s2));
    }

    public static Type[] parseTypes(String s2) {
        List names = TypeUtils.parseTypes(s2, 0, s2.length());
        Type[] types2 = new Type[names.size()];
        for (int i = 0; i < types2.length; ++i) {
            types2[i] = Type.getType((String)names.get(i));
        }
        return types2;
    }

    public static Signature parseConstructor(Type[] types2) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < types2.length; ++i) {
            sb.append(types2[i].getDescriptor());
        }
        sb.append(")");
        sb.append("V");
        return new Signature("<init>", sb.toString());
    }

    public static Signature parseConstructor(String sig2) {
        return TypeUtils.parseSignature("void <init>(" + sig2 + ")");
    }

    private static List parseTypes(String s2, int mark2, int end) {
        int next2;
        ArrayList<String> types2 = new ArrayList<String>(5);
        while ((next2 = s2.indexOf(44, mark2)) >= 0) {
            types2.add(TypeUtils.map(s2.substring(mark2, next2).trim()));
            mark2 = next2 + 1;
        }
        types2.add(TypeUtils.map(s2.substring(mark2, end).trim()));
        return types2;
    }

    private static String map(String type) {
        if (type.equals("")) {
            return type;
        }
        String t = (String)transforms.get(type);
        if (t != null) {
            return t;
        }
        if (type.indexOf(46) < 0) {
            return TypeUtils.map("java.lang." + type);
        }
        StringBuffer sb = new StringBuffer();
        int index2 = 0;
        while ((index2 = type.indexOf("[]", index2) + 1) > 0) {
            sb.append('[');
        }
        type = type.substring(0, type.length() - sb.length() * 2);
        sb.append('L').append(type.replace('.', '/')).append(';');
        return sb.toString();
    }

    public static Type getBoxedType(Type type) {
        switch (type.getSort()) {
            case 2: {
                return Constants.TYPE_CHARACTER;
            }
            case 1: {
                return Constants.TYPE_BOOLEAN;
            }
            case 8: {
                return Constants.TYPE_DOUBLE;
            }
            case 6: {
                return Constants.TYPE_FLOAT;
            }
            case 7: {
                return Constants.TYPE_LONG;
            }
            case 5: {
                return Constants.TYPE_INTEGER;
            }
            case 4: {
                return Constants.TYPE_SHORT;
            }
            case 3: {
                return Constants.TYPE_BYTE;
            }
        }
        return type;
    }

    public static Type getUnboxedType(Type type) {
        if (Constants.TYPE_INTEGER.equals(type)) {
            return Type.INT_TYPE;
        }
        if (Constants.TYPE_BOOLEAN.equals(type)) {
            return Type.BOOLEAN_TYPE;
        }
        if (Constants.TYPE_DOUBLE.equals(type)) {
            return Type.DOUBLE_TYPE;
        }
        if (Constants.TYPE_LONG.equals(type)) {
            return Type.LONG_TYPE;
        }
        if (Constants.TYPE_CHARACTER.equals(type)) {
            return Type.CHAR_TYPE;
        }
        if (Constants.TYPE_BYTE.equals(type)) {
            return Type.BYTE_TYPE;
        }
        if (Constants.TYPE_FLOAT.equals(type)) {
            return Type.FLOAT_TYPE;
        }
        if (Constants.TYPE_SHORT.equals(type)) {
            return Type.SHORT_TYPE;
        }
        return type;
    }

    public static boolean isArray(Type type) {
        return type.getSort() == 9;
    }

    public static Type getComponentType(Type type) {
        if (!TypeUtils.isArray(type)) {
            throw new IllegalArgumentException("Type " + type + " is not an array");
        }
        return Type.getType(type.getDescriptor().substring(1));
    }

    public static boolean isPrimitive(Type type) {
        switch (type.getSort()) {
            case 9: 
            case 10: {
                return false;
            }
        }
        return true;
    }

    public static String emulateClassGetName(Type type) {
        if (TypeUtils.isArray(type)) {
            return type.getDescriptor().replace('/', '.');
        }
        return TypeUtils.getClassName(type);
    }

    public static boolean isConstructor(MethodInfo method) {
        return method.getSignature().getName().equals("<init>");
    }

    public static Type[] getTypes(Class[] classes2) {
        if (classes2 == null) {
            return null;
        }
        Type[] types2 = new Type[classes2.length];
        for (int i = 0; i < classes2.length; ++i) {
            types2[i] = Type.getType(classes2[i]);
        }
        return types2;
    }

    public static int ICONST(int value2) {
        switch (value2) {
            case -1: {
                return 2;
            }
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 8;
            }
        }
        return -1;
    }

    public static int LCONST(long value2) {
        if (value2 == 0L) {
            return 9;
        }
        if (value2 == 1L) {
            return 10;
        }
        return -1;
    }

    public static int FCONST(float value2) {
        if (value2 == 0.0f) {
            return 11;
        }
        if (value2 == 1.0f) {
            return 12;
        }
        if (value2 == 2.0f) {
            return 13;
        }
        return -1;
    }

    public static int DCONST(double value2) {
        if (value2 == 0.0) {
            return 14;
        }
        if (value2 == 1.0) {
            return 15;
        }
        return -1;
    }

    public static int NEWARRAY(Type type) {
        switch (type.getSort()) {
            case 3: {
                return 8;
            }
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 6: {
                return 6;
            }
            case 5: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 4: {
                return 9;
            }
            case 1: {
                return 4;
            }
        }
        return -1;
    }

    public static String escapeType(String s2) {
        StringBuffer sb = new StringBuffer();
        int len = s2.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = s2.charAt(i);
            switch (c) {
                case '$': {
                    sb.append("$24");
                    continue block9;
                }
                case '.': {
                    sb.append("$2E");
                    continue block9;
                }
                case '[': {
                    sb.append("$5B");
                    continue block9;
                }
                case ';': {
                    sb.append("$3B");
                    continue block9;
                }
                case '(': {
                    sb.append("$28");
                    continue block9;
                }
                case ')': {
                    sb.append("$29");
                    continue block9;
                }
                case '/': {
                    sb.append("$2F");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static {
        transforms.put("void", "V");
        transforms.put("byte", "B");
        transforms.put("char", "C");
        transforms.put("double", "D");
        transforms.put("float", "F");
        transforms.put("int", "I");
        transforms.put("long", "J");
        transforms.put("short", "S");
        transforms.put("boolean", "Z");
        CollectionUtils.reverse(transforms, rtransforms);
    }
}

