/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SimpleInstantiationStrategy
implements InstantiationStrategy {
    private static final ThreadLocal<Method> currentlyInvokedFactoryMethod = new ThreadLocal();

    public static Method getCurrentlyInvokedFactoryMethod() {
        return currentlyInvokedFactoryMethod.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object instantiate(RootBeanDefinition bd, String beanName, BeanFactory owner2) {
        if (bd.getMethodOverrides().isEmpty()) {
            Constructor constructorToUse;
            Object object = bd.constructorArgumentLock;
            synchronized (object) {
                constructorToUse = (Constructor)bd.resolvedConstructorOrFactoryMethod;
                if (constructorToUse == null) {
                    final Class<?> clazz2 = bd.getBeanClass();
                    if (clazz2.isInterface()) {
                        throw new BeanInstantiationException(clazz2, "Specified class is an interface");
                    }
                    try {
                        constructorToUse = System.getSecurityManager() != null ? (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                            @Override
                            public Constructor<?> run() throws Exception {
                                return clazz2.getDeclaredConstructor(null);
                            }
                        }) : clazz2.getDeclaredConstructor(null);
                        bd.resolvedConstructorOrFactoryMethod = constructorToUse;
                    }
                    catch (Throwable ex) {
                        throw new BeanInstantiationException(clazz2, "No default constructor found", ex);
                    }
                }
            }
            return BeanUtils.instantiateClass(constructorToUse, new Object[0]);
        }
        return this.instantiateWithMethodInjection(bd, beanName, owner2);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition bd, String beanName, BeanFactory owner2) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    @Override
    public Object instantiate(RootBeanDefinition bd, String beanName, BeanFactory owner2, final Constructor<?> ctor, Object ... args2) {
        if (bd.getMethodOverrides().isEmpty()) {
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        ReflectionUtils.makeAccessible(ctor);
                        return null;
                    }
                });
            }
            return BeanUtils.instantiateClass(ctor, args2);
        }
        return this.instantiateWithMethodInjection(bd, beanName, owner2, ctor, args2);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition bd, String beanName, BeanFactory owner2, Constructor<?> ctor, Object ... args2) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object instantiate(RootBeanDefinition bd, String beanName, BeanFactory owner2, Object factoryBean, final Method factoryMethod, Object ... args2) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ReflectionUtils.makeAccessible(factoryMethod);
                    return null;
                }
            });
        } else {
            ReflectionUtils.makeAccessible(factoryMethod);
        }
        Method priorInvokedFactoryMethod = currentlyInvokedFactoryMethod.get();
        try {
            currentlyInvokedFactoryMethod.set(factoryMethod);
            Object object = factoryMethod.invoke(factoryBean, args2);
            if (priorInvokedFactoryMethod != null) {
                currentlyInvokedFactoryMethod.set(priorInvokedFactoryMethod);
            } else {
                currentlyInvokedFactoryMethod.remove();
            }
            return object;
        }
        catch (Throwable throwable2) {
            try {
                if (priorInvokedFactoryMethod != null) {
                    currentlyInvokedFactoryMethod.set(priorInvokedFactoryMethod);
                } else {
                    currentlyInvokedFactoryMethod.remove();
                }
                throw throwable2;
            }
            catch (IllegalArgumentException ex) {
                throw new BeanInstantiationException(factoryMethod, "Illegal arguments to factory method '" + factoryMethod.getName() + "'; args: " + StringUtils.arrayToCommaDelimitedString(args2), (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw new BeanInstantiationException(factoryMethod, "Cannot access factory method '" + factoryMethod.getName() + "'; is it public?", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                String msg = "Factory method '" + factoryMethod.getName() + "' threw exception";
                if (bd.getFactoryBeanName() != null && owner2 instanceof ConfigurableBeanFactory && ((ConfigurableBeanFactory)owner2).isCurrentlyInCreation(bd.getFactoryBeanName())) {
                    msg = "Circular reference involving containing bean '" + bd.getFactoryBeanName() + "' - consider declaring the factory method as static for independence from its containing instance. " + msg;
                }
                throw new BeanInstantiationException(factoryMethod, msg, ex.getTargetException());
            }
        }
    }
}

