/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanNameReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.ManagedArray;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class BeanDefinitionValueResolver {
    private final AbstractBeanFactory beanFactory;
    private final String beanName;
    private final BeanDefinition beanDefinition;
    private final TypeConverter typeConverter;

    public BeanDefinitionValueResolver(AbstractBeanFactory beanFactory, String beanName, BeanDefinition beanDefinition, TypeConverter typeConverter) {
        this.beanFactory = beanFactory;
        this.beanName = beanName;
        this.beanDefinition = beanDefinition;
        this.typeConverter = typeConverter;
    }

    public Object resolveValueIfNecessary(Object argName, Object value2) {
        if (value2 instanceof RuntimeBeanReference) {
            RuntimeBeanReference ref2 = (RuntimeBeanReference)value2;
            return this.resolveReference(argName, ref2);
        }
        if (value2 instanceof RuntimeBeanNameReference) {
            String refName = ((RuntimeBeanNameReference)value2).getBeanName();
            if (!this.beanFactory.containsBean(refName = String.valueOf(this.doEvaluate(refName)))) {
                throw new BeanDefinitionStoreException("Invalid bean name '" + refName + "' in bean reference for " + argName);
            }
            return refName;
        }
        if (value2 instanceof BeanDefinitionHolder) {
            BeanDefinitionHolder bdHolder = (BeanDefinitionHolder)value2;
            return this.resolveInnerBean(argName, bdHolder.getBeanName(), bdHolder.getBeanDefinition());
        }
        if (value2 instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)value2;
            String innerBeanName = "(inner bean)#" + ObjectUtils.getIdentityHexString(bd);
            return this.resolveInnerBean(argName, innerBeanName, bd);
        }
        if (value2 instanceof ManagedArray) {
            ManagedArray array = (ManagedArray)value2;
            Class<Object> elementType2 = array.resolvedElementType;
            if (elementType2 == null) {
                String elementTypeName = array.getElementTypeName();
                if (StringUtils.hasText(elementTypeName)) {
                    try {
                        array.resolvedElementType = elementType2 = ClassUtils.forName(elementTypeName, this.beanFactory.getBeanClassLoader());
                    }
                    catch (Throwable ex) {
                        throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Error resolving array type for " + argName, ex);
                    }
                } else {
                    elementType2 = Object.class;
                }
            }
            return this.resolveManagedArray(argName, (List)value2, elementType2);
        }
        if (value2 instanceof ManagedList) {
            return this.resolveManagedList(argName, (List)value2);
        }
        if (value2 instanceof ManagedSet) {
            return this.resolveManagedSet(argName, (Set)value2);
        }
        if (value2 instanceof ManagedMap) {
            return this.resolveManagedMap(argName, (Map)value2);
        }
        if (value2 instanceof ManagedProperties) {
            Properties original = (Properties)value2;
            Properties copy2 = new Properties();
            for (Map.Entry<Object, Object> propEntry : original.entrySet()) {
                Object propKey = propEntry.getKey();
                Object propValue = propEntry.getValue();
                if (propKey instanceof TypedStringValue) {
                    propKey = this.evaluate((TypedStringValue)propKey);
                }
                if (propValue instanceof TypedStringValue) {
                    propValue = this.evaluate((TypedStringValue)propValue);
                }
                copy2.put(propKey, propValue);
            }
            return copy2;
        }
        if (value2 instanceof TypedStringValue) {
            TypedStringValue typedStringValue = (TypedStringValue)value2;
            Object valueObject = this.evaluate(typedStringValue);
            try {
                Class<?> resolvedTargetType = this.resolveTargetType(typedStringValue);
                if (resolvedTargetType != null) {
                    return this.typeConverter.convertIfNecessary(valueObject, resolvedTargetType);
                }
                return valueObject;
            }
            catch (Throwable ex) {
                throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Error converting typed String value for " + argName, ex);
            }
        }
        return this.evaluate(value2);
    }

    protected Object evaluate(TypedStringValue value2) {
        Object result2 = this.doEvaluate(value2.getValue());
        if (!ObjectUtils.nullSafeEquals(result2, value2.getValue())) {
            value2.setDynamic();
        }
        return result2;
    }

    protected Object evaluate(Object value2) {
        if (value2 instanceof String) {
            return this.doEvaluate((String)value2);
        }
        if (value2 instanceof String[]) {
            String[] values2 = (String[])value2;
            boolean actuallyResolved = false;
            Object[] resolvedValues = new Object[values2.length];
            for (int i = 0; i < values2.length; ++i) {
                String originalValue = values2[i];
                Object resolvedValue = this.doEvaluate(originalValue);
                if (resolvedValue != originalValue) {
                    actuallyResolved = true;
                }
                resolvedValues[i] = resolvedValue;
            }
            return actuallyResolved ? resolvedValues : values2;
        }
        return value2;
    }

    private Object doEvaluate(String value2) {
        return this.beanFactory.evaluateBeanDefinitionString(value2, this.beanDefinition);
    }

    protected Class<?> resolveTargetType(TypedStringValue value2) throws ClassNotFoundException {
        if (value2.hasTargetType()) {
            return value2.getTargetType();
        }
        return value2.resolveTargetType(this.beanFactory.getBeanClassLoader());
    }

    private Object resolveInnerBean(Object argName, String innerBeanName, BeanDefinition innerBd) {
        RootBeanDefinition mbd = null;
        try {
            Object innerBean;
            mbd = this.beanFactory.getMergedBeanDefinition(innerBeanName, innerBd, this.beanDefinition);
            String actualInnerBeanName = innerBeanName;
            if (mbd.isSingleton()) {
                actualInnerBeanName = this.adaptInnerBeanName(innerBeanName);
            }
            this.beanFactory.registerContainedBean(actualInnerBeanName, this.beanName);
            String[] dependsOn = mbd.getDependsOn();
            if (dependsOn != null) {
                for (String dependsOnBean : dependsOn) {
                    this.beanFactory.registerDependentBean(dependsOnBean, actualInnerBeanName);
                    this.beanFactory.getBean(dependsOnBean);
                }
            }
            if ((innerBean = this.beanFactory.createBean(actualInnerBeanName, mbd, null)) instanceof FactoryBean) {
                boolean synthetic = mbd.isSynthetic();
                return this.beanFactory.getObjectFromFactoryBean((FactoryBean)innerBean, actualInnerBeanName, !synthetic);
            }
            return innerBean;
        }
        catch (BeansException ex) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot create inner bean '" + innerBeanName + "' " + (mbd != null && mbd.getBeanClassName() != null ? "of type [" + mbd.getBeanClassName() + "] " : "") + "while setting " + argName, ex);
        }
    }

    private String adaptInnerBeanName(String innerBeanName) {
        String actualInnerBeanName = innerBeanName;
        int counter = 0;
        while (this.beanFactory.isBeanNameInUse(actualInnerBeanName)) {
            actualInnerBeanName = innerBeanName + "#" + ++counter;
        }
        return actualInnerBeanName;
    }

    private Object resolveReference(Object argName, RuntimeBeanReference ref2) {
        try {
            String refName = ref2.getBeanName();
            refName = String.valueOf(this.doEvaluate(refName));
            if (ref2.isToParent()) {
                if (this.beanFactory.getParentBeanFactory() == null) {
                    throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Can't resolve reference to bean '" + refName + "' in parent factory: no parent factory available");
                }
                return this.beanFactory.getParentBeanFactory().getBean(refName);
            }
            Object bean = this.beanFactory.getBean(refName);
            this.beanFactory.registerDependentBean(refName, this.beanName);
            return bean;
        }
        catch (BeansException ex) {
            throw new BeanCreationException(this.beanDefinition.getResourceDescription(), this.beanName, "Cannot resolve reference to bean '" + ref2.getBeanName() + "' while setting " + argName, ex);
        }
    }

    private Object resolveManagedArray(Object argName, List<?> ml, Class<?> elementType2) {
        Object resolved = Array.newInstance(elementType2, ml.size());
        for (int i = 0; i < ml.size(); ++i) {
            Array.set(resolved, i, this.resolveValueIfNecessary(new KeyedArgName(argName, i), ml.get(i)));
        }
        return resolved;
    }

    private List<?> resolveManagedList(Object argName, List<?> ml) {
        ArrayList<Object> resolved = new ArrayList<Object>(ml.size());
        for (int i = 0; i < ml.size(); ++i) {
            resolved.add(this.resolveValueIfNecessary(new KeyedArgName(argName, i), ml.get(i)));
        }
        return resolved;
    }

    private Set<?> resolveManagedSet(Object argName, Set<?> ms) {
        LinkedHashSet<Object> resolved = new LinkedHashSet<Object>(ms.size());
        int i = 0;
        for (Object m : ms) {
            resolved.add(this.resolveValueIfNecessary(new KeyedArgName(argName, i), m));
            ++i;
        }
        return resolved;
    }

    private Map<?, ?> resolveManagedMap(Object argName, Map<?, ?> mm) {
        LinkedHashMap<Object, Object> resolved = new LinkedHashMap<Object, Object>(mm.size());
        for (Map.Entry<?, ?> entry2 : mm.entrySet()) {
            Object resolvedKey = this.resolveValueIfNecessary(argName, entry2.getKey());
            Object resolvedValue = this.resolveValueIfNecessary(new KeyedArgName(argName, entry2.getKey()), entry2.getValue());
            resolved.put(resolvedKey, resolvedValue);
        }
        return resolved;
    }

    private static class KeyedArgName {
        private final Object argName;
        private final Object key;

        public KeyedArgName(Object argName, Object key) {
            this.argName = argName;
            this.key = key;
        }

        public String toString() {
            return this.argName + " with key " + "[" + this.key + "]";
        }
    }
}

