/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.parsing;

import java.util.ArrayList;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.parsing.ComponentDefinition;

public class BeanComponentDefinition
extends BeanDefinitionHolder
implements ComponentDefinition {
    private BeanDefinition[] innerBeanDefinitions;
    private BeanReference[] beanReferences;

    public BeanComponentDefinition(BeanDefinition beanDefinition, String beanName) {
        super(beanDefinition, beanName);
        this.findInnerBeanDefinitionsAndBeanReferences(beanDefinition);
    }

    public BeanComponentDefinition(BeanDefinition beanDefinition, String beanName, String[] aliases2) {
        super(beanDefinition, beanName, aliases2);
        this.findInnerBeanDefinitionsAndBeanReferences(beanDefinition);
    }

    public BeanComponentDefinition(BeanDefinitionHolder holder) {
        super(holder);
        this.findInnerBeanDefinitionsAndBeanReferences(holder.getBeanDefinition());
    }

    private void findInnerBeanDefinitionsAndBeanReferences(BeanDefinition beanDefinition) {
        ArrayList<BeanDefinition> innerBeans = new ArrayList<BeanDefinition>();
        ArrayList<BeanReference> references = new ArrayList<BeanReference>();
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        for (PropertyValue propertyValue : propertyValues.getPropertyValues()) {
            Object value2 = propertyValue.getValue();
            if (value2 instanceof BeanDefinitionHolder) {
                innerBeans.add(((BeanDefinitionHolder)value2).getBeanDefinition());
                continue;
            }
            if (value2 instanceof BeanDefinition) {
                innerBeans.add((BeanDefinition)value2);
                continue;
            }
            if (!(value2 instanceof BeanReference)) continue;
            references.add((BeanReference)value2);
        }
        this.innerBeanDefinitions = innerBeans.toArray(new BeanDefinition[innerBeans.size()]);
        this.beanReferences = references.toArray(new BeanReference[references.size()]);
    }

    @Override
    public String getName() {
        return this.getBeanName();
    }

    @Override
    public String getDescription() {
        return this.getShortDescription();
    }

    @Override
    public BeanDefinition[] getBeanDefinitions() {
        return new BeanDefinition[]{this.getBeanDefinition()};
    }

    @Override
    public BeanDefinition[] getInnerBeanDefinitions() {
        return this.innerBeanDefinitions;
    }

    @Override
    public BeanReference[] getBeanReferences() {
        return this.beanReferences;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof BeanComponentDefinition && super.equals(other);
    }
}

