/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.core.CollectionFactory;

public class YamlPropertiesFactoryBean
extends YamlProcessor
implements FactoryBean<Properties>,
InitializingBean {
    private boolean singleton = true;
    private Properties properties;

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.isSingleton()) {
            this.properties = this.createProperties();
        }
    }

    @Override
    public Properties getObject() {
        return this.properties != null ? this.properties : this.createProperties();
    }

    @Override
    public Class<?> getObjectType() {
        return Properties.class;
    }

    protected Properties createProperties() {
        final Properties result2 = CollectionFactory.createStringAdaptingProperties();
        this.process(new YamlProcessor.MatchCallback(){

            @Override
            public void process(Properties properties, Map<String, Object> map2) {
                result2.putAll((Map<?, ?>)properties);
            }
        });
        return result2;
    }
}

