/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.YamlProcessor;

public class YamlMapFactoryBean
extends YamlProcessor
implements FactoryBean<Map<String, Object>>,
InitializingBean {
    private boolean singleton = true;
    private Map<String, Object> map;

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.isSingleton()) {
            this.map = this.createMap();
        }
    }

    @Override
    public Map<String, Object> getObject() {
        return this.map != null ? this.map : this.createMap();
    }

    @Override
    public Class<?> getObjectType() {
        return Map.class;
    }

    protected Map<String, Object> createMap() {
        final LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
        this.process(new YamlProcessor.MatchCallback(){

            @Override
            public void process(Properties properties, Map<String, Object> map2) {
                YamlMapFactoryBean.this.merge(result2, map2);
            }
        });
        return result2;
    }

    private void merge(Map<String, Object> output, Map<String, Object> map2) {
        for (Map.Entry<String, Object> entry2 : map2.entrySet()) {
            String key = entry2.getKey();
            Object value2 = entry2.getValue();
            Object existing = output.get(key);
            if (value2 instanceof Map && existing instanceof Map) {
                LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>((Map)existing);
                this.merge(result2, (Map)value2);
                output.put(key, result2);
                continue;
            }
            output.put(key, value2);
        }
    }
}

