/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Properties;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class PreferencesPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements InitializingBean {
    private String systemTreePath;
    private String userTreePath;
    private Preferences systemPrefs;
    private Preferences userPrefs;

    public void setSystemTreePath(String systemTreePath) {
        this.systemTreePath = systemTreePath;
    }

    public void setUserTreePath(String userTreePath) {
        this.userTreePath = userTreePath;
    }

    @Override
    public void afterPropertiesSet() {
        this.systemPrefs = this.systemTreePath != null ? Preferences.systemRoot().node(this.systemTreePath) : Preferences.systemRoot();
        this.userPrefs = this.userTreePath != null ? Preferences.userRoot().node(this.userTreePath) : Preferences.userRoot();
    }

    @Override
    protected String resolvePlaceholder(String placeholder, Properties props) {
        String value2;
        String path2 = null;
        String key = placeholder;
        int endOfPath = placeholder.lastIndexOf(47);
        if (endOfPath != -1) {
            path2 = placeholder.substring(0, endOfPath);
            key = placeholder.substring(endOfPath + 1);
        }
        if ((value2 = this.resolvePlaceholder(path2, key, this.userPrefs)) == null && (value2 = this.resolvePlaceholder(path2, key, this.systemPrefs)) == null) {
            value2 = props.getProperty(placeholder);
        }
        return value2;
    }

    protected String resolvePlaceholder(String path2, String key, Preferences preferences) {
        if (path2 != null) {
            try {
                if (preferences.nodeExists(path2)) {
                    return preferences.node(path2).get(key, null);
                }
                return null;
            }
            catch (BackingStoreException ex) {
                throw new BeanDefinitionStoreException("Cannot access specified node path [" + path2 + "]", ex);
            }
        }
        return preferences.get(key, null);
    }
}

