/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.util.StringValueResolver;

public class EmbeddedValueResolver
implements StringValueResolver {
    private final BeanExpressionContext exprContext;
    private final BeanExpressionResolver exprResolver;

    public EmbeddedValueResolver(ConfigurableBeanFactory beanFactory) {
        this.exprContext = new BeanExpressionContext(beanFactory, null);
        this.exprResolver = beanFactory.getBeanExpressionResolver();
    }

    @Override
    public String resolveStringValue(String strVal) {
        String value2 = this.exprContext.getBeanFactory().resolveEmbeddedValue(strVal);
        if (this.exprResolver != null && value2 != null) {
            Object evaluated = this.exprResolver.evaluate(value2, this.exprContext);
            value2 = evaluated != null ? evaluated.toString() : null;
        }
        return value2;
    }
}

