/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class BeanFactoryUtils {
    public static final String GENERATED_BEAN_NAME_SEPARATOR = "#";

    public static boolean isFactoryDereference(String name) {
        return name != null && name.startsWith("&");
    }

    public static String transformedBeanName(String name) {
        Assert.notNull(name, "'name' must not be null");
        String beanName = name;
        while (beanName.startsWith("&")) {
            beanName = beanName.substring("&".length());
        }
        return beanName;
    }

    public static boolean isGeneratedBeanName(String name) {
        return name != null && name.contains(GENERATED_BEAN_NAME_SEPARATOR);
    }

    public static String originalBeanName(String name) {
        Assert.notNull(name, "'name' must not be null");
        int separatorIndex = name.indexOf(GENERATED_BEAN_NAME_SEPARATOR);
        return separatorIndex != -1 ? name.substring(0, separatorIndex) : name;
    }

    public static int countBeansIncludingAncestors(ListableBeanFactory lbf) {
        return BeanFactoryUtils.beanNamesIncludingAncestors(lbf).length;
    }

    public static String[] beanNamesIncludingAncestors(ListableBeanFactory lbf) {
        return BeanFactoryUtils.beanNamesForTypeIncludingAncestors(lbf, Object.class);
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, ResolvableType type) {
        HierarchicalBeanFactory hbf;
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        String[] result2 = lbf.getBeanNamesForType(type);
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type);
            result2 = BeanFactoryUtils.mergeNamesWithParent(result2, parentResult, hbf);
        }
        return result2;
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, Class<?> type) {
        HierarchicalBeanFactory hbf;
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        String[] result2 = lbf.getBeanNamesForType(type);
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type);
            result2 = BeanFactoryUtils.mergeNamesWithParent(result2, parentResult, hbf);
        }
        return result2;
    }

    public static String[] beanNamesForTypeIncludingAncestors(ListableBeanFactory lbf, Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        HierarchicalBeanFactory hbf;
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        String[] result2 = lbf.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            String[] parentResult = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type, includeNonSingletons, allowEagerInit);
            result2 = BeanFactoryUtils.mergeNamesWithParent(result2, parentResult, hbf);
        }
        return result2;
    }

    public static <T> Map<String, T> beansOfTypeIncludingAncestors(ListableBeanFactory lbf, Class<T> type) throws BeansException {
        HierarchicalBeanFactory hbf;
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        LinkedHashMap<String, T> result2 = new LinkedHashMap<String, T>(4);
        result2.putAll(lbf.getBeansOfType(type));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            Map<String, T> parentResult = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type);
            for (Map.Entry<String, T> entry2 : parentResult.entrySet()) {
                String beanName = entry2.getKey();
                if (result2.containsKey(beanName) || hbf.containsLocalBean(beanName)) continue;
                result2.put(beanName, entry2.getValue());
            }
        }
        return result2;
    }

    public static <T> Map<String, T> beansOfTypeIncludingAncestors(ListableBeanFactory lbf, Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        HierarchicalBeanFactory hbf;
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        LinkedHashMap<String, T> result2 = new LinkedHashMap<String, T>(4);
        result2.putAll(lbf.getBeansOfType(type, includeNonSingletons, allowEagerInit));
        if (lbf instanceof HierarchicalBeanFactory && (hbf = (HierarchicalBeanFactory)((Object)lbf)).getParentBeanFactory() instanceof ListableBeanFactory) {
            Map<String, T> parentResult = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)hbf.getParentBeanFactory(), type, includeNonSingletons, allowEagerInit);
            for (Map.Entry<String, T> entry2 : parentResult.entrySet()) {
                String beanName = entry2.getKey();
                if (result2.containsKey(beanName) || hbf.containsLocalBean(beanName)) continue;
                result2.put(beanName, entry2.getValue());
            }
        }
        return result2;
    }

    public static <T> T beanOfTypeIncludingAncestors(ListableBeanFactory lbf, Class<T> type) throws BeansException {
        Map<String, T> beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, type);
        return BeanFactoryUtils.uniqueBean(type, beansOfType);
    }

    public static <T> T beanOfTypeIncludingAncestors(ListableBeanFactory lbf, Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        Map<String, T> beansOfType = BeanFactoryUtils.beansOfTypeIncludingAncestors(lbf, type, includeNonSingletons, allowEagerInit);
        return BeanFactoryUtils.uniqueBean(type, beansOfType);
    }

    public static <T> T beanOfType(ListableBeanFactory lbf, Class<T> type) throws BeansException {
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        Map<String, T> beansOfType = lbf.getBeansOfType(type);
        return BeanFactoryUtils.uniqueBean(type, beansOfType);
    }

    public static <T> T beanOfType(ListableBeanFactory lbf, Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        Assert.notNull(lbf, "ListableBeanFactory must not be null");
        Map<String, T> beansOfType = lbf.getBeansOfType(type, includeNonSingletons, allowEagerInit);
        return BeanFactoryUtils.uniqueBean(type, beansOfType);
    }

    private static String[] mergeNamesWithParent(String[] result2, String[] parentResult, HierarchicalBeanFactory hbf) {
        if (parentResult.length == 0) {
            return result2;
        }
        ArrayList<String> merged = new ArrayList<String>(result2.length + parentResult.length);
        merged.addAll(Arrays.asList(result2));
        for (String beanName : parentResult) {
            if (merged.contains(beanName) || hbf.containsLocalBean(beanName)) continue;
            merged.add(beanName);
        }
        return StringUtils.toStringArray(merged);
    }

    private static <T> T uniqueBean(Class<T> type, Map<String, T> matchingBeans) {
        int count2 = matchingBeans.size();
        if (count2 == 1) {
            return matchingBeans.values().iterator().next();
        }
        if (count2 > 1) {
            throw new NoUniqueBeanDefinitionException(type, matchingBeans.keySet());
        }
        throw new NoSuchBeanDefinitionException(type);
    }
}

