/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.lang.reflect.Field;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;

public abstract class TypeConverterSupport
extends PropertyEditorRegistrySupport
implements TypeConverter {
    TypeConverterDelegate typeConverterDelegate;

    @Override
    public <T> T convertIfNecessary(Object value2, Class<T> requiredType) throws TypeMismatchException {
        return this.doConvert(value2, requiredType, null, null);
    }

    @Override
    public <T> T convertIfNecessary(Object value2, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        return this.doConvert(value2, requiredType, methodParam, null);
    }

    @Override
    public <T> T convertIfNecessary(Object value2, Class<T> requiredType, Field field2) throws TypeMismatchException {
        return this.doConvert(value2, requiredType, null, field2);
    }

    private <T> T doConvert(Object value2, Class<T> requiredType, MethodParameter methodParam, Field field2) throws TypeMismatchException {
        try {
            if (field2 != null) {
                return this.typeConverterDelegate.convertIfNecessary(value2, requiredType, field2);
            }
            return this.typeConverterDelegate.convertIfNecessary(value2, requiredType, methodParam);
        }
        catch (ConverterNotFoundException ex) {
            throw new ConversionNotSupportedException(value2, requiredType, (Throwable)ex);
        }
        catch (ConversionException ex) {
            throw new TypeMismatchException(value2, requiredType, (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            throw new ConversionNotSupportedException(value2, requiredType, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeMismatchException(value2, requiredType, (Throwable)ex);
        }
    }
}

